/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.registry;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mrcrayfish.framework.api.menu.IMenuData;
import com.mrcrayfish.framework.api.registry.BlockRegistryEntry;
import com.mrcrayfish.framework.api.registry.CustomStatRegistryEntry;
import com.mrcrayfish.framework.api.registry.IRegisterFunction;
import com.mrcrayfish.framework.platform.Services;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_10295;
import net.minecraft.class_10355;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3446;
import net.minecraft.class_3611;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import org.apache.commons.lang3.function.TriFunction;

public sealed class RegistryEntry<T>
permits BlockRegistryEntry, CustomStatRegistryEntry {
    protected final class_2378<?> registry;
    protected final class_2960 id;
    protected final Supplier<T> supplier;
    private T instance;
    private class_6880<T> holder;

    RegistryEntry(class_2378<?> registry, class_2960 id, Supplier<T> supplier) {
        this.registry = registry;
        this.id = id;
        this.supplier = supplier;
    }

    public T get() {
        if (this.instance == null) {
            throw new IllegalStateException("Entry has not been created yet");
        }
        return this.instance;
    }

    public class_6880<T> holder() {
        if (this.holder == null) {
            throw new IllegalStateException("Entry has not been created yet");
        }
        return this.holder;
    }

    protected T create() {
        if (this.instance != null) {
            throw new IllegalStateException("Entry has already been created");
        }
        this.instance = this.supplier.get();
        return this.instance;
    }

    public class_2378<?> getRegistry() {
        return this.registry;
    }

    public class_2960 getId() {
        return this.id;
    }

    protected void invalidate() {
        this.instance = null;
        this.holder = null;
    }

    public void register(IRegisterFunction function) {
        function.call(this.registry, this.id, () -> {
            this.invalidate();
            return this.create();
        });
        this.holder = (class_6880)this.registry.method_10223(this.id).orElseThrow();
    }

    public static <T extends class_1320> RegistryEntry<T> attribute(class_2960 id, Supplier<T> attributeFactory) {
        return new RegistryEntry<T>(class_7923.field_41190, id, attributeFactory);
    }

    public static <T extends class_2248> RegistryEntry<T> block(class_2960 id, Function<class_4970.class_2251, T> blockFactory, Supplier<class_4970.class_2251> blockPropertiesFactory) {
        return new BlockRegistryEntry<class_2248, class_1747>((class_2378<?>)class_7923.field_41175, id, () -> {
            class_4970.class_2251 properties = (class_4970.class_2251)blockPropertiesFactory.get();
            return (class_2248)blockFactory.apply(properties.method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)id)));
        }, t -> null);
    }

    public static <T extends class_2248> RegistryEntry<T> blockWithItem(class_2960 id, Function<class_4970.class_2251, T> blockFactory, Supplier<class_4970.class_2251> blockPropertiesFactory) {
        return new BlockRegistryEntry<class_2248, class_1747>((class_2378<?>)class_7923.field_41175, id, () -> {
            class_4970.class_2251 properties = (class_4970.class_2251)blockPropertiesFactory.get();
            return (class_2248)blockFactory.apply(properties.method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)id)));
        }, t -> new class_1747(t, new class_1792.class_1793().method_63685().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)id))));
    }

    public static <T extends class_2248, E extends class_1747> RegistryEntry<T> blockWithItem(class_2960 id, Function<class_4970.class_2251, T> blockFactory, Supplier<class_4970.class_2251> blockPropertiesFactory, BiFunction<T, class_1792.class_1793, E> itemFactory, Supplier<class_1792.class_1793> itemPropertiesFactory) {
        return new BlockRegistryEntry<class_2248, class_1747>((class_2378<?>)class_7923.field_41175, id, () -> {
            class_4970.class_2251 blockProperties = (class_4970.class_2251)blockPropertiesFactory.get();
            return (class_2248)blockFactory.apply(blockProperties.method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)id)));
        }, t -> {
            class_1792.class_1793 itemProperties = (class_1792.class_1793)itemPropertiesFactory.get();
            return (class_1747)itemFactory.apply(t, itemProperties.method_63685().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)id)));
        });
    }

    public static <T extends class_2586> RegistryEntry<class_2591<T>> blockEntity(class_2960 id, BiFunction<class_2338, class_2680, T> blockEntityFactory, Supplier<class_2248[]> validBlocks) {
        return new RegistryEntry<class_2591<T>>(class_7923.field_41181, id, () -> Services.REGISTRATION.createBlockEntityType(blockEntityFactory, validBlocks));
    }

    public static <A extends ArgumentType<?>, T extends class_2314.class_7217<A>, I extends class_2314<A, T>> RegistryEntry<I> commandArgumentType(class_2960 id, Class<A> argumentTypeClass, Supplier<I> argumentTypeFactory) {
        return new RegistryEntry<class_2314>(class_7923.field_41192, id, () -> Services.REGISTRATION.createArgumentTypeInfo(argumentTypeClass, argumentTypeFactory));
    }

    public static RegistryEntry<class_1761> creativeModeTab(class_2960 id, Consumer<class_1761.class_7913> builderConsumer) {
        return new RegistryEntry<class_1761>(class_7923.field_44687, id, () -> {
            class_1761.class_7913 builder = Services.REGISTRATION.createCreativeModeTabBuilder();
            builderConsumer.accept(builder);
            return builder.method_47324();
        });
    }

    public static RegistryEntry<class_2960> customStat(class_2960 id, class_3446 formatter) {
        return new CustomStatRegistryEntry(class_7923.field_41183, id, formatter);
    }

    public static <T> RegistryEntry<class_9331<T>> dataComponentType(class_2960 id, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return new RegistryEntry<class_9331<T>>(class_7923.field_49658, id, () -> ((class_9331.class_9332)builderOperator.apply(class_9331.method_57873())).method_57880());
    }

    public static <T> RegistryEntry<class_9331<T>> enchantmentEffectComponentType(class_2960 id, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return new RegistryEntry<class_9331<T>>(class_7923.field_51832, id, () -> ((class_9331.class_9332)builderOperator.apply(class_9331.method_57873())).method_57880());
    }

    public static <T extends class_1297> RegistryEntry<class_1299<T>> entityType(class_2960 id, Supplier<class_1299.class_1300<T>> entityTypeFactory) {
        return new RegistryEntry<class_1299<T>>((class_2378<?>)class_7923.field_41177, id, () -> ((class_1299.class_1300)entityTypeFactory.get()).method_5905(class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)id)));
    }

    public static <T extends class_3611> RegistryEntry<T> fluid(class_2960 id, Supplier<T> fluidFactory) {
        return new RegistryEntry<T>((class_2378<?>)class_7923.field_41173, id, fluidFactory);
    }

    public static <T extends class_1792> RegistryEntry<T> item(class_2960 id, Function<class_1792.class_1793, T> itemFactory, Supplier<class_1792.class_1793> itemPropertiesFactory) {
        return new RegistryEntry<class_1792>((class_2378<?>)class_7923.field_41178, id, () -> {
            class_1792.class_1793 itemProperties = (class_1792.class_1793)itemPropertiesFactory.get();
            return (class_1792)itemFactory.apply(itemProperties.method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)id)));
        });
    }

    public static <T extends class_1703> RegistryEntry<class_3917<T>> menuType(class_2960 id, BiFunction<Integer, class_1661, T> menuFactory) {
        return new RegistryEntry<class_3917<T>>(class_7923.field_41187, id, () -> Services.REGISTRATION.createMenuType(menuFactory));
    }

    public static <T extends class_1703, D extends IMenuData<D>> RegistryEntry<class_3917<T>> menuTypeWithData(class_2960 id, class_9139<class_9129, D> dataCodec, TriFunction<Integer, class_1661, D, T> menuFactory) {
        return new RegistryEntry<class_3917<T>>(class_7923.field_41187, id, () -> Services.REGISTRATION.createMenuTypeWithData(dataCodec, menuFactory));
    }

    public static <T extends class_1291> RegistryEntry<T> mobEffect(class_2960 id, Supplier<T> mobEffectFactory) {
        return new RegistryEntry<T>(class_7923.field_41174, id, mobEffectFactory);
    }

    public static <T extends class_2396<?>> RegistryEntry<T> particleType(class_2960 id, Supplier<T> particleTypeFactory) {
        return new RegistryEntry<T>(class_7923.field_41180, id, particleTypeFactory);
    }

    public static <T extends class_1842> RegistryEntry<T> potion(class_2960 id, Supplier<T> potionFactory) {
        return new RegistryEntry<T>(class_7923.field_41179, id, potionFactory);
    }

    public static <T extends class_10295, D extends class_10295.class_10296<T>> RegistryEntry<D> recipeDisplay(class_2960 id, Supplier<D> recipeDisplayFactory) {
        return new RegistryEntry<D>(class_7923.field_54874, id, recipeDisplayFactory);
    }

    public static RegistryEntry<class_10355> recipeBookCategory(class_2960 id) {
        return new RegistryEntry<class_10355>(class_7923.field_54927, id, class_10355::new);
    }

    public static <T extends class_1860<?>> RegistryEntry<class_3956<T>> recipeType(final class_2960 id) {
        return new RegistryEntry<class_3956<T>>(class_7923.field_41188, id, () -> new class_3956<T>(){

            public String toString() {
                return id.method_12832();
            }
        });
    }

    public static <T extends class_1865<?>> RegistryEntry<T> recipeSerializer(class_2960 id, Supplier<T> recipeSerializerFactory) {
        return new RegistryEntry<T>(class_7923.field_41189, id, recipeSerializerFactory);
    }

    public static <T extends class_3414> RegistryEntry<T> soundEvent(class_2960 id, Function<class_2960, Supplier<T>> soundEventFactory) {
        return new RegistryEntry<T>(class_7923.field_41172, id, soundEventFactory.apply(id));
    }
}

