/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.platform.network;

import com.mrcrayfish.framework.Registration;
import com.mrcrayfish.framework.api.Environment;
import com.mrcrayfish.framework.api.FrameworkAPI;
import com.mrcrayfish.framework.api.network.ConfigurationMessageContext;
import com.mrcrayfish.framework.api.network.FrameworkNetwork;
import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.util.TaskRunner;
import com.mrcrayfish.framework.network.message.ConfigurationMessage;
import com.mrcrayfish.framework.network.message.FrameworkMessage;
import com.mrcrayfish.framework.network.message.FrameworkPayload;
import com.mrcrayfish.framework.network.message.PlayMessage;
import com.mrcrayfish.framework.platform.network.FabricClientNetworkHandler;
import com.mrcrayfish.framework.platform.network.FabricConfigurationTask;
import com.mrcrayfish.framework.platform.network.FabricServerNetworkHandler;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public final class FabricNetwork
implements FrameworkNetwork,
Registration.Event {
    final class_2960 id;
    final int protocolVersion;
    final List<PlayMessage<?>> playMessages;
    final List<ConfigurationMessage<?>> configurationMessages;
    final Map<Class<?>, FrameworkMessage<?, ? extends class_2540, ? extends MessageContext>> classToMessage;
    final List<BiFunction<FabricNetwork, class_8610, class_8605>> configurationTasks;
    final ConfigurationMessage<Ping> pingMessage;
    private MinecraftServer server;
    private boolean active = false;
    private boolean registered = false;

    public FabricNetwork(class_2960 id, int protocolVersion, List<PlayMessage<?>> playMessages, List<ConfigurationMessage<?>> configurationMessages, List<BiFunction<FabricNetwork, class_8610, class_8605>> configurationTasks) {
        this.id = id;
        this.protocolVersion = protocolVersion;
        this.playMessages = playMessages;
        this.configurationMessages = configurationMessages;
        this.configurationTasks = configurationTasks;
        this.classToMessage = FabricNetwork.createClassMap(playMessages, configurationMessages);
        this.pingMessage = this.configurationMessages.stream().filter(msg -> msg.messageClass() == Ping.class).findFirst().map(msg -> msg).orElseThrow(() -> new RuntimeException("Failed to setup Fabric network. Missing Ping configuration message"));
        this.setup();
    }

    @Override
    public class_2960 id() {
        return this.id;
    }

    private void setup() {
        this.playMessages.forEach(message -> {
            if (message.flow() == class_2598.field_11942 || message.flow() == null) {
                this.registerPlayS2C((PlayMessage)message);
            }
            if (message.flow() == class_2598.field_11941 || message.flow() == null) {
                this.registerPlayC2S((PlayMessage)message);
            }
        });
        PayloadTypeRegistry.configurationS2C().register(this.pingMessage.type(), this.pingMessage.codec());
        PayloadTypeRegistry.configurationC2S().register(this.pingMessage.type(), this.pingMessage.codec());
        TaskRunner.runIf(Environment.CLIENT, () -> () -> {
            ClientConfigurationConnectionEvents.INIT.register((handler, client) -> ClientConfigurationNetworking.registerReceiver(this.pingMessage.type(), (payload, context) -> {
                this.active = true;
            }));
            ClientPlayConnectionEvents.DISCONNECT.register((handler1, client1) -> {
                this.active = false;
            });
        });
        this.configurationMessages.stream().filter(message -> message.flow() == null || message.flow() == class_2598.field_11942).forEach(this::registerConfigurationS2C);
        this.configurationMessages.stream().filter(message -> message.flow() == null || message.flow() == class_2598.field_11941).forEach(this::registerConfigurationC2S);
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> this.configurationTasks.forEach(function -> {
            FabricConfigurationTask task = (FabricConfigurationTask)function.apply(this, handler);
            if (ServerConfigurationNetworking.canSend((class_8610)handler, (class_2960)task.id())) {
                handler.addTask((class_8605)task);
            }
        }));
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.server = server;
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            this.server = null;
        });
    }

    private <T> void registerPlayS2C(PlayMessage<T> message) {
        PayloadTypeRegistry.playS2C().register(message.type(), message.codec());
        Optional.ofNullable(message.flow()).ifPresent(flow -> PayloadTypeRegistry.playC2S().register(message.type(), message.codec()));
        TaskRunner.runIf(Environment.CLIENT, () -> () -> ClientPlayNetworking.registerGlobalReceiver(message.type(), (payload, context) -> FabricClientNetworkHandler.receivePlay(message, payload, this, context)));
    }

    private <T> void registerPlayC2S(PlayMessage<T> message) {
        PayloadTypeRegistry.playC2S().register(message.type(), message.codec());
        Optional.ofNullable(message.flow()).ifPresent(flow -> PayloadTypeRegistry.playS2C().register(message.type(), message.codec()));
        ServerPlayNetworking.registerGlobalReceiver(message.type(), (payload, context) -> FabricServerNetworkHandler.receivePlay(message, payload, this, context));
    }

    private <T> void registerConfigurationS2C(ConfigurationMessage<T> message) {
        if (message == this.pingMessage) {
            return;
        }
        PayloadTypeRegistry.configurationS2C().register(message.type(), message.codec());
        Optional.ofNullable(message.flow()).ifPresent(flow -> PayloadTypeRegistry.configurationC2S().register(message.type(), message.codec()));
        TaskRunner.runIf(Environment.CLIENT, () -> () -> ClientConfigurationConnectionEvents.INIT.register((handler, client) -> ClientConfigurationNetworking.registerGlobalReceiver(message.type(), (payload, context) -> FabricClientNetworkHandler.receiveConfiguration(message, payload, this, context))));
    }

    private <T> void registerConfigurationC2S(ConfigurationMessage<T> message) {
        if (message == this.pingMessage) {
            return;
        }
        PayloadTypeRegistry.configurationC2S().register(message.type(), message.codec());
        Optional.ofNullable(message.flow()).ifPresent(flow -> PayloadTypeRegistry.configurationS2C().register(message.type(), message.codec()));
        ServerConfigurationNetworking.registerGlobalReceiver(message.type(), (payload, context) -> FabricServerNetworkHandler.receiveConfiguration(message, payload, this, context));
    }

    @Override
    public void send(class_2535 connection, Object message) {
        switch (connection.method_36122()) {
            case field_11941: {
                connection.method_10743(ClientPlayNetworking.createC2SPacket(this.encode(message)));
                break;
            }
            case field_11942: {
                connection.method_10743(ServerPlayNetworking.createS2CPacket(this.encode(message)));
            }
        }
    }

    @Override
    public void sendToPlayer(Supplier<class_3222> supplier, Object message) {
        ServerPlayNetworking.send((class_3222)supplier.get(), this.encode(message));
    }

    @Override
    public void sendToTrackingEntity(Supplier<class_1297> supplier, Object message) {
        class_1297 entity = supplier.get();
        class_2596 packet = ServerPlayNetworking.createS2CPacket(this.encode(message));
        ((class_3215)entity.method_37908().method_8398()).method_18754(entity, packet);
    }

    @Override
    public void sendToTrackingBlockEntity(Supplier<class_2586> supplier, Object message) {
        this.sendToTrackingChunk(() -> {
            class_2586 entity = (class_2586)supplier.get();
            return Objects.requireNonNull(entity.method_10997()).method_8500(entity.method_11016());
        }, message);
    }

    @Override
    public void sendToTrackingLocation(Supplier<LevelLocation> supplier, Object message) {
        this.sendToTrackingChunk(() -> {
            LevelLocation location = (LevelLocation)supplier.get();
            class_243 pos = location.pos();
            int chunkX = class_4076.method_42615((double)pos.field_1352);
            int chunkZ = class_4076.method_42615((double)pos.field_1350);
            return location.level().method_8497(chunkX, chunkZ);
        }, message);
    }

    @Override
    public void sendToTrackingChunk(Supplier<class_2818> supplier, Object message) {
        class_2818 chunk = supplier.get();
        class_2596 packet = ServerPlayNetworking.createS2CPacket(this.encode(message));
        ((class_3215)chunk.method_12200().method_8398()).field_17254.method_17210(chunk.method_12004(), false).forEach(e -> e.field_13987.method_14364(packet));
    }

    @Override
    public void sendToNearbyPlayers(Supplier<LevelLocation> supplier, Object message) {
        LevelLocation location = supplier.get();
        class_3218 level = location.level();
        class_243 pos = location.pos();
        class_2596 packet = ServerPlayNetworking.createS2CPacket(this.encode(message));
        this.server.method_3760().method_14605(null, pos.field_1352, pos.field_1351, pos.field_1350, location.range(), level.method_27983(), packet);
    }

    @Override
    public void sendToServer(Object message) {
        TaskRunner.runIf(Environment.CLIENT, () -> () -> ClientPlayNetworking.send(this.encode(message)));
    }

    @Override
    public void sendToAll(Object message) {
        class_2596 packet = ServerPlayNetworking.createS2CPacket(this.encode(message));
        this.server.method_3760().method_14581(packet);
    }

    @Override
    public boolean isActive(class_2535 connection) {
        this.throwIfUnregisteredNetwork();
        return !FrameworkAPI.getEnvironment().isClient() || this.active;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FabricNetwork that = (FabricNetwork)o;
        return this.id.equals((Object)that.id);
    }

    @Override
    public void onRegistered() {
        this.registered = true;
    }

    private void throwIfUnregisteredNetwork() {
        if (!this.registered) {
            throw new RuntimeException("FrameworkNetwork not registered: " + String.valueOf(this.id));
        }
    }

    <T> FrameworkPayload<T> encode(Object message) {
        this.throwIfUnregisteredNetwork();
        FrameworkMessage<?, class_2540, MessageContext> msg = this.classToMessage.get(message.getClass());
        if (msg == null) {
            throw new IllegalArgumentException("Unregistered message: " + message.getClass().getName());
        }
        return msg.writePayload(message);
    }

    private static Map<Class<?>, FrameworkMessage<?, ? extends class_2540, ? extends MessageContext>> createClassMap(Collection<PlayMessage<?>> a, List<ConfigurationMessage<?>> b) {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        a.forEach(arg_0 -> FabricNetwork.lambda$createClassMap$33((Object2ObjectMap)map, arg_0));
        b.forEach(arg_0 -> FabricNetwork.lambda$createClassMap$34((Object2ObjectMap)map, arg_0));
        return Collections.unmodifiableMap(map);
    }

    private static /* synthetic */ void lambda$createClassMap$34(Object2ObjectMap map, ConfigurationMessage msg) {
        map.put(msg.messageClass(), (Object)msg);
    }

    private static /* synthetic */ void lambda$createClassMap$33(Object2ObjectMap map, PlayMessage msg) {
        map.put(msg.messageClass(), (Object)msg);
    }

    record Ping() {
        public static final Ping INSTANCE = new Ping();
        public static final class_9139<class_2540, Ping> STREAM_CODEC = class_9139.method_56431((Object)INSTANCE);

        public static void encode(Ping message, class_2540 buffer) {
        }

        public static Ping decode(class_2540 buffer) {
            return new Ping();
        }

        public static void handle(Ping message, ConfigurationMessageContext context) {
            context.setHandled(true);
        }
    }
}

