/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers;

import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5489;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.Nullable;

public class LabelController
implements Controller<class_2561> {
    private final Option<class_2561> option;

    public LabelController(Option<class_2561> option) {
        this.option = option;
    }

    @Override
    public Option<class_2561> option() {
        return this.option;
    }

    @Override
    public class_2561 formatValue() {
        return this.option().pendingValue();
    }

    @Override
    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new LabelControllerElement(screen, widgetDimension);
    }

    public class LabelControllerElement
    extends AbstractWidget {
        private List<class_5481> wrappedText;
        protected class_5489 wrappedTooltip;
        protected boolean focused;
        protected final YACLScreen screen;

        public LabelControllerElement(YACLScreen screen, Dimension<Integer> dim) {
            super(dim);
            this.screen = screen;
            LabelController.this.option().addListener((opt, pending) -> this.updateTooltip());
            this.updateTooltip();
            this.updateText();
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            class_2583 style;
            this.updateText();
            int y = this.getDimension().y();
            for (class_5481 text : this.wrappedText) {
                graphics.method_51430(this.textRenderer, text, this.getDimension().x() + this.getXPadding(), y + this.getYPadding(), LabelController.this.option().available() ? -1 : -6250336, true);
                Objects.requireNonNull(this.textRenderer);
                y += 9;
            }
            if (this.method_25370()) {
                graphics.method_25294(this.getDimension().x() - 1, this.getDimension().y() - 1, this.getDimension().xLimit() + 1, this.getDimension().y().intValue(), -1);
                graphics.method_25294(this.getDimension().x() - 1, this.getDimension().y() - 1, this.getDimension().x().intValue(), this.getDimension().yLimit() + 1, -1);
                graphics.method_25294(this.getDimension().x() - 1, this.getDimension().yLimit().intValue(), this.getDimension().xLimit() + 1, this.getDimension().yLimit() + 1, -1);
                graphics.method_25294(this.getDimension().xLimit().intValue(), this.getDimension().y() - 1, this.getDimension().xLimit() + 1, this.getDimension().yLimit() + 1, -1);
            }
            GuiUtils.pushPose(graphics);
            GuiUtils.translateZ(graphics, 100.0f);
            if (this.method_25405(mouseX, mouseY) && (style = this.getStyle(mouseX, mouseY)) != null && style.method_10969() != null) {
                class_2568 hoverEvent = style.method_10969();
                graphics.method_51441(this.textRenderer, style, mouseX, mouseY);
            }
            GuiUtils.popPose(graphics);
        }

        @Override
        public boolean onMouseClicked(double mouseX, double mouseY, int button) {
            if (!this.method_25405(mouseX, mouseY)) {
                return false;
            }
            class_2583 style = this.getStyle((int)mouseX, (int)mouseY);
            if (style == null) {
                return false;
            }
            return this.screen.method_25430(style);
        }

        @Nullable
        protected class_2583 getStyle(int mouseX, int mouseY) {
            if (!this.getDimension().isPointInside(mouseX, mouseY)) {
                return null;
            }
            int x = mouseX - this.getDimension().x() - this.getXPadding();
            int y = mouseY - this.getDimension().y() - this.getYPadding();
            Objects.requireNonNull(this.textRenderer);
            int line = y / 9;
            if (x < 0 || x > this.getDimension().xLimit()) {
                return null;
            }
            if (y < 0 || y > this.getDimension().yLimit()) {
                return null;
            }
            if (line < 0 || line >= this.wrappedText.size()) {
                return null;
            }
            return this.textRenderer.method_27527().method_30876(this.wrappedText.get(line), x);
        }

        private int getXPadding() {
            return 4;
        }

        private int getYPadding() {
            return 3;
        }

        private void updateText() {
            this.wrappedText = this.textRenderer.method_1728((class_5348)LabelController.this.formatValue(), this.getDimension().width() - this.getXPadding() * 2);
            Dimension<Integer> dimension = this.getDimension();
            int n = this.wrappedText.size();
            Objects.requireNonNull(this.textRenderer);
            this.setDimension(dimension.withHeight(n * 9 + this.getYPadding() * 2));
        }

        private void updateTooltip() {
            this.wrappedTooltip = class_5489.method_30890((class_327)this.textRenderer, (class_2561)LabelController.this.option().tooltip(), (int)(this.screen.field_22789 / 3 * 2 - 10));
        }

        @Override
        public boolean matchesSearch(String query) {
            return LabelController.this.formatValue().getString().toLowerCase().contains(query.toLowerCase());
        }

        @Nullable
        public class_8016 method_48205(class_8023 focusNavigationEvent) {
            if (!LabelController.this.option().available()) {
                return null;
            }
            return !this.method_25370() ? class_8016.method_48193((class_364)this) : null;
        }

        public boolean method_25370() {
            return this.focused;
        }

        public void method_25365(boolean focused) {
            this.focused = focused;
        }

        @Override
        public void method_37020(class_6382 builder) {
            builder.method_37034(class_6381.field_33788, LabelController.this.formatValue());
        }

        @Override
        public class_6379.class_6380 method_37018() {
            return class_6379.class_6380.field_33786;
        }
    }
}

