/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.furniture.refurbished.Constants;
import com.mrcrayfish.furniture.refurbished.client.LinkHandler;
import com.mrcrayfish.furniture.refurbished.core.ModRenderPipelines;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import net.minecraft.class_1041;
import net.minecraft.class_1044;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_6367;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9848;
import net.minecraft.class_9909;
import net.minecraft.class_9916;
import net.minecraft.class_9925;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class DeferredElectricRenderer
implements class_4013 {
    public static final String PASS_NAME = "refurbished_furniture_electricity";
    public static final class_2960 ID = Utils.resource("deferred_electric_renderer");
    private static DeferredElectricRenderer instance;
    private final class_2960 nodeTexture = Utils.resource("textures/misc/electricity_nodes.png");
    private final List<BiConsumer<class_4587, class_4588>> deferredDrawCalls = new LinkedList<BiConsumer<class_4587, class_4588>>();
    @Nullable
    private Class<?> irisClass;
    private Method shaderPack;
    private Boolean shaderEnabled;
    private class_6367 electricityTarget;
    private class_9925<class_6367> handle;

    public static DeferredElectricRenderer get() {
        if (instance == null) {
            instance = new DeferredElectricRenderer();
        }
        return instance;
    }

    private DeferredElectricRenderer() {
        this.setupIrisSupport();
    }

    private void setupIrisSupport() {
        try {
            this.irisClass = Class.forName("net.irisshaders.iris.Iris");
            this.shaderPack = this.irisClass.getDeclaredMethod("getCurrentPack", new Class[0]);
            this.shaderPack.setAccessible(true);
            Constants.LOG.info("Iris detected! Will use modified rendering for electricity when shaders are enabled");
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to locate Iris shader pack getter", e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public boolean isIrisShadersEnabled() {
        if (this.irisClass != null && this.shaderPack != null && this.shaderEnabled == null) {
            try {
                Optional optional = (Optional)this.shaderPack.invoke(null, new Object[0]);
                this.shaderEnabled = optional.isPresent();
                return this.shaderEnabled;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke shader pack getter", e);
            }
        }
        return this.shaderEnabled != null && this.shaderEnabled != false;
    }

    public void method_14491(class_3300 manager) {
        if (this.electricityTarget != null) {
            this.electricityTarget.method_1238();
        }
        class_1041 window = class_310.method_1551().method_22683();
        this.electricityTarget = new class_6367("Refurbished Furniture Electricity Overlay", window.method_4489(), window.method_4506(), true);
    }

    public void resize(int width, int height) {
        if (this.electricityTarget != null) {
            this.electricityTarget.method_1234(width, height);
        }
    }

    public void deferDraw(BiConsumer<class_4587, class_4588> consumer) {
        this.deferredDrawCalls.add(consumer);
    }

    public void setupFramePass(class_9909 builder, class_4184 camera) {
        this.shaderEnabled = null;
        if (this.electricityTarget != null && LinkHandler.isHoldingWrench()) {
            class_9925 handle = builder.method_61914(PASS_NAME, (Object)this.electricityTarget);
            class_9916 pass = builder.method_61911(PASS_NAME);
            this.handle = pass.method_61933(handle);
            pass.method_61929(() -> {
                GpuTexture colorTexture = this.electricityTarget.method_30277();
                GpuTexture depthTexture = this.electricityTarget.method_30278();
                RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(colorTexture, 0, depthTexture, 1.0);
                if (!this.isIrisShadersEnabled()) {
                    class_4587 stack = new class_4587();
                    class_243 view = camera.method_19326();
                    stack.method_22904(-view.method_10216(), -view.method_10214(), -view.method_10215());
                    this.drawDeferredCalls(stack);
                }
            });
        } else {
            this.deferredDrawCalls.clear();
        }
    }

    private void drawDeferredCalls(class_4587 pose) {
        if (this.deferredDrawCalls.isEmpty()) {
            return;
        }
        RenderPipeline pipeline = ModRenderPipelines.ELECTRICITY;
        try (class_9799 quadBuilder = new class_9799(pipeline.getVertexFormat().getVertexSize() * 4);){
            class_287 vertexBuilder = new class_287(quadBuilder, pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
            this.deferredDrawCalls.forEach(consumer -> consumer.accept(pose, vertexBuilder));
            try (class_9801 data = vertexBuilder.method_60794();){
                this.uploadMeshToElectricityTexture(data);
            }
        }
        this.deferredDrawCalls.clear();
    }

    private void uploadMeshToElectricityTexture(@Nullable class_9801 data) {
        if (data == null) {
            return;
        }
        class_6367 target = this.electricityTarget;
        RenderPipeline pipeline = ModRenderPipelines.ELECTRICITY;
        class_1044 texture = class_310.method_1551().method_1531().method_4619(this.nodeTexture);
        GpuBufferSlice slice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
        RenderSystem.class_5590 autoIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)pipeline.getVertexFormatMode());
        GpuBuffer indexBuffer = autoIndexBuffer.method_68274(data.method_60822().comp_751());
        GpuBuffer vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Deferred Electricity Renderer", 40, data.method_60818().remaining());
        RenderSystem.getDevice().createCommandEncoder().writeToBuffer(vertexBuffer.slice(), data.method_60818());
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Deferred Electricity Renderer", target.method_71639(), OptionalInt.empty(), target.method_71640(), OptionalDouble.empty());){
            pass.setPipeline(pipeline);
            RenderSystem.bindDefaultUniforms((RenderPass)pass);
            pass.setVertexBuffer(0, vertexBuffer);
            pass.setUniform("DynamicTransforms", slice);
            pass.setIndexBuffer(indexBuffer, autoIndexBuffer.method_31924());
            pass.bindSampler("Sampler0", texture.method_71659());
            pass.drawIndexed(0, 0, data.method_60822().comp_751(), 1);
        }
    }

    public void blitToScreen(Matrix4f projMatrix, class_4184 camera) {
        if (this.isIrisShadersEnabled()) {
            class_4587 stack = new class_4587();
            class_243 view = camera.method_19326();
            stack.method_34425((Matrix4fc)projMatrix);
            stack.method_22904(-view.method_10216(), -view.method_10214(), -view.method_10215());
            this.drawDeferredCalls(stack);
        }
        GpuTextureView mainColor = class_310.method_1551().method_1522().method_71639();
        GpuTextureView electricityColorView = this.electricityTarget.method_71639();
        if (this.handle != null && electricityColorView != null && mainColor != null) {
            RenderSystem.class_5590 autoIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
            GpuBuffer indexBuffer = autoIndexBuffer.method_68274(6);
            GpuBuffer vertexBuffer = RenderSystem.getQuadVertexBuffer();
            try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Blit", mainColor, OptionalInt.empty());){
                pass.setPipeline(ModRenderPipelines.ELECTRICITY_BLIT);
                pass.setVertexBuffer(0, vertexBuffer);
                pass.setIndexBuffer(indexBuffer, autoIndexBuffer.method_31924());
                pass.bindSampler("InSampler", electricityColorView);
                pass.drawIndexed(0, 0, 6, 1);
            }
        }
        this.handle = null;
    }

    public void drawColouredBox(Matrix4f matrix, class_4588 consumer, class_238 box, int colour, float alpha) {
        float red = (float)class_9848.method_61327((int)colour) / 255.0f;
        float green = (float)class_9848.method_61329((int)colour) / 255.0f;
        float blue = (float)class_9848.method_61331((int)colour) / 255.0f;
        float minU = 0.0f;
        float minV = 0.25f;
        float maxU = minU + 0.25f;
        float maxV = minV + 0.25f;
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
    }

    public void drawInvertedColouredBox(Matrix4f matrix, class_4588 consumer, class_238 box, int colour, float alpha) {
        float red = (float)class_9848.method_61327((int)colour) / 255.0f;
        float green = (float)class_9848.method_61329((int)colour) / 255.0f;
        float blue = (float)class_9848.method_61331((int)colour) / 255.0f;
        float minU = 0.0f;
        float minV = 0.25f;
        float maxU = minU + 0.25f;
        float maxV = minV + 0.25f;
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
    }

    public void drawTexturedBox(Matrix4f matrix, class_4588 consumer, class_238 box, float minU, float minV, float maxU, float maxV) {
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(minU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(minU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(maxU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(minU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(minU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(maxU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(maxU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(minU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(minU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(maxU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(maxU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(minU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(minU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(maxV, minU).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(minV, minU).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(minV, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(maxV, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(maxU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(minU, minV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(minU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(maxU, maxV).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

