/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.framework.api.config.event.FrameworkConfigEvents;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.DeferredElectricRenderer;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.ElectricBlockEntityRenderer;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModRenderPipelines;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.electricity.ISourceNode;
import com.mrcrayfish.furniture.refurbished.electricity.LinkHitResult;
import com.mrcrayfish.furniture.refurbished.electricity.NodeHitResult;
import com.mrcrayfish.furniture.refurbished.item.WrenchItem;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageDeleteLink;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_7833;
import net.minecraft.class_9779;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Intersectiond;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class LinkHandler {
    private static final class_2960 POWERABLE_AREA = Utils.resource("textures/misc/powerable_area.png");
    private static final class_2960 UNPOWERABLE_AREA = Utils.resource("textures/misc/unpowerable_area.png");
    private static final int DEFAULT_LINK_COLOUR = -1;
    private static final int SUCCESS_LINK_COLOUR = -4849844;
    private static final int ERROR_LINK_COLOUR = -3983818;
    private static final double NEAR_DISTANCE = 10.0;
    private static LinkHandler instance;
    @Nullable
    private class_2338 lastNodePos;
    private class_239 result;
    private double linkLength;
    private boolean linkInsideArea;
    private final Set<class_2338> sourcePositions = new HashSet<class_2338>();
    private final Set<class_2338> lastSourcePositions = new HashSet<class_2338>();
    private class_265 cachedPowerableAreaShape;

    public static LinkHandler get() {
        if (instance == null) {
            instance = new LinkHandler();
        }
        return instance;
    }

    private LinkHandler() {
        FrameworkConfigEvents.RELOAD.register(object -> {
            if (object == Config.SERVER) {
                this.lastSourcePositions.clear();
                this.cachedPowerableAreaShape = null;
            }
        });
    }

    public void setLinkingNode(class_2338 pos) {
        this.lastNodePos = pos;
    }

    public boolean isLinkingNode(IElectricityNode node) {
        return this.lastNodePos != null && this.lastNodePos.equals((Object)node.getNodePosition());
    }

    public boolean isLinking() {
        return this.lastNodePos != null;
    }

    public boolean isLinkInsidePowerableArea() {
        return this.linkInsideArea;
    }

    @Nullable
    public IElectricityNode getLinkingNode(class_1937 level) {
        if (this.lastNodePos == null) {
            return null;
        }
        class_2586 class_25862 = level.method_8321(this.lastNodePos);
        if (class_25862 instanceof IElectricityNode) {
            IElectricityNode node = (IElectricityNode)class_25862;
            return node;
        }
        return null;
    }

    public double getLinkLength() {
        return this.lastNodePos != null ? this.linkLength : 0.0;
    }

    public void beforeRender(float partialTick) {
        this.updateHitResult(partialTick);
        this.updatePowerSources();
        this.updateLinkState(partialTick);
    }

    private void updateHitResult(float partialTick) {
        class_239 last = this.result;
        this.result = null;
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null && mc.field_1687 != null && mc.field_1761 != null && mc.field_1724.method_6047().method_31574((class_1792)ModItems.WRENCH.get())) {
            double range = mc.field_1724.method_55754();
            NodeHitResult newResult = WrenchItem.performNodeRaycast((class_1937)mc.field_1687, (class_1657)mc.field_1724, range, partialTick);
            if (newResult.method_17783() == class_239.class_240.field_1333) {
                newResult = this.performLinkRaycast((class_1657)mc.field_1724, partialTick, range);
            }
            if (newResult.method_17783() != class_239.class_240.field_1333) {
                this.playHoverSound(last, newResult, (class_1657)mc.field_1724, (class_1937)mc.field_1687);
                this.result = newResult;
            }
        }
    }

    private void playHoverSound(@Nullable class_239 oldResult, @Nullable class_239 newResult, class_1657 player, class_1937 level) {
        if ((oldResult == null || !oldResult.equals(newResult)) && newResult instanceof LinkHitResult) {
            if (this.lastNodePos != null) {
                return;
            }
            class_243 pos = newResult.method_17784();
            float pitch = 1.0f + 0.05f * level.field_9229.method_43057();
            level.method_43128((class_1297)player, pos.field_1352, pos.field_1351, pos.field_1350, (class_3414)ModSounds.ITEM_WRENCH_HOVER_LINK.get(), class_3419.field_15245, 1.0f, pitch);
        }
    }

    private void updatePowerSources() {
        Connection connection;
        this.sourcePositions.clear();
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        IElectricityNode linking = this.getLinkingNode((class_1937)mc.field_1687);
        this.addSourceNodePositions(this.sourcePositions, this.getLinkingNode((class_1937)mc.field_1687));
        IElectricityNode target = this.getTargetNode();
        if (linking != null && !linking.isSourceNode()) {
            if (target != null && target.isSourceNode()) {
                this.sourcePositions.clear();
            }
            if (this.sourcePositions.isEmpty()) {
                this.addSourceNodePositions(this.sourcePositions, target);
            }
        }
        if (linking == null && target == null && (connection = this.getTargetConnection()) != null && connection.isCrossingPowerableZone((class_1937)mc.field_1687)) {
            Sets.SetView delta;
            IElectricityNode a = connection.getNodeA((class_1937)mc.field_1687);
            IElectricityNode b = connection.getNodeB((class_1937)mc.field_1687);
            if (a != null && b != null && !(delta = Sets.symmetricDifference(a.getPowerSources(), b.getPowerSources())).isEmpty()) {
                this.sourcePositions.add((class_2338)List.copyOf(delta).get(0));
            }
        }
    }

    private void updateLinkState(float partialTick) {
        this.linkInsideArea = false;
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return;
        }
        if (this.sourcePositions.isEmpty()) {
            this.linkInsideArea = true;
        } else if (this.lastNodePos != null) {
            this.linkInsideArea = this.sourcePositions.stream().anyMatch(pos -> {
                class_238 box = ISourceNode.createPowerableZone((class_1937)mc.field_1687, pos);
                return box.method_1006(this.lastNodePos.method_46558()) && box.method_1006(this.getLinkEnd((class_1657)mc.field_1724, partialTick));
            });
        } else {
            class_239 class_2393 = this.result;
            if (class_2393 instanceof LinkHitResult) {
                LinkHitResult hitResult = (LinkHitResult)class_2393;
                Connection connection = hitResult.getConnection();
                class_243 start = connection.getPosA().method_46558();
                class_243 end = connection.getPosB().method_46558();
                this.linkInsideArea = this.sourcePositions.stream().anyMatch(pos -> {
                    class_238 box = ISourceNode.createPowerableZone((class_1937)mc.field_1687, pos);
                    return box.method_1006(start) && box.method_1006(end);
                });
            }
        }
    }

    private void addSourceNodePositions(Set<class_2338> positions, @Nullable IElectricityNode start) {
        if (start == null) {
            return;
        }
        if (start.isSourceNode()) {
            positions.add(start.getNodePosition());
            return;
        }
        int searchLimit = (Integer)Config.SERVER.electricity.maximumNodesInNetwork.get();
        IElectricityNode.searchNodes(start, searchLimit, true, node -> !node.isSourceNode(), IElectricityNode::isSourceNode).forEach(node -> positions.add(node.getNodePosition()));
    }

    public boolean isTargetNode(IElectricityNode node) {
        NodeHitResult nodeResult;
        class_239 class_2393 = this.result;
        return class_2393 instanceof NodeHitResult && (nodeResult = (NodeHitResult)class_2393).getNode() == node;
    }

    @Nullable
    public IElectricityNode getTargetNode() {
        IElectricityNode iElectricityNode;
        class_239 class_2393 = this.result;
        if (class_2393 instanceof NodeHitResult) {
            NodeHitResult nodeResult = (NodeHitResult)class_2393;
            iElectricityNode = nodeResult.getNode();
        } else {
            iElectricityNode = null;
        }
        return iElectricityNode;
    }

    @Nullable
    public Connection getTargetConnection() {
        Connection connection;
        class_239 class_2393 = this.result;
        if (class_2393 instanceof LinkHitResult) {
            LinkHitResult linkResult = (LinkHitResult)class_2393;
            connection = linkResult.getConnection();
        } else {
            connection = null;
        }
        return connection;
    }

    public void render(class_1657 player, class_4587 poseStack, class_9779 tracker) {
        if (!player.method_5805() || !LinkHandler.isHoldingWrench()) {
            this.lastNodePos = null;
        }
        this.renderPowerableArea(poseStack, player, tracker.method_60637(true));
        if (this.lastNodePos != null) {
            this.renderUnfinishedLink(player, tracker);
        }
    }

    private void renderUnfinishedLink(class_1657 player, class_9779 tracker) {
        DeferredElectricRenderer renderer = DeferredElectricRenderer.get();
        renderer.deferDraw((pose, consumer) -> {
            if (this.lastNodePos == null) {
                return;
            }
            class_243 start = class_243.method_24953((class_2382)this.lastNodePos);
            class_243 end = this.getLinkEnd(player, tracker.method_60637(true));
            class_243 delta = end.method_1020(start);
            this.linkLength = delta.method_1033();
            double yaw = Math.atan2(-delta.field_1350, delta.field_1352) + Math.PI;
            double pitch = Math.atan2(delta.method_37267(), delta.field_1351) + 1.5707963705062866;
            pose.method_22903();
            pose.method_22904(start.field_1352, start.field_1351, start.field_1350);
            pose.method_22907((Quaternionfc)class_7833.field_40716.rotation((float)yaw));
            pose.method_22907((Quaternionfc)class_7833.field_40718.rotation((float)pitch));
            int color = this.getLinkColour(player.method_37908());
            Matrix4f matrix = pose.method_23760().method_23761();
            renderer.drawColouredBox(matrix, (class_4588)consumer, new class_238(0.0, -0.03125, -0.03125, delta.method_1033(), 0.03125, 0.03125), color, 0.8f);
            renderer.drawColouredBox(matrix, (class_4588)consumer, new class_238(0.0, -0.03125, -0.03125, delta.method_1033(), 0.03125, 0.03125).method_1014(0.03125), color, 0.6f);
            pose.method_22909();
        });
    }

    private class_243 getLinkEnd(class_1657 player, float partialTick) {
        IElectricityNode node = this.getTargetNode();
        if (node != null && !this.isLinkingNode(node) && this.canLinkToNode(player.method_37908(), node)) {
            return node.getNodePosition().method_46558();
        }
        return player.method_5828(partialTick).method_1029().method_1021(1.5).method_1019(player.method_5836(partialTick));
    }

    public int getLinkColour(class_1937 level) {
        IElectricityNode linking = this.getLinkingNode(level);
        if (linking == null) {
            return -1;
        }
        if (this.linkLength > 512.0) {
            return -3983818;
        }
        IElectricityNode target = this.getTargetNode();
        if (target != null && !this.isLinkingNode(target)) {
            if (this.canLinkToNode(level, target)) {
                return -4849844;
            }
            return -3983818;
        }
        if (!this.linkInsideArea) {
            return -3983818;
        }
        return -1;
    }

    public boolean canLinkToNode(class_1937 level, IElectricityNode target) {
        IElectricityNode lastNode;
        if (this.lastNodePos != null && (lastNode = this.getLinkingNode(level)) != null && target != null && lastNode != target) {
            if (target.isSourceNode() && lastNode.isSourceNode()) {
                return false;
            }
            if (target.isNodeConnectionLimitReached()) {
                return false;
            }
            return !lastNode.isConnectedToNode(target);
        }
        return false;
    }

    private class_239 performLinkRaycast(class_1657 player, float partialTick, double range) {
        double closestDistance = Double.POSITIVE_INFINITY;
        Connection closestConnection = null;
        class_243 hit = class_243.field_1353;
        Set<Connection> connections = ElectricBlockEntityRenderer.getDrawnConnections();
        for (Connection connection : connections) {
            class_243 rayStart = player.method_5836(partialTick);
            class_243 rayEnd = rayStart.method_1019(player.method_5828(partialTick).method_1029().method_1021(range));
            class_243 linkStart = connection.getPosA().method_46558();
            class_243 linkEnd = connection.getPosB().method_46558();
            Vector3d result = new Vector3d();
            double squareDistance = Intersectiond.findClosestPointsLineSegments((double)rayStart.field_1352, (double)rayStart.field_1351, (double)rayStart.field_1350, (double)rayEnd.field_1352, (double)rayEnd.field_1351, (double)rayEnd.field_1350, (double)linkStart.field_1352, (double)linkStart.field_1351, (double)linkStart.field_1350, (double)linkEnd.field_1352, (double)linkEnd.field_1351, (double)linkEnd.field_1350, (Vector3d)new Vector3d(), (Vector3d)result);
            double distance = Math.sqrt(squareDistance);
            if (!(distance < 0.1) || !(distance < closestDistance)) continue;
            closestDistance = distance;
            closestConnection = connection;
            hit = new class_243(result.x, result.y, result.z);
        }
        return new LinkHitResult(hit, closestConnection);
    }

    public boolean onWrenchLeftClick(class_1937 level) {
        LinkHitResult linkResult;
        Connection connection;
        class_239 class_2393;
        if (!this.isLinking() && (class_2393 = this.result) instanceof LinkHitResult && (connection = (linkResult = (LinkHitResult)class_2393).getConnection()) != null) {
            class_243 hit = linkResult.method_17784();
            level.method_8486(hit.field_1352, hit.field_1351, hit.field_1350, (class_3414)ModSounds.ITEM_WRENCH_REMOVE_LINK.get(), class_3419.field_15245, 1.0f, 1.0f, false);
            Network.getPlay().sendToServer((Object)new MessageDeleteLink(connection.getPosA(), connection.getPosB()));
            return true;
        }
        return false;
    }

    @Nullable
    private class_265 getPowerableAreaShape() {
        class_310 mc = class_310.method_1551();
        if (this.sourcePositions.isEmpty() || mc.field_1687 == null) {
            return null;
        }
        if (this.lastSourcePositions.equals(this.sourcePositions)) {
            return this.cachedPowerableAreaShape;
        }
        this.sourcePositions.stream().map(pos -> ISourceNode.createPowerableZone((class_1937)mc.field_1687, pos)).map(aabb -> {
            class_265 shape1 = class_259.method_1078((class_238)aabb);
            class_265 shape2 = class_259.method_1078((class_238)aabb.method_1014(0.001));
            return Pair.of((Object)shape1, (Object)shape2);
        }).reduce((p1, p2) -> {
            class_265 shape1 = class_259.method_1082((class_265)((class_265)p1.first()), (class_265)((class_265)p2.first()), (class_247)class_247.field_1366);
            class_265 shape2 = class_259.method_1082((class_265)((class_265)p1.second()), (class_265)((class_265)p2.second()), (class_247)class_247.field_1366);
            return Pair.of((Object)shape1, (Object)shape2);
        }).map(pair -> class_259.method_1082((class_265)((class_265)pair.first()), (class_265)((class_265)pair.second()), (class_247)class_247.field_16893)).ifPresent(shape -> {
            this.cachedPowerableAreaShape = shape;
        });
        this.lastSourcePositions.clear();
        this.lastSourcePositions.addAll(this.sourcePositions);
        return this.cachedPowerableAreaShape;
    }

    private void renderPowerableArea(class_4587 poseStack, class_1657 player, float partialTick) {
        block19: {
            float areaAlpha;
            class_265 areaShape = this.getPowerableAreaShape();
            if (areaShape == null) {
                return;
            }
            class_243 eyePos = player.method_5836(partialTick);
            double nearDistanceSqr = 100.0;
            float f = areaAlpha = !this.linkInsideArea ? 1.0f : areaShape.method_33661(eyePos).map(vec -> vec.method_1025(eyePos)).map(val -> Float.valueOf(1.0f - (float)class_3532.method_15350((double)(val / nearDistanceSqr), (double)0.0, (double)1.0))).orElse(Float.valueOf(0.0f)).floatValue();
            if (areaAlpha <= 0.0f) {
                return;
            }
            areaAlpha = 1.0f - (float)Math.pow(1.0f - areaAlpha, 5.0);
            boolean shaders = DeferredElectricRenderer.get().isIrisShadersEnabled();
            RenderPipeline pipeline = shaders ? class_10799.field_56869 : ModRenderPipelines.POWERABLE_AREA;
            try (class_9799 quadBuilder = new class_9799(pipeline.getVertexFormat().getVertexSize() * 4);){
                class_287 vertexBuilder = new class_287(quadBuilder, pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
                areaShape.method_1090().forEach(box -> this.drawTexturedBox(poseStack, (class_4588)vertexBuilder, (class_238)box));
                try (class_9801 data = vertexBuilder.method_60794();){
                    if (data == null) break block19;
                    class_276 mainTarget = class_310.method_1551().method_1522();
                    GpuTextureView mainColor = mainTarget.method_71639();
                    GpuTextureView mainDepth = mainTarget.method_71640();
                    GpuBufferSlice slice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 0.6f * areaAlpha), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
                    RenderSystem.class_5590 autoIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)pipeline.getVertexFormatMode());
                    VertexFormat.class_5595 indexType = autoIndexBuffer.method_31924();
                    GpuBuffer indexBuffer = autoIndexBuffer.method_68274(data.method_60822().comp_751());
                    GpuBuffer vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Powerable Area", 40, data.method_60818().remaining());
                    RenderSystem.getDevice().createCommandEncoder().writeToBuffer(vertexBuffer.slice(), data.method_60818());
                    class_1044 texture = class_310.method_1551().method_1531().method_4619(this.linkInsideArea ? POWERABLE_AREA : UNPOWERABLE_AREA);
                    try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "SUM SUM", mainColor, OptionalInt.empty(), mainDepth, OptionalDouble.empty());){
                        RenderSystem.bindDefaultUniforms((RenderPass)pass);
                        pass.setPipeline(pipeline);
                        pass.setVertexBuffer(0, vertexBuffer);
                        pass.setUniform("DynamicTransforms", slice);
                        pass.setIndexBuffer(indexBuffer, indexType);
                        pass.bindSampler("Sampler0", texture.method_71659());
                        pass.drawIndexed(0, 0, data.method_60822().comp_751(), 1);
                    }
                }
            }
        }
    }

    private void drawTexturedBox(class_4587 poseStack, class_4588 consumer, class_238 box) {
        Matrix4f matrix = poseStack.method_23760().method_23761();
        float offset = (float)class_156.method_658() * 0.001f;
        float width = (float)(box.field_1320 - box.field_1323);
        float height = (float)(box.field_1325 - box.field_1322);
        if ((double)width > 0.01) {
            consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(0.0f, height + offset);
            consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(width, height + offset);
            consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(width, offset);
            consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(0.0f, offset);
            consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(0.0f, height + offset);
            consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(width, height + offset);
            consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(width, offset);
            consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(0.0f, offset);
        }
        if ((double)(width = (float)(box.field_1324 - box.field_1321)) > 0.01) {
            consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(0.0f, height + offset);
            consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(width, height + offset);
            consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(width, offset);
            consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(0.0f, offset);
            consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(0.0f, height + offset);
            consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(width, height + offset);
            consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(width, offset);
            consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(0.0f, offset);
        }
        width = (float)(box.field_1320 - box.field_1323);
        height = (float)(box.field_1324 - box.field_1321);
        if ((double)width > 0.01) {
            consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321).method_22913(height, width + offset);
            consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324).method_22913(height, offset);
            consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324).method_22913(0.0f, offset);
            consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321).method_22913(0.0f, width + offset);
            consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321).method_22913(0.0f, height + offset);
            consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321).method_22913(width, height + offset);
            consumer.method_22918(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324).method_22913(width, offset);
            consumer.method_22918(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324).method_22913(0.0f, offset);
        }
    }

    public static boolean isHoldingWrench() {
        class_310 mc = class_310.method_1551();
        return mc.field_1724 != null && mc.field_1724.method_6047().method_31574((class_1792)ModItems.WRENCH.get());
    }
}

