/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui;

import com.mrcrayfish.furniture.refurbished.client.gui.screen.WorkbenchScreen;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.crafting.WorkbenchContructingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.WorkbenchMenu;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5684;
import net.minecraft.class_6880;

public class ClientWorkbenchRecipeTooltip
implements class_5684 {
    private final WorkbenchMenu menu;
    private final WorkbenchContructingRecipe recipe;
    private final List<DisplayStack> displayStacks;

    public ClientWorkbenchRecipeTooltip(WorkbenchMenu menu, WorkbenchContructingRecipe recipe) {
        this.menu = menu;
        this.recipe = recipe;
        this.displayStacks = recipe.getMaterials().stream().map(i -> new DisplayStack(-1L, class_1799.field_8037)).collect(Collectors.toList());
    }

    public int method_32661(class_327 font) {
        return 20;
    }

    public int method_32664(class_327 font) {
        return this.recipe.getMaterials().size() * 18;
    }

    public void method_32666(class_327 font, int start, int top, int width, int height, class_332 graphics) {
        HashMap<Integer, Integer> counted = new HashMap<Integer, Integer>();
        class_2371<StackedIngredient> materials = this.recipe.getMaterials();
        for (int i = 0; i < materials.size(); ++i) {
            StackedIngredient material = (StackedIngredient)materials.get(i);
            class_1799 copy = this.getDisplayStack(i, material);
            graphics.method_51445(copy, start + i * 18, top);
            graphics.method_51431(font, copy, start + i * 18, top);
            boolean checked = this.menu.hasMaterials(material, counted);
            graphics.method_25290(class_10799.field_56883, WorkbenchScreen.WORKBENCH_TEXTURE, start + i * 18, top, checked ? 246.0f : 240.0f, 40.0f, 6, 5, 256, 256);
        }
    }

    private class_1799 getDisplayStack(int index, StackedIngredient material) {
        long time = class_156.method_658() / 1000L;
        DisplayStack display = this.displayStacks.get(index);
        if (display.lastUpdate != time) {
            List items = material.ingredient().method_8105().toList();
            int itemIndex = (int)time % items.size();
            class_1799 stack = new class_1799((class_6880)items.get(itemIndex));
            stack.method_7939(material.count());
            this.displayStacks.set(index, new DisplayStack(time, stack));
            return stack;
        }
        return display.stack;
    }

    private record DisplayStack(long lastUpdate, class_1799 stack) {
    }
}

