/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.model.animation;

import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.ModelPartAnimationType;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.ModelPartAnimator;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.ModelPartAnimationContext;
import com.faboslav.friendsandfoes.common.entity.animation.animator.context.AnimationContextTracker;
import net.minecraft.class_630;
import org.joml.Vector3f;

public final class ModelPartModelAnimator {
    public static void animateModelPartXPositionWithProgress(AnimationContextTracker animationContextTracker, class_630 modelPart, float targetX, float progress) {
        ModelPartModelAnimator.animateModelPartPositionWithProgress(animationContextTracker, modelPart, targetX, modelPart.field_3656, modelPart.field_3655, progress);
    }

    public static void animateModelPartYPositionWithProgress(AnimationContextTracker animationContextTracker, class_630 modelPart, float targetY, float progress) {
        ModelPartModelAnimator.animateModelPartPositionWithProgress(animationContextTracker, modelPart, modelPart.field_3657, targetY, modelPart.field_3655, progress);
    }

    public static void animateModelPartZPositionWithProgress(AnimationContextTracker animationContextTracker, class_630 modelPart, float targetZ, float progress) {
        ModelPartModelAnimator.animateModelPartPositionWithProgress(animationContextTracker, modelPart, modelPart.field_3657, modelPart.field_3656, targetZ, progress);
    }

    public static void animateModelPartPositionWithProgress(AnimationContextTracker animationContextTracker, class_630 modelPart, float targetX, float targetY, float targetZ, float progress) {
        Vector3f targetVector = new Vector3f(targetX, targetY, targetZ);
        ModelPartModelAnimator.animateWithProgress(animationContextTracker, modelPart, ModelPartAnimationType.POSITION, targetVector, progress);
    }

    public static void animateModelPartXRotationBasedOnProgress(AnimationContextTracker animationContextTracker, class_630 modelPart, float targetX, float progress) {
        ModelPartModelAnimator.animateModelPartRotationBasedOnProgress(animationContextTracker, modelPart, targetX, modelPart.field_3675, modelPart.field_3674, progress);
    }

    public static void animateModelPartYRotationBasedOnProgress(AnimationContextTracker animationContextTracker, class_630 modelPart, float targetY, float progress) {
        ModelPartModelAnimator.animateModelPartRotationBasedOnProgress(animationContextTracker, modelPart, modelPart.field_3654, targetY, modelPart.field_3674, progress);
    }

    public static void animateZRotationBasedOnProgress(AnimationContextTracker animationContextTracker, class_630 modelPart, float targetZ, float progress) {
        ModelPartModelAnimator.animateModelPartRotationBasedOnProgress(animationContextTracker, modelPart, targetZ, modelPart.field_3675, modelPart.field_3674, progress);
    }

    public static void animateModelPartRotationBasedOnProgress(AnimationContextTracker animationContextTracker, class_630 modelPart, float targetX, float targetY, float targetZ, float progress) {
        Vector3f targetVector = new Vector3f(targetX, targetY, targetZ);
        ModelPartModelAnimator.animateWithProgress(animationContextTracker, modelPart, ModelPartAnimationType.ROTATION, targetVector, progress);
    }

    private static void animateWithProgress(AnimationContextTracker animationContextTracker, class_630 modelPart, ModelPartAnimationType animationType, Vector3f targetVector, float progress) {
        Vector3f animationCurrentVector;
        ModelPartAnimationContext animationContext;
        String modelPartName = modelPart.toString();
        if (animationContextTracker.contains(modelPartName, animationType)) {
            animationContext = animationContextTracker.get(modelPartName, animationType);
            animationCurrentVector = animationContext.getCurrentVector();
            Vector3f animationTargetVector = animationContext.getTargetVector();
            if (!animationTargetVector.equals((Object)targetVector)) {
                animationContextTracker.remove(modelPartName, animationType);
                animationContext = ModelPartAnimationContext.createWithProgress(progress, targetVector, animationCurrentVector);
                animationContextTracker.add(modelPartName, animationType, animationContext);
            }
        } else {
            animationCurrentVector = switch (animationType) {
                default -> throw new MatchException(null, null);
                case ModelPartAnimationType.POSITION -> new Vector3f(modelPart.field_3657, modelPart.field_3656, modelPart.field_3655);
                case ModelPartAnimationType.ROTATION -> new Vector3f(modelPart.field_3654, modelPart.field_3675, modelPart.field_3674);
            };
            animationContext = ModelPartAnimationContext.createWithProgress(progress, targetVector, animationCurrentVector);
            animationContextTracker.add(modelPartName, animationType, animationContext);
        }
        animationContext.setProgress(progress);
        animationContext.recalculateCurrentVector();
        animationCurrentVector = animationContext.getCurrentVector();
        switch (animationType) {
            case POSITION: {
                ModelPartAnimator.setPosition(modelPart, animationCurrentVector);
                break;
            }
            case ROTATION: {
                ModelPartAnimator.setRotation(modelPart, animationCurrentVector);
            }
        }
    }

    public static void animateModelPartXPositionBasedOnTicks(AnimationContextTracker animationContextTracker, class_630 modelPart, int currentEntityTick, float targetX, int ticks) {
        ModelPartModelAnimator.animateModelPartPositionBasedOnTicks(animationContextTracker, modelPart, currentEntityTick, targetX, modelPart.field_3656, modelPart.field_3655, ticks);
    }

    public static void animateModelPartYPositionBasedOnTicks(AnimationContextTracker animationContextTracker, class_630 modelPart, int currentEntityTick, float targetY, int ticks) {
        ModelPartModelAnimator.animateModelPartPositionBasedOnTicks(animationContextTracker, modelPart, currentEntityTick, modelPart.field_3657, targetY, modelPart.field_3655, ticks);
    }

    public static void animateZPositionBasedOnTicks(AnimationContextTracker animationContextTracker, class_630 modelPart, int currentEntityTick, float targetX, int ticks) {
        ModelPartModelAnimator.animateModelPartPositionBasedOnTicks(animationContextTracker, modelPart, currentEntityTick, targetX, modelPart.field_3656, modelPart.field_3655, ticks);
    }

    public static void animateModelPartPositionBasedOnTicks(AnimationContextTracker animationContextTracker, class_630 modelPart, int currentEntityTick, float targetX, float targetY, float targetZ, int ticks) {
        Vector3f targetVector = new Vector3f(targetX, targetY, targetZ);
        ModelPartModelAnimator.animateModelPartBasedOnTicks(animationContextTracker, modelPart, currentEntityTick, ModelPartAnimationType.POSITION, targetVector, ticks);
    }

    public static void animateModelPartXRotationBasedOnTicks(AnimationContextTracker animationContextTracker, class_630 modelPart, int currentEntityTick, float targetX, int ticks) {
        ModelPartModelAnimator.animateModelPartRotationBasedOnTicks(animationContextTracker, modelPart, currentEntityTick, targetX, modelPart.field_3675, modelPart.field_3674, ticks);
    }

    public static void animateModelPartYRotationBasedOnTicks(AnimationContextTracker animationContextTracker, class_630 modelPart, int currentEntityTick, float targetY, int ticks) {
        ModelPartModelAnimator.animateModelPartRotationBasedOnTicks(animationContextTracker, modelPart, currentEntityTick, modelPart.field_3654, targetY, modelPart.field_3674, ticks);
    }

    public static void animateModelPartZRotationBasedOnTicks(AnimationContextTracker animationContextTracker, class_630 modelPart, int currentEntityTick, float targetZ, int ticks) {
        ModelPartModelAnimator.animateModelPartRotationBasedOnTicks(animationContextTracker, modelPart, currentEntityTick, modelPart.field_3675, modelPart.field_3674, targetZ, ticks);
    }

    public static void animateModelPartRotationBasedOnTicks(AnimationContextTracker animationContextTracker, class_630 modelPart, int currentEntityTick, float targetX, float targetY, float targetZ, int ticks) {
        Vector3f targetVector = new Vector3f(targetX, targetY, targetZ);
        ModelPartModelAnimator.animateModelPartBasedOnTicks(animationContextTracker, modelPart, currentEntityTick, ModelPartAnimationType.ROTATION, targetVector, ticks);
    }

    private static void animateModelPartBasedOnTicks(AnimationContextTracker animationContextTracker, class_630 modelPart, int currentEntityTick, ModelPartAnimationType animationType, Vector3f targetVector, int ticks) {
        Vector3f currentVector;
        ModelPartAnimationContext animationContext;
        String modelPartName = modelPart.toString();
        if (animationContextTracker.contains(modelPartName, animationType)) {
            animationContext = animationContextTracker.get(modelPartName, animationType);
            currentVector = animationContext.getCurrentVector();
            if (currentVector.equals((Object)targetVector)) {
                switch (animationType) {
                    case POSITION: {
                        ModelPartAnimator.setPosition(modelPart, targetVector);
                        break;
                    }
                    case ROTATION: {
                        ModelPartAnimator.setRotation(modelPart, targetVector);
                    }
                }
                return;
            }
            Vector3f animationTargetVector = animationContext.getTargetVector();
            if (!animationTargetVector.equals((Object)targetVector)) {
                animationContextTracker.remove(modelPartName, animationType);
                animationContext = ModelPartAnimationContext.createWithTicks(currentEntityTick, ticks, targetVector, currentVector);
                animationContextTracker.add(modelPartName, animationType, animationContext);
            }
        } else {
            currentVector = switch (animationType) {
                default -> throw new MatchException(null, null);
                case ModelPartAnimationType.POSITION -> new Vector3f(modelPart.field_3657, modelPart.field_3656, modelPart.field_3655);
                case ModelPartAnimationType.ROTATION -> new Vector3f(modelPart.field_3654, modelPart.field_3675, modelPart.field_3674);
            };
            animationContext = ModelPartAnimationContext.createWithTicks(currentEntityTick, ticks, targetVector, currentVector);
            animationContextTracker.add(modelPartName, animationType, animationContext);
        }
        animationContext.setCurrentTick(currentEntityTick);
        animationContext.recalculateProgress();
        animationContext.recalculateCurrentVector();
        currentVector = animationContext.getCurrentVector();
        switch (animationType) {
            case POSITION: {
                ModelPartAnimator.setPosition(modelPart, currentVector);
                break;
            }
            case ROTATION: {
                ModelPartAnimator.setRotation(modelPart, currentVector);
            }
        }
    }
}

