/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2;

import com.mojang.serialization.Codec;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_2396;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4089;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractParticleProvider
implements class_2405 {
    public static final Codec<class_4089> CODEC = class_2960.field_25139.listOf().fieldOf("textures").xmap(class_4089::new, class_4089::method_18826).codec();
    private final Map<class_2960, class_4089> values = new LinkedHashMap<class_2960, class_4089>();
    private final class_7784.class_7489 pathProvider;
    @Nullable
    private final class_3300 clientResourceManager;

    public AbstractParticleProvider(DataProviderContext context) {
        this(context.getPackOutput(), context.getClientResourceManager());
    }

    public AbstractParticleProvider(class_7784 packOutput, @Nullable class_3300 clientResourceManager) {
        this.pathProvider = packOutput.method_45973(class_7784.class_7490.field_39368, "particles");
        this.clientResourceManager = clientResourceManager;
    }

    public CompletableFuture<?> method_10319(class_7403 cachedOutput) {
        this.addParticles();
        return class_2405.method_64110((class_7403)cachedOutput, CODEC, (class_7784.class_7489)this.pathProvider, this.values);
    }

    public abstract void addParticles();

    public void add(class_2396<?> particleType) {
        this.add(particleType, -1);
    }

    public void add(class_2396<?> particleType, int indexEnd) {
        this.add(particleType, class_7923.field_41180.method_10221(particleType), indexEnd);
    }

    public void add(class_2396<?> particleType, int indexStart, int indexEnd) {
        this.add(particleType, class_7923.field_41180.method_10221(particleType), indexStart, indexEnd);
    }

    public void add(class_2396<?> particleType, class_2960 resourceLocation, int indexEnd) {
        this.add(class_7923.field_41180.method_10221(particleType), resourceLocation, indexEnd);
    }

    public void add(class_2396<?> particleType, class_2960 resourceLocation, int indexStart, int indexEnd) {
        this.add(class_7923.field_41180.method_10221(particleType), resourceLocation, indexStart, indexEnd);
    }

    public void add(class_2960 id, class_2960 resourceLocation, int indexEnd) {
        this.add(id, resourceLocation, 0, indexEnd);
    }

    public void add(class_2960 id, class_2960 resourceLocation, int indexStart, int indexEnd) {
        if (indexEnd == -1) {
            this.add(id, new class_4089(Collections.singletonList(resourceLocation)));
        } else {
            List textures = IntStream.rangeClosed(Math.min(indexStart, indexEnd), Math.max(indexStart, indexEnd)).mapToObj(index -> ResourceLocationHelper.fromNamespaceAndPath(resourceLocation.method_12836(), resourceLocation.method_12832() + "_" + index)).collect(Collectors.toList());
            if (indexEnd < indexStart) {
                Collections.reverse(textures);
            }
            this.add(id, new class_4089(textures));
        }
    }

    public void add(class_2960 id, class_4089 particleDescription) {
        if (this.clientResourceManager != null) {
            this.validate(id, particleDescription, this.clientResourceManager);
        }
        if (this.values.putIfAbsent(id, particleDescription) != null) {
            throw new IllegalStateException("Duplicate particle description: " + String.valueOf(id));
        }
    }

    protected void validate(class_2960 id, class_4089 particleDescription, class_3300 resourceManager) {
        Objects.requireNonNull(resourceManager, "resource manager is null");
        List<String> missingTextures = particleDescription.method_18826().stream().filter(resourceLocation -> resourceManager.method_14486(resourceLocation.method_45134(string -> "textures/particle/" + string + ".png")).isEmpty()).map(class_2960::toString).toList();
        if (!missingTextures.isEmpty()) {
            throw new IllegalArgumentException("Couldn't define particle description %s as it is missing following texture(s): %s".formatted(id, String.join((CharSequence)",", missingTextures)));
        }
    }

    public String method_10321() {
        return "Particle Descriptions";
    }
}

