/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.mojang.serialization.Codec;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_10726;
import net.minecraft.class_161;
import net.minecraft.class_1799;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_2405;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7785;
import net.minecraft.class_7924;
import net.minecraft.class_8779;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAdvancementProvider
implements class_2405,
class_7785 {
    private final String modId;
    private final class_7784.class_7489 pathProvider;
    private final CompletableFuture<class_7225.class_7874> registries;

    public AbstractAdvancementProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput(), context.getRegistries());
    }

    public AbstractAdvancementProvider(String modId, class_7784 packOutput, CompletableFuture<class_7225.class_7874> registries) {
        this.modId = modId;
        this.pathProvider = packOutput.method_60917(class_7924.field_52177);
        this.registries = registries;
    }

    protected static class_185 display(class_1799 itemStack, class_2960 resourceLocation) {
        return AbstractAdvancementProvider.display(itemStack, resourceLocation, class_189.field_1254);
    }

    protected static class_185 display(class_1799 itemStack, class_2960 resourceLocation, class_189 advancementType) {
        return AbstractAdvancementProvider.display(itemStack, resourceLocation, null, advancementType, false);
    }

    protected static class_185 display(class_1799 itemStack, class_2960 resourceLocation, @Nullable class_2960 background, class_189 advancementType, boolean hidden) {
        return AbstractAdvancementProvider.display(itemStack, resourceLocation, background, advancementType, true, true, hidden);
    }

    protected static class_185 display(class_1799 itemStack, class_2960 resourceLocation, @Nullable class_2960 background, class_189 advancementType, boolean showToast, boolean announceChat, boolean hidden) {
        AdvancementToken advancementToken = new AdvancementToken(resourceLocation);
        return new class_185(itemStack, advancementToken.title(), advancementToken.description(), Optional.ofNullable(background).map(class_10726::new), advancementType, true, true, hidden);
    }

    public final CompletableFuture<?> method_10319(class_7403 output) {
        return this.registries.thenCompose(registries -> {
            HashSet set = new HashSet();
            ArrayList list = new ArrayList();
            Consumer<class_8779> consumer = holder -> {
                class_2960 resourceLocation = ResourceLocationHelper.fromNamespaceAndPath(this.modId, holder.comp_1919().method_12832());
                if (!set.add(resourceLocation)) {
                    throw new IllegalStateException("Duplicate advancement " + String.valueOf(resourceLocation));
                }
                Path path = this.pathProvider.method_44107(resourceLocation);
                list.add(class_2405.method_53496((class_7403)output, (class_7225.class_7874)registries, (Codec)class_161.field_47179, (Object)holder.comp_1920(), (Path)path));
            };
            this.method_10335((class_7225.class_7874)registries, consumer);
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }

    public final void method_10335(class_7225.class_7874 registries, Consumer<class_8779> writer) {
        this.addAdvancements(registries, writer);
    }

    public abstract void addAdvancements(class_7225.class_7874 var1, Consumer<class_8779> var2);

    public String method_10321() {
        return "Advancements";
    }

    public record AdvancementToken(class_2960 id) {
        public class_2561 title() {
            return class_2561.method_43471((String)this.id.method_48747("advancements", "title"));
        }

        public class_2561 description() {
            return class_2561.method_43471((String)this.id.method_48747("advancements", "description"));
        }

        public class_8779 asParent() {
            return new class_8779(this.id, null);
        }

        public String name() {
            return this.id.method_12832();
        }
    }
}

