/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.item.v2;

import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.impl.core.proxy.ProxyImpl;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1937;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public final class ItemHelper {
    private ItemHelper() {
    }

    public static void hurtAndBreak(class_1799 itemStack, int amount, class_1309 livingEntity, class_1268 interactionHand) {
        ItemHelper.hurtAndBreak(itemStack, amount, livingEntity, class_1309.method_56079((class_1268)interactionHand));
    }

    public static void hurtAndBreak(class_1799 itemStack, int amount, class_1309 livingEntity, class_1304 equipmentSlot) {
        class_1937 class_19372 = livingEntity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_3222 serverPlayer = livingEntity instanceof class_3222 ? (class_3222)livingEntity : null;
            ItemHelper.hurtAndBreak(itemStack, amount, serverLevel, serverPlayer, item -> livingEntity.method_20235(item, equipmentSlot));
        }
    }

    public static void hurtAndBreak(class_1799 itemStack, int amount, class_3218 serverLevel, @Nullable class_3222 serverPlayer, Consumer<class_1792> onBreak) {
        class_1799 originalItemStack = ItemHelper.copyItemStackIfNecessary(itemStack, serverPlayer);
        itemStack.method_7956(amount, serverLevel, serverPlayer, item -> {
            onBreak.accept((class_1792)item);
            if (serverPlayer != null) {
                ItemHelper.onPlayerDestroyItem((class_1657)serverPlayer, originalItemStack, null);
            }
        });
    }

    private static class_1799 copyItemStackIfNecessary(class_1799 itemStack, @Nullable class_3222 serverPlayer) {
        if (serverPlayer != null && ModLoaderEnvironment.INSTANCE.getModLoader().isForgeLike()) {
            return itemStack.method_7972();
        }
        return itemStack;
    }

    public static void onPlayerDestroyItem(class_1657 player, class_1799 originalItemStack, @Nullable class_1268 interactionHand) {
        Objects.requireNonNull(player, "player is null");
        Objects.requireNonNull(originalItemStack, "original item stack is null");
        ProxyImpl.get().onPlayerDestroyItem(player, originalItemStack, interactionHand);
    }

    public static class_2583 getRarityStyle(class_1814 rarity) {
        Objects.requireNonNull(rarity, "rarity is null");
        return ProxyImpl.get().getRarityStyle(rarity);
    }
}

