/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.core.context;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingContext;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.BiomeModificationContext;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.fabric.impl.biome.BiomeLoadingContextFabric;
import fuzs.puzzleslib.fabric.impl.biome.ClimateSettingsContextFabric;
import fuzs.puzzleslib.fabric.impl.biome.GenerationSettingsContextFabric;
import fuzs.puzzleslib.fabric.impl.biome.MobSpawnSettingsContextFabric;
import fuzs.puzzleslib.fabric.impl.biome.SpecialEffectsContextFabric;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModification;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.minecraft.class_1959;
import net.minecraft.class_2960;

public record BiomeModificationsContextFabricImpl(BiomeModification biomeModification) implements BiomeModificationsContext
{
    private static final Map<BiomeLoadingPhase, ModificationPhase> BIOME_PHASE_CONVERSIONS = Maps.immutableEnumMap((Map)ImmutableMap.of((Object)((Object)BiomeLoadingPhase.ADDITIONS), (Object)ModificationPhase.ADDITIONS, (Object)((Object)BiomeLoadingPhase.REMOVALS), (Object)ModificationPhase.REMOVALS, (Object)((Object)BiomeLoadingPhase.MODIFICATIONS), (Object)ModificationPhase.REPLACEMENTS, (Object)((Object)BiomeLoadingPhase.POST_PROCESSING), (Object)ModificationPhase.POST_PROCESSING));

    public BiomeModificationsContextFabricImpl(String modId) {
        this(BiomeModifications.create((class_2960)ResourceLocationHelper.fromNamespaceAndPath(modId, "biome_modifiers")));
    }

    @Override
    public void registerBiomeModification(BiomeLoadingPhase biomeLoadingPhase, Predicate<BiomeLoadingContext> biomeSelector, Consumer<BiomeModificationContext> biomeModifier) {
        Objects.requireNonNull(biomeLoadingPhase, "biome loading phase is null");
        Objects.requireNonNull(biomeSelector, "biome selector is null");
        Objects.requireNonNull(biomeModifier, "biome modifier is null");
        ModificationPhase modificationPhase = BIOME_PHASE_CONVERSIONS.get((Object)biomeLoadingPhase);
        Objects.requireNonNull(modificationPhase, "modification phase is null");
        this.biomeModification.add(modificationPhase, selectionContext -> biomeSelector.test(new BiomeLoadingContextFabric((BiomeSelectionContext)selectionContext)), (selectionContext, modificationContext) -> biomeModifier.accept(BiomeModificationsContextFabricImpl.createModificationContext(modificationContext, selectionContext.getBiome())));
    }

    static BiomeModificationContext createModificationContext(net.fabricmc.fabric.api.biome.v1.BiomeModificationContext modificationContext, class_1959 biome) {
        ClimateSettingsContextFabric climateSettings = new ClimateSettingsContextFabric(biome, modificationContext.getWeather());
        SpecialEffectsContextFabric specialEffects = new SpecialEffectsContextFabric(biome.method_24377(), modificationContext.getEffects());
        GenerationSettingsContextFabric generationSettings = new GenerationSettingsContextFabric(biome.method_30970(), modificationContext.getGenerationSettings());
        MobSpawnSettingsContextFabric mobSpawnSettings = new MobSpawnSettingsContextFabric(biome.method_30966(), modificationContext.getSpawnSettings());
        return new BiomeModificationContext(climateSettings, specialEffects, generationSettings, mobSpawnSettings);
    }
}

