/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.event.v1.AddBlockEntityTypeBlocksCallback;
import fuzs.puzzleslib.api.event.v1.BuildCreativeModeTabContentsCallback;
import fuzs.puzzleslib.api.event.v1.CommonSetupCallback;
import fuzs.puzzleslib.api.event.v1.ComputeItemAttributeModifiersCallback;
import fuzs.puzzleslib.api.event.v1.FinalizeItemComponentsCallback;
import fuzs.puzzleslib.api.event.v1.LoadCompleteCallback;
import fuzs.puzzleslib.api.event.v1.RegistryEntryAddedCallback;
import fuzs.puzzleslib.api.event.v1.core.EventInvoker;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.entity.ChangeEntitySizeCallback;
import fuzs.puzzleslib.api.event.v1.entity.EnderPearlTeleportCallback;
import fuzs.puzzleslib.api.event.v1.entity.EntityRidingEvents;
import fuzs.puzzleslib.api.event.v1.entity.EntityTickEvents;
import fuzs.puzzleslib.api.event.v1.entity.ProjectileImpactCallback;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.AnimalTameCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.BabyEntitySpawnCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.CheckMobDespawnCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingAttackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingChangeTargetCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingConversionCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDeathCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingEquipmentChangeCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingExperienceDropCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingFallCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingJumpCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingKnockBackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingVisibilityCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LookingAtEndermanCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.MobEffectEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.PickProjectileCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.ShieldBlockCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.AfterChangeDimensionCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ArrowLooseCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.CalculateBlockBreakSpeedCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ContainerEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.CreateAnvilResultCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.CreateGrindstoneResultCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ItemEntityEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PickupExperienceCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerCopyEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerNetworkEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTrackingEvents;
import fuzs.puzzleslib.api.event.v1.level.BlockEvents;
import fuzs.puzzleslib.api.event.v1.level.ExplosionEvents;
import fuzs.puzzleslib.api.event.v1.level.GatherPotentialSpawnsCallback;
import fuzs.puzzleslib.api.event.v1.level.PlaySoundEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerChunkEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerLevelEvents;
import fuzs.puzzleslib.api.event.v1.level.ServerLevelTickEvents;
import fuzs.puzzleslib.api.event.v1.level.UseBoneMealCallback;
import fuzs.puzzleslib.api.event.v1.server.AddDataPackReloadListenersCallback;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadCallback;
import fuzs.puzzleslib.api.event.v1.server.RegisterCommandsCallback;
import fuzs.puzzleslib.api.event.v1.server.RegisterConfigurationTasksCallback;
import fuzs.puzzleslib.api.event.v1.server.RegisterPotionBrewingMixesCallback;
import fuzs.puzzleslib.api.event.v1.server.ServerLifecycleEvents;
import fuzs.puzzleslib.api.event.v1.server.ServerTickEvents;
import fuzs.puzzleslib.api.event.v1.server.SyncDataPackContentsCallback;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import fuzs.puzzleslib.api.init.v3.registry.LookupHelper;
import fuzs.puzzleslib.fabric.api.event.v1.FabricEntityEvents;
import fuzs.puzzleslib.fabric.api.event.v1.FabricLevelEvents;
import fuzs.puzzleslib.fabric.api.event.v1.FabricLifecycleEvents;
import fuzs.puzzleslib.fabric.api.event.v1.FabricLivingEvents;
import fuzs.puzzleslib.fabric.api.event.v1.FabricPlayerEvents;
import fuzs.puzzleslib.fabric.api.event.v1.core.FabricEventInvokerRegistry;
import fuzs.puzzleslib.fabric.impl.core.FabricProxy;
import fuzs.puzzleslib.fabric.impl.event.FabricPlayerInteraction;
import fuzs.puzzleslib.fabric.impl.init.FabricPotionBrewingBuilder;
import fuzs.puzzleslib.impl.event.CopyOnWriteForwardingList;
import fuzs.puzzleslib.impl.event.core.EventInvokerImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.item.v1.DefaultItemComponentEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.registry.FabricBrewingRecipeRegistryBuilder;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8610;
import net.minecraft.class_9285;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public final class FabricEventInvokerRegistryImpl
implements FabricEventInvokerRegistry {
    public static void registerLoadingHandlers() {
        INSTANCE.register(LoadCompleteCallback.class, FabricLifecycleEvents.LOAD_COMPLETE);
        INSTANCE.register(RegistryEntryAddedCallback.class, FabricEventInvokerRegistryImpl::onRegistryEntryAdded);
        INSTANCE.register(FinalizeItemComponentsCallback.class, DefaultItemComponentEvents.MODIFY, (T callback) -> context -> {
            for (class_1792 item : class_7923.field_41178) {
                callback.onFinalizeItemComponents(item, function -> context.modify(item, builder -> ((class_9326)function.apply(builder.method_57838())).method_57846().forEach(entry -> builder.method_57840((class_9331)entry.getKey(), ((Optional)entry.getValue()).orElse(null)))));
            }
        });
        INSTANCE.register(ComputeItemAttributeModifiersCallback.class, DefaultItemComponentEvents.MODIFY, (T callback) -> context -> {
            for (class_1792 item : class_7923.field_41178) {
                class_9285 itemAttributeModifiers = (class_9285)item.method_57347().method_58695(class_9334.field_49636, (Object)class_9285.field_49326);
                CopyOnWriteForwardingList<class_9285.class_9287> entries = new CopyOnWriteForwardingList<class_9285.class_9287>(itemAttributeModifiers.comp_2393());
                callback.onComputeItemAttributeModifiers(item, entries);
                if (entries.delegate() == itemAttributeModifiers.comp_2393()) continue;
                context.modify(item, builder -> builder.method_57840(class_9334.field_49636, (Object)new class_9285((List)ImmutableList.copyOf((Collection)entries))));
            }
        });
        INSTANCE.register(AddBlockEntityTypeBlocksCallback.class, FabricLifecycleEvents.LOAD_COMPLETE, (T callback) -> () -> callback.onAddBlockEntityTypeBlocks((blockEntityType, block) -> blockEntityType.addSupportedBlock(block)));
        INSTANCE.register(CommonSetupCallback.class, (T callback, Object context) -> callback.onCommonSetup());
        INSTANCE.register(RegisterConfigurationTasksCallback.class, ServerConfigurationConnectionEvents.CONFIGURE, (T callback) -> (handler, server) -> callback.onRegisterConfigurationTasks(server, handler, arg_0 -> ((class_8610)handler).addTask(arg_0)));
    }

    private static <T> void onRegistryEntryAdded(RegistryEntryAddedCallback<T> callback, @Nullable Object context) {
        Objects.requireNonNull(context, "context is null");
        class_5321 resourceKey = (class_5321)context;
        class_2378 registry = LookupHelper.getRegistry(resourceKey).orElseThrow();
        BiConsumer<class_2960, Supplier> registrar = (resourceLocation, supplier) -> class_2378.method_10230((class_2378)registry, (class_2960)resourceLocation, supplier.get());
        net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback.event(registry).register((rawId, id, object) -> callback.onRegistryEntryAdded(registry, id, object, registrar));
        LinkedHashMap toRegister = Maps.newLinkedHashMap();
        for (Map.Entry entry : registry.method_29722()) {
            callback.onRegistryEntryAdded(registry, ((class_5321)entry.getKey()).method_29177(), entry.getValue(), toRegister::put);
        }
        toRegister.forEach(registrar);
    }

    public static void registerEventHandlers() {
        INSTANCE.register(AddDataPackReloadListenersCallback.class, FabricLifecycleEvents.ADD_DATA_PACK_RELOAD_LISTENERS);
        INSTANCE.register(TagsUpdatedCallback.class, CommonLifecycleEvents.TAGS_LOADED, (T callback) -> callback::onTagsUpdated);
        INSTANCE.register(RegisterCommandsCallback.class, CommandRegistrationCallback.EVENT, (T callback) -> callback::onRegisterCommands);
        INSTANCE.register(ServerLifecycleEvents.Starting.class, ServerLifecycleEvents.SERVER_STARTING, (T callback) -> callback::onServerStarting);
        INSTANCE.register(PlayerInteractEvents.UseBlock.class, UseBlockCallback.EVENT, (T callback) -> (player, level, interactionHand, hitResult) -> {
            EventResultHolder<class_1269> eventResult = callback.onUseBlock(player, level, interactionHand, hitResult);
            return FabricPlayerInteraction.USE_BLOCK.getHandledInteractionResult(eventResult, player, level, interactionHand, null, (class_239)hitResult);
        });
        INSTANCE.register(PlayerInteractEvents.AttackBlock.class, AttackBlockCallback.EVENT, (T callback) -> (player, level, interactionHand, pos, direction) -> {
            if (!level.field_9236 || player.method_68878() || FabricProxy.get().shouldStartDestroyBlock(pos)) {
                EventResult eventResult = callback.onAttackBlock(player, level, interactionHand, pos, direction);
                return eventResult.isInterrupt() ? class_1269.field_5812 : class_1269.field_5811;
            }
            return class_1269.field_5811;
        });
        INSTANCE.register(PlayerInteractEvents.UseItem.class, UseItemCallback.EVENT, (T callback) -> (player, level, interactionHand) -> {
            if (player.method_7325()) {
                return class_1269.field_5811;
            }
            if (player.method_7357().method_7904(player.method_5998(interactionHand))) {
                return class_1269.field_5811;
            }
            EventResultHolder<class_1269> eventResult = callback.onUseItem(player, level, interactionHand);
            return FabricPlayerInteraction.USE_ITEM.getHandledInteractionResult(eventResult, player, level, interactionHand, null, null);
        });
        INSTANCE.register(PlayerInteractEvents.UseEntity.class, UseEntityCallback.EVENT, (T callback) -> (player, level, interactionHand, entity, hitResult) -> {
            if (level instanceof class_3218 && hitResult != null) {
                return class_1269.field_5811;
            }
            EventResultHolder<class_1269> eventResult = callback.onUseEntity(player, level, interactionHand, entity);
            return FabricPlayerInteraction.USE_ENTITY.getHandledInteractionResult(eventResult, player, level, interactionHand, entity, null);
        });
        INSTANCE.register(PlayerInteractEvents.UseEntityAt.class, UseEntityCallback.EVENT, (T callback) -> (player, level, interactionHand, entity, hitResult) -> {
            if (hitResult == null) {
                return class_1269.field_5811;
            }
            EventResultHolder<class_1269> eventResult = callback.onUseEntityAt(player, level, interactionHand, entity, hitResult.method_17784());
            return FabricPlayerInteraction.USE_ENTITY_AT.getHandledInteractionResult(eventResult, player, level, interactionHand, entity, (class_239)hitResult);
        });
        INSTANCE.register(PlayerInteractEvents.AttackEntity.class, AttackEntityCallback.EVENT, (T callback) -> (player, level, interactionHand, entity, hitResult) -> {
            EventResult eventResult = callback.onAttackEntity(player, level, interactionHand, entity);
            return eventResult.isInterrupt() ? class_1269.field_5812 : class_1269.field_5811;
        });
        INSTANCE.register(PickupExperienceCallback.class, FabricPlayerEvents.PICKUP_EXPERIENCE);
        INSTANCE.register(UseBoneMealCallback.class, FabricLevelEvents.USE_BONE_MEAL);
        INSTANCE.register(LivingExperienceDropCallback.class, FabricLivingEvents.EXPERIENCE_DROP);
        INSTANCE.register(BlockEvents.Break.class, PlayerBlockBreakEvents.BEFORE, (T callback) -> (level, player, pos, state, blockEntity) -> {
            if (!(level instanceof class_3218)) {
                return true;
            }
            class_3218 serverLevel = (class_3218)level;
            if (!(player instanceof class_3222)) {
                return true;
            }
            class_3222 serverPlayer = (class_3222)player;
            EventResult eventResult = callback.onBreakBlock(serverLevel, pos, state, serverPlayer, player.method_6047());
            return eventResult.isPass();
        });
        INSTANCE.register(BlockEvents.DropExperience.class, FabricLevelEvents.DROP_BLOCK_EXPERIENCE);
        INSTANCE.register(PlayerTickEvents.Start.class, FabricPlayerEvents.PLAYER_TICK_START);
        INSTANCE.register(PlayerTickEvents.End.class, FabricPlayerEvents.PLAYER_TICK_END);
        INSTANCE.register(LivingFallCallback.class, FabricLivingEvents.LIVING_FALL);
        INSTANCE.register(LootTableLoadCallback.class, LootTableEvents.MODIFY, (T callback) -> (key, tableBuilder, source, registries) -> callback.onLootTableLoad(key.method_29177(), tableBuilder, registries));
        INSTANCE.register(ItemEntityEvents.Touch.class, FabricPlayerEvents.ITEM_TOUCH);
        INSTANCE.register(ItemEntityEvents.Pickup.class, FabricPlayerEvents.ITEM_PICKUP);
        INSTANCE.register(CreateAnvilResultCallback.class, FabricPlayerEvents.CREATE_ANVIL_RESULT);
        INSTANCE.register(CreateGrindstoneResultCallback.class, FabricPlayerEvents.CREATE_GRINDSTONE_RESULT);
        INSTANCE.register(LivingDropsCallback.class, FabricLivingEvents.LIVING_DROPS);
        INSTANCE.register(EntityTickEvents.Start.class, FabricEntityEvents.ENTITY_TICK_START);
        INSTANCE.register(EntityTickEvents.End.class, FabricEntityEvents.ENTITY_TICK_END);
        INSTANCE.register(ArrowLooseCallback.class, FabricPlayerEvents.ARROW_LOOSE);
        INSTANCE.register(LivingHurtCallback.class, FabricLivingEvents.LIVING_HURT);
        INSTANCE.register(UseItemEvents.Start.class, FabricLivingEvents.USE_ITEM_START);
        INSTANCE.register(UseItemEvents.Tick.class, FabricLivingEvents.USE_ITEM_TICK);
        INSTANCE.register(UseItemEvents.Stop.class, FabricLivingEvents.USE_ITEM_STOP);
        INSTANCE.register(UseItemEvents.Finish.class, FabricLivingEvents.USE_ITEM_FINISH);
        INSTANCE.register(ShieldBlockCallback.class, FabricLivingEvents.SHIELD_BLOCK);
        INSTANCE.register(ExplosionEvents.Start.class, FabricLevelEvents.EXPLOSION_START);
        INSTANCE.register(ExplosionEvents.Detonate.class, FabricLevelEvents.EXPLOSION_DETONATE);
        INSTANCE.register(SyncDataPackContentsCallback.class, ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS, (T callback) -> callback::onSyncDataPackContents);
        INSTANCE.register(ServerLifecycleEvents.Started.class, ServerLifecycleEvents.SERVER_STARTED, (T callback) -> callback::onServerStarted);
        INSTANCE.register(ServerLifecycleEvents.Stopping.class, ServerLifecycleEvents.SERVER_STOPPING, (T callback) -> callback::onServerStopping);
        INSTANCE.register(ServerLifecycleEvents.Stopped.class, ServerLifecycleEvents.SERVER_STOPPED, (T callback) -> callback::onServerStopped);
        INSTANCE.register(PlaySoundEvents.AtPosition.class, FabricLevelEvents.PLAY_SOUND_AT_POSITION);
        INSTANCE.register(PlaySoundEvents.AtEntity.class, FabricLevelEvents.PLAY_SOUND_AT_ENTITY);
        INSTANCE.register(ServerEntityLevelEvents.Load.class, FabricEntityEvents.ENTITY_LOAD);
        INSTANCE.register(ServerEntityLevelEvents.Unload.class, ServerEntityEvents.ENTITY_UNLOAD, (T callback) -> callback::onEntityUnload);
        INSTANCE.register(LivingDeathCallback.class, FabricLivingEvents.LIVING_DEATH);
        INSTANCE.register(PlayerTrackingEvents.Start.class, EntityTrackingEvents.START_TRACKING, (T callback) -> callback::onStartTracking);
        INSTANCE.register(PlayerTrackingEvents.Stop.class, EntityTrackingEvents.STOP_TRACKING, (T callback) -> callback::onStopTracking);
        INSTANCE.register(PlayerNetworkEvents.LoggedIn.class, ServerPlayerEvents.JOIN, (T callback) -> callback::onLoggedIn);
        INSTANCE.register(PlayerNetworkEvents.LoggedOut.class, ServerPlayerEvents.LEAVE, (T callback) -> callback::onLoggedOut);
        INSTANCE.register(AfterChangeDimensionCallback.class, ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD, (T callback) -> callback::onAfterChangeDimension);
        INSTANCE.register(BabyEntitySpawnCallback.class, FabricLivingEvents.BABY_ENTITY_SPAWN);
        INSTANCE.register(AnimalTameCallback.class, FabricLivingEvents.ANIMAL_TAME);
        INSTANCE.register(LivingAttackCallback.class, ServerLivingEntityEvents.ALLOW_DAMAGE, (T callback) -> (entity, source, amount) -> callback.onLivingAttack(entity, source, amount).isPass());
        INSTANCE.register(PlayerCopyEvents.Copy.class, ServerPlayerEvents.COPY_FROM, (T callback) -> callback::onCopy);
        INSTANCE.register(PlayerCopyEvents.Respawn.class, ServerPlayerEvents.AFTER_RESPAWN, (T callback) -> (oldPlayer, newPlayer, alive) -> callback.onRespawn(newPlayer, alive));
        INSTANCE.register(ServerTickEvents.Start.class, ServerTickEvents.START_SERVER_TICK, (T callback) -> callback::onStartServerTick);
        INSTANCE.register(ServerTickEvents.End.class, ServerTickEvents.END_SERVER_TICK, (T callback) -> callback::onEndServerTick);
        INSTANCE.register(ServerLevelTickEvents.Start.class, ServerTickEvents.START_WORLD_TICK, (T callback) -> serverLevel -> callback.onStartLevelTick(serverLevel.method_8503(), serverLevel));
        INSTANCE.register(ServerLevelTickEvents.End.class, ServerTickEvents.END_WORLD_TICK, (T callback) -> serverLevel -> callback.onEndLevelTick(serverLevel.method_8503(), serverLevel));
        INSTANCE.register(ServerLevelEvents.Load.class, ServerWorldEvents.LOAD, (T callback) -> callback::onLevelLoad);
        INSTANCE.register(ServerLevelEvents.Unload.class, ServerWorldEvents.UNLOAD, (T callback) -> callback::onLevelUnload);
        INSTANCE.register(ServerChunkEvents.Load.class, ServerChunkEvents.CHUNK_LOAD, (T callback) -> callback::onChunkLoad);
        INSTANCE.register(ServerChunkEvents.Unload.class, ServerChunkEvents.CHUNK_UNLOAD, (T callback) -> callback::onChunkUnload);
        INSTANCE.register(ItemEntityEvents.Toss.class, FabricPlayerEvents.ITEM_TOSS);
        INSTANCE.register(LivingKnockBackCallback.class, FabricLivingEvents.LIVING_KNOCK_BACK);
        INSTANCE.register(ProjectileImpactCallback.class, FabricEntityEvents.PROJECTILE_IMPACT);
        INSTANCE.register(CalculateBlockBreakSpeedCallback.class, FabricPlayerEvents.CALCULATE_BLOCK_BREAK_SPEED);
        INSTANCE.register(MobEffectEvents.Affects.class, FabricLivingEvents.MOB_EFFECT_AFFECTS);
        INSTANCE.register(MobEffectEvents.Apply.class, FabricLivingEvents.MOB_EFFECT_APPLY);
        INSTANCE.register(MobEffectEvents.Remove.class, FabricLivingEvents.MOB_EFFECT_REMOVE);
        INSTANCE.register(MobEffectEvents.Expire.class, FabricLivingEvents.MOB_EFFECT_EXPIRE);
        INSTANCE.register(LivingJumpCallback.class, FabricLivingEvents.LIVING_JUMP);
        INSTANCE.register(LivingVisibilityCallback.class, FabricLivingEvents.LIVING_VISIBILITY);
        INSTANCE.register(LivingChangeTargetCallback.class, FabricLivingEvents.LIVING_CHANGE_TARGET);
        INSTANCE.register(CheckMobDespawnCallback.class, FabricLivingEvents.CHECK_MOB_DESPAWN);
        INSTANCE.register(GatherPotentialSpawnsCallback.class, FabricLevelEvents.GATHER_POTENTIAL_SPAWNS);
        INSTANCE.register(EntityRidingEvents.Start.class, FabricEntityEvents.ENTITY_START_RIDING);
        INSTANCE.register(EntityRidingEvents.Stop.class, FabricEntityEvents.ENTITY_STOP_RIDING);
        INSTANCE.register(ServerChunkEvents.Watch.class, FabricLevelEvents.WATCH_CHUNK);
        INSTANCE.register(ServerChunkEvents.Unwatch.class, FabricLevelEvents.UNWATCH_CHUNK);
        INSTANCE.register(LivingEquipmentChangeCallback.class, ServerEntityEvents.EQUIPMENT_CHANGE, (T callback) -> callback::onLivingEquipmentChange);
        INSTANCE.register(LivingConversionCallback.class, ServerLivingEntityEvents.MOB_CONVERSION, (T callback) -> (previous, converted, conversionContext) -> callback.onLivingConversion((class_1309)previous, (class_1309)converted));
        INSTANCE.register(ContainerEvents.Open.class, FabricPlayerEvents.CONTAINER_OPEN);
        INSTANCE.register(ContainerEvents.Close.class, FabricPlayerEvents.CONTAINER_CLOSE);
        INSTANCE.register(LookingAtEndermanCallback.class, FabricLivingEvents.LOOKING_AT_ENDERMAN);
        INSTANCE.register(RegisterPotionBrewingMixesCallback.class, FabricBrewingRecipeRegistryBuilder.BUILD, (T callback) -> builder -> callback.onRegisterPotionBrewingMixes(new FabricPotionBrewingBuilder(builder)));
        INSTANCE.register(ChangeEntitySizeCallback.class, FabricEntityEvents.CHANGE_ENTITY_SIZE);
        INSTANCE.register(PickProjectileCallback.class, FabricLivingEvents.PICK_PROJECTILE);
        INSTANCE.register(EnderPearlTeleportCallback.class, FabricEntityEvents.ENDER_PEARL_TELEPORT);
        INSTANCE.register(BuildCreativeModeTabContentsCallback.class, ItemGroupEvents.ModifyEntries.class, (T callback, Object context) -> entries -> {
            Objects.requireNonNull(context, "context is null");
            class_5321 resourceKey = (class_5321)context;
            class_1761 creativeModeTab = (class_1761)entries.getContext().comp_1253().method_46762(class_7924.field_44688).method_46747(resourceKey).comp_349();
            callback.onBuildCreativeModeTabContents(creativeModeTab, entries.getContext(), (class_1761.class_7704)entries);
        }, (Object context, Consumer<Event<E>> applyToInvoker, Consumer<Event<E>> removeInvoker) -> {
            Objects.requireNonNull(context, "context is null");
            class_5321 resourceKey = (class_5321)context;
            applyToInvoker.accept(ItemGroupEvents.modifyEntriesEvent((class_5321)resourceKey));
        }, UnaryOperator.identity(), false);
    }

    @Override
    public <T, E> void register(Class<T> clazz, Event<E> event, FabricEventInvokerRegistry.FabricEventContextConverter<T, E> converter, UnaryOperator<EventPhase> eventPhaseConverter, boolean joinInvokers) {
        Objects.requireNonNull(clazz, "type is null");
        Objects.requireNonNull(event, "event is null");
        Objects.requireNonNull(converter, "converter is null");
        EventInvokerImpl.register(clazz, new FabricEventInvoker<T, E>(event, converter, eventPhaseConverter), joinInvokers);
    }

    @Override
    public <T, E> void register(Class<T> clazz, Class<E> eventType, FabricEventInvokerRegistry.FabricEventContextConverter<T, E> converter, FabricEventInvokerRegistry.FabricEventContextConsumer<E> consumer, UnaryOperator<EventPhase> eventPhaseConverter, boolean joinInvokers) {
        Objects.requireNonNull(clazz, "type is null");
        Objects.requireNonNull(eventType, "event type is null");
        Objects.requireNonNull(converter, "converter is null");
        Objects.requireNonNull(consumer, "consumer is null");
        EventInvokerImpl.register(clazz, new FabricForwardingEventInvoker<T, E>(converter, consumer, eventPhaseConverter), joinInvokers);
    }

    private record FabricEventInvoker<T, E>(Event<E> event, FabricEventInvokerRegistry.FabricEventContextConverter<T, E> converter, UnaryOperator<EventPhase> eventPhaseConverter, Set<EventPhase> knownEventPhases) implements EventInvoker<T>,
    EventInvokerImpl.EventInvokerLike<T>
    {
        public FabricEventInvoker(Event<E> event, FabricEventInvokerRegistry.FabricEventContextConverter<T, E> converter, UnaryOperator<EventPhase> eventPhaseConverter) {
            this(event, converter, eventPhaseConverter, Collections.synchronizedSet(Sets.newIdentityHashSet()));
        }

        @Override
        public EventInvoker<T> asEventInvoker(@Nullable Object context) {
            return context != null ? (phase, callback) -> this.register(phase, callback, context) : this;
        }

        @Override
        public void register(EventPhase eventPhase, T callback) {
            this.register(eventPhase, callback, null);
        }

        private void register(EventPhase eventPhase, T callback, @Nullable Object context) {
            Objects.requireNonNull(eventPhase, "phase is null");
            Objects.requireNonNull(callback, "callback is null");
            eventPhase = (EventPhase)this.eventPhaseConverter.apply(eventPhase);
            if (eventPhase.parent() == null) {
                this.event.register(this.converter.apply(callback, context));
            } else {
                this.registerEventPhaseIfNecessary(eventPhase);
                this.event.register(eventPhase.resourceLocation(), this.converter.apply(callback, context));
            }
        }

        private void registerEventPhaseIfNecessary(EventPhase eventPhase) {
            FabricEventInvoker.registerEventPhaseIfNecessary(this.event, eventPhase, this.knownEventPhases);
        }

        private static void registerEventPhaseIfNecessary(Event<?> event, EventPhase eventPhase, Collection<EventPhase> knownEventPhases) {
            Stack<EventPhase> stack = new Stack<EventPhase>();
            while (eventPhase.parent() != null && !knownEventPhases.contains(eventPhase)) {
                stack.push(eventPhase);
                eventPhase = eventPhase.parent();
            }
            block1: while (!stack.isEmpty()) {
                eventPhase = (EventPhase)stack.pop();
                eventPhase.applyOrdering((arg_0, arg_1) -> event.addPhaseOrdering(arg_0, arg_1));
                knownEventPhases.add(eventPhase);
                EventPhase parentEventPhase = eventPhase;
                while ((parentEventPhase = parentEventPhase.parent()) != null && parentEventPhase.parent() != null) {
                    if (eventPhase.getOrderingValue() == parentEventPhase.getOrderingValue()) continue;
                    parentEventPhase.applyOrdering(eventPhase.resourceLocation(), (arg_0, arg_1) -> event.addPhaseOrdering(arg_0, arg_1));
                    continue block1;
                }
            }
        }
    }

    private record FabricForwardingEventInvoker<T, E>(Function<Event<E>, EventInvokerImpl.EventInvokerLike<T>> factory, FabricEventInvokerRegistry.FabricEventContextConsumer<E> consumer, Map<Event<E>, EventInvokerImpl.EventInvokerLike<T>> events) implements EventInvokerImpl.EventInvokerLike<T>
    {
        public FabricForwardingEventInvoker(FabricEventInvokerRegistry.FabricEventContextConverter<T, E> converter, FabricEventInvokerRegistry.FabricEventContextConsumer<E> consumer, UnaryOperator<EventPhase> eventPhaseConverter) {
            this((Event<E> event) -> new FabricEventInvoker(event, converter, eventPhaseConverter), consumer, new MapMaker().weakKeys().concurrencyLevel(1).makeMap());
        }

        @Override
        public EventInvoker<T> asEventInvoker(Object context) {
            Objects.requireNonNull(context, "context is null");
            return (phase, callback) -> this.consumer.accept(context, event -> this.events.computeIfAbsent((Event<E>)event, this.factory).asEventInvoker(context).register(phase, callback), this.events::remove);
        }
    }
}

