/*
 * Decompiled with CFR 0.152.
 */
package fr.hugman.promenade.block;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_10774;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class BerryBushBlock
extends class_2261
implements class_2256 {
    public static final MapCodec<BerryBushBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41197).fieldOf("berry").forGetter(block -> block.berry), (App)Codec.BOOL.fieldOf("is_spiny").forGetter(block -> block.isSpiny), (App)BerryBushBlock.method_54096()).apply((Applicative)instance, BerryBushBlock::new));
    private static final float MIN_MOVEMENT_FOR_DAMAGE = 0.003f;
    public static final int MAX_AGE = 3;
    public static final class_2758 AGE = class_2741.field_12497;
    private static final class_265 SMALL_SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final class_265 LARGE_SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private final class_5321<class_1792> berry;
    private final boolean isSpiny;

    public BerryBushBlock(class_5321<class_1792> berry, boolean isSpiny, class_4970.class_2251 settings) {
        super(settings);
        this.berry = berry;
        this.isSpiny = isSpiny;
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<BerryBushBlock> method_53969() {
        return CODEC;
    }

    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return new class_1799((class_1935)DataFixUtils.orElse((Optional)world.method_30349().method_30530(class_7924.field_41197).method_31189(this.berry), (Object)((Object)this)));
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if ((Integer)state.method_11654((class_2769)AGE) == 0) {
            return SMALL_SHAPE;
        }
        if ((Integer)state.method_11654((class_2769)AGE) < 3) {
            return LARGE_SHAPE;
        }
        return super.method_9530(state, world, pos, context);
    }

    protected boolean method_9542(class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) < 3;
    }

    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        int age = (Integer)state.method_11654((class_2769)AGE);
        if (age < 3 && random.method_43048(5) == 0 && world.method_22335(pos.method_10084(), 0) >= 9) {
            class_2680 blockState = (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age + 1));
            world.method_8652(pos, blockState, 2);
            world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)blockState));
        }
    }

    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity, class_10774 handler) {
        if (!(entity instanceof class_1309) || entity.method_5864() == class_1299.field_17943 || entity.method_5864() == class_1299.field_20346) {
            return;
        }
        entity.method_5844(state, new class_243((double)0.8f, 0.75, (double)0.8f));
        if (this.isSpiny && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if ((Integer)state.method_11654((class_2769)AGE) != 0) {
                class_243 vec3d;
                class_243 class_2432 = vec3d = entity.method_65038() ? entity.method_60478() : entity.method_61411().method_1020(entity.method_19538());
                if (vec3d.method_37268() > 0.0) {
                    double d = Math.abs(vec3d.method_10216());
                    double e = Math.abs(vec3d.method_10215());
                    if (d >= (double)0.003f || e >= (double)0.003f) {
                        entity.method_64397(serverWorld, world.method_48963().method_48835(), 1.0f);
                    }
                }
            }
        }
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        return (Integer)state.method_11654((class_2769)AGE) != 3 && stack.method_31574(class_1802.field_8324) ? class_1269.field_5811 : super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        int age = (Integer)state.method_11654((class_2769)AGE);
        if (age > 1) {
            int j = 1 + world.field_9229.method_43048(2);
            BerryBushBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)DataFixUtils.orElse((Optional)world.method_30349().method_30530(class_7924.field_41197).method_31189(this.berry), (Object)((Object)this)), j + (age == 3 ? 1 : 0)));
            world.method_8396(null, pos, class_3417.field_17617, class_3419.field_15245, 1.0f, 0.8f + world.field_9229.method_43057() * 0.4f);
            class_2680 blockState = (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(1));
            world.method_8652(pos, blockState, 2);
            world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)blockState));
            return class_1269.field_5812;
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AGE});
    }

    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) < 3;
    }

    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return true;
    }

    public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
        int i = Math.min(3, (Integer)state.method_11654((class_2769)AGE) + 1);
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

