/*
 * Decompiled with CFR 0.152.
 */
package fr.hugman.promenade.block.helper;

import fr.hugman.promenade.block.FungusBlock;
import fr.hugman.promenade.block.HangingLeavesBlock;
import fr.hugman.promenade.block.PileBlock;
import fr.hugman.promenade.block.SaplingBlock;
import fr.hugman.promenade.block.TintedParticleSnowyLeavesBlock;
import fr.hugman.promenade.block.UntintedParticleSnowyLeavesBlock;
import fr.hugman.promenade.block.helper.BlockBuilder;
import fr.hugman.promenade.sound.PromenadeBlockSounds;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_10595;
import net.minecraft.class_10716;
import net.minecraft.class_10717;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2362;
import net.minecraft.class_2394;
import net.minecraft.class_2440;
import net.minecraft.class_2465;
import net.minecraft.class_2473;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2508;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2544;
import net.minecraft.class_2551;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_2975;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_8177;
import net.minecraft.class_8813;

public final class BlockFactory {
    public static BlockBuilder of(Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return new BlockBuilder(factory, settings);
    }

    public static BlockBuilder of(class_4970.class_2251 settings) {
        return new BlockBuilder(settings);
    }

    public static BlockBuilder copy(class_2248 block) {
        return new BlockBuilder(block);
    }

    public static BlockBuilder slab(class_2248 baseBlock) {
        return BlockFactory.copy(baseBlock).factory(class_2482::new);
    }

    public static BlockBuilder stairs(class_2248 baseBlock) {
        return BlockFactory.copy(baseBlock).factory(s -> new class_2510(baseBlock.method_9564(), s));
    }

    public static BlockBuilder wall(class_2248 baseBlock) {
        return BlockFactory.copy(baseBlock).factory(class_2544::new).settings(class_4970.class_2251.method_55226((class_4970)baseBlock).method_51369());
    }

    public static BlockBuilder fence(class_2248 baseBlock) {
        return BlockFactory.copy(baseBlock).factory(class_2354::new).settings(class_4970.class_2251.method_55226((class_4970)baseBlock));
    }

    public static BlockBuilder fenceGate(class_2248 baseBlock, class_4719 woodType) {
        return BlockFactory.copy(baseBlock).factory(s -> new class_2349(woodType, s)).settings(class_4970.class_2251.method_55226((class_4970)baseBlock).method_51369());
    }

    public static BlockBuilder trapdoor(class_2248 baseBlock, class_8177 setType) {
        return BlockFactory.copy(baseBlock).factory(s -> new class_2533(setType, s)).settings(class_4970.class_2251.method_55226((class_4970)baseBlock).method_9632(3.0f).method_22488().method_26235(class_2246::method_26114));
    }

    public static BlockBuilder door(class_2248 baseBlock, class_8177 setType) {
        return BlockFactory.copy(baseBlock).factory(s -> new class_2323(setType, s)).settings(class_4970.class_2251.method_55226((class_4970)baseBlock).method_9632(3.0f).method_22488().method_50012(class_3619.field_15971));
    }

    public static BlockBuilder woodenButton(class_2248 baseBlock, class_8177 setType) {
        return BlockFactory.copy(baseBlock).factory(s -> new class_2269(setType, 30, s)).settings(class_4970.class_2251.method_9637().method_9632(0.5f).method_9634().method_50012(class_3619.field_15971).method_9626(baseBlock.method_9564().method_26231()));
    }

    public static BlockBuilder pressurePlate(class_2248 baseBlock, class_8177 setType) {
        return BlockFactory.copy(baseBlock).factory(s -> new class_2440(setType, s)).settings(class_4970.class_2251.method_55226((class_4970)baseBlock).method_51369().method_9632(0.5f).method_50012(class_3619.field_15971).method_29292().method_9634());
    }

    public static BlockBuilder sign(class_2248 baseBlock, class_4719 woodType) {
        return BlockFactory.copy(baseBlock).factory(s -> new class_2508(woodType, s)).settings(class_4970.class_2251.method_55226((class_4970)baseBlock).method_31710(baseBlock.method_26403()).method_51369().method_9634().method_9632(1.0f)).noItem();
    }

    public static BlockBuilder wallSign(class_2248 standingSign, class_4719 woodType) {
        return BlockFactory.copy(standingSign).factory(s -> new class_2551(woodType, s)).settings(class_4970.class_2251.method_55226((class_4970)standingSign).method_63502(standingSign.method_26162()).method_31710(standingSign.method_26403()).method_51369().method_9634().method_9632(1.0f)).noItem();
    }

    public static BlockBuilder hangingSign(class_2248 baseBlock, class_4719 woodType, class_2498 soundGroup) {
        return BlockFactory.copy(baseBlock).factory(s -> new class_7713(woodType, s)).settings(class_4970.class_2251.method_55226((class_4970)baseBlock).method_31710(baseBlock.method_26403()).method_51369().method_9634().method_9632(1.0f).method_9626(soundGroup)).noItem();
    }

    public static BlockBuilder wallHangingSign(class_2248 standingSign, class_4719 woodType, class_2498 soundGroup) {
        return BlockFactory.copy(standingSign).factory(s -> new class_7715(woodType, s)).settings(class_4970.class_2251.method_55226((class_4970)standingSign).method_63502(standingSign.method_26162()).method_31710(standingSign.method_26403()).method_51369().method_9634().method_9632(1.0f).method_9626(soundGroup)).noItem();
    }

    public static BlockBuilder log(class_3620 woodColor, class_3620 barkColor, class_2498 sounds, boolean flammable) {
        return BlockFactory.log(woodColor, sounds, flammable).settings(settings -> settings.method_51520(state -> state.method_11654((class_2769)class_2465.field_11459) == class_2350.class_2351.field_11052 ? woodColor : barkColor));
    }

    public static BlockBuilder log(class_3620 color, class_2498 sounds, boolean flammable) {
        class_4970.class_2251 settings = class_4970.class_2251.method_9637().method_31710(color).method_51368(class_2766.field_12651).method_9632(2.0f).method_9626(sounds);
        if (flammable) {
            settings.method_50013();
        }
        BlockBuilder builder = new BlockBuilder(class_2465::new, settings);
        return builder;
    }

    public static BlockBuilder sapling(class_3620 mapColor, class_8813 generator) {
        return new BlockBuilder(s -> new class_2473(generator, s), class_4970.class_2251.method_9637().method_31710(mapColor).method_9626(class_2498.field_11535).method_9618().method_9634().method_9640().method_50012(class_3619.field_15971));
    }

    public static BlockBuilder sapling(class_3620 mapColor, class_8813 generator, Predicate<class_2680> saplingSoilPredicate) {
        return BlockFactory.sapling(mapColor, generator).factory(settings -> new SaplingBlock(generator, saplingSoilPredicate, (class_4970.class_2251)settings));
    }

    public static BlockBuilder leaves(class_3620 mapColor) {
        return new BlockBuilder(s -> new class_10716(0.01f, s), class_4970.class_2251.method_9637().method_31710(mapColor).method_9632(0.2f).method_9640().method_9626(class_2498.field_11535).method_22488().method_26235(class_2246::method_26114).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122).method_50012(class_3619.field_15971).method_26236(class_2246::method_26122));
    }

    public static BlockBuilder leaves(class_3620 mapColor, class_2498 soundGroup, float particleChance, class_2394 fallingParticle) {
        return new BlockBuilder(s -> new class_10717(particleChance, fallingParticle, s), class_4970.class_2251.method_9637().method_31710(mapColor).method_9632(0.2f).method_9640().method_9626(soundGroup).method_22488().method_50013().method_26235(class_2246::method_26114).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122).method_50012(class_3619.field_15971).method_26236(class_2246::method_26122));
    }

    public static BlockBuilder hangingLeaves(class_3620 mapColor) {
        return new BlockBuilder(HangingLeavesBlock::new, class_4970.class_2251.method_9637().method_31710(mapColor).method_9626(class_2498.field_11535).method_51371().method_9634().method_9618().method_50013().method_50012(class_3619.field_15971));
    }

    public static BlockBuilder snowyLeaves() {
        return new BlockBuilder(s -> new TintedParticleSnowyLeavesBlock(0.01f, (class_4970.class_2251)s), class_4970.class_2251.method_9637().method_31710(class_3620.field_16022).method_9632(0.2f).method_9640().method_9626(PromenadeBlockSounds.SNOWY_LEAVES).method_22488().method_50013().method_26235(class_2246::method_26126).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122).method_50012(class_3619.field_15971).method_26236(class_2246::method_26122));
    }

    public static BlockBuilder snowyLeaves(class_2498 soundGroup) {
        return BlockFactory.snowyLeaves().settings(settings -> settings.method_9626(soundGroup));
    }

    public static BlockBuilder snowyLeaves(float particleChance, class_2394 particle) {
        return BlockFactory.snowyLeaves().factory(s -> new UntintedParticleSnowyLeavesBlock(particleChance, particle, (class_4970.class_2251)s));
    }

    public static BlockBuilder snowyLeaves(float particleChance, class_2394 particle, class_2498 soundGroup) {
        return BlockFactory.snowyLeaves(particleChance, particle).settings(settings -> settings.method_9626(soundGroup));
    }

    public static BlockBuilder pot(class_2248 block) {
        return new BlockBuilder(s -> new class_2362(block, s), class_4970.class_2251.method_9637().method_9618().method_22488().method_9631(state -> block.method_9564().method_26213()).method_50012(class_3619.field_15971));
    }

    public static BlockBuilder pile() {
        return BlockFactory.pile(class_3620.field_16004);
    }

    public static BlockBuilder pile(class_3620 color) {
        return BlockFactory.pile(color, class_2498.field_11535);
    }

    public static BlockBuilder pile(class_3620 color, class_2498 sounds) {
        return new BlockBuilder(PileBlock::new, class_4970.class_2251.method_9637().method_31710(color).method_50013().method_9632(0.1f).method_9626(sounds).method_9634().method_22488());
    }

    public static BlockBuilder fallenLeaves(class_3620 color) {
        return BlockFactory.fallenLeaves(color, class_2498.field_55793);
    }

    public static BlockBuilder fallenLeaves(class_3620 color, class_2498 sounds) {
        return new BlockBuilder(class_10595::new, class_4970.class_2251.method_9637().method_31710(color).method_51371().method_9634().method_9626(sounds).method_50012(class_3619.field_15971));
    }

    public static BlockBuilder fungus(class_3620 mapColor, class_5321<class_2975<?, ?>> featureKey, class_6862<class_2248> canPlantOn, class_6862<class_2248> canGrowOn) {
        return BlockFactory.of(s -> new FungusBlock(featureKey, canPlantOn, canGrowOn, (class_4970.class_2251)s), class_4970.class_2251.method_9637().method_31710(mapColor).method_9626(class_2498.field_22154).method_50012(class_3619.field_15971).method_9618().method_9634());
    }
}

