/*
 * Decompiled with CFR 0.152.
 */
package fr.hugman.promenade.entity;

import fr.hugman.promenade.component.PromenadeComponentTypes;
import fr.hugman.promenade.entity.PromenadeEntityTypes;
import fr.hugman.promenade.entity.data.PromenadeTrackedData;
import fr.hugman.promenade.entity.variant.DuckVariant;
import fr.hugman.promenade.entity.variant.DuckVariants;
import fr.hugman.promenade.registry.PromenadeRegistryKeys;
import fr.hugman.promenade.sound.PromenadeSoundEvents;
import fr.hugman.promenade.tag.PromenadeItemTags;
import net.minecraft.class_10701;
import net.minecraft.class_10704;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1378;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_9331;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public class DuckEntity
extends class_1429 {
    private static final class_4048 BABY_BASE_DIMENSIONS = class_4048.method_18384((float)0.4f, (float)0.8f).method_18383(0.5f).method_55685(0.78125f);
    private static final class_2940<class_6880<DuckVariant>> VARIANT = class_2945.method_12791(DuckEntity.class, PromenadeTrackedData.DUCK_VARIANT);
    public float flapProgress;
    public float maxWingDeviation;
    public float prevMaxWingDeviation;
    public float prevFlapProgress;
    public float wingRotDelta = 1.0f;

    public DuckEntity(class_1299<? extends DuckEntity> type, class_1937 worldIn) {
        super(type, worldIn);
        this.method_5941(class_7.field_18, 0.0f);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        DuckVariants.select(this.field_5974, this.method_56673(), class_10701.method_67169((class_5425)world, (class_2338)this.method_24515())).ifPresent(this::setVariant);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected class_4048 method_55694(class_4050 pose) {
        return this.method_6109() ? BABY_BASE_DIMENSIONS : super.method_55694(pose);
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        super.method_5865(passenger, positionUpdater);
        if (passenger instanceof class_1309) {
            ((class_1309)passenger).field_6283 = this.field_6283;
        }
    }

    public static class_5132.class_5133 createDuckAttributes() {
        return DuckEntity.method_61457().method_26868(class_5134.field_23716, 4.0).method_26868(class_5134.field_23719, 0.25);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.4));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.0, stack -> stack.method_31573(PromenadeItemTags.DUCK_FOOD), false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)new class_1378((class_1314)this, 1.0, 10));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    public void method_6007() {
        super.method_6007();
        boolean isAirBorne = !this.method_24828() && !this.method_5799();
        this.prevFlapProgress = this.flapProgress;
        this.prevMaxWingDeviation = this.maxWingDeviation;
        this.maxWingDeviation = (float)((double)this.maxWingDeviation + (double)(!isAirBorne ? -1 : 4) * 0.3);
        this.maxWingDeviation = class_3532.method_15363((float)this.maxWingDeviation, (float)0.0f, (float)1.0f);
        if (isAirBorne && this.wingRotDelta < 0.55f) {
            this.wingRotDelta = 0.55f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        class_243 vec3d = this.method_18798();
        if (isAirBorne && vec3d.field_1351 < 0.0) {
            this.method_18799(vec3d.method_18805(1.0, 0.75, 1.0));
        }
        this.flapProgress += this.wingRotDelta * 2.0f;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(PromenadeItemTags.DUCK_FOOD);
    }

    protected float method_6120() {
        return 0.9f;
    }

    protected class_3414 method_5994() {
        return PromenadeSoundEvents.DUCK_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return PromenadeSoundEvents.DUCK_HURT;
    }

    protected class_3414 method_6002() {
        return PromenadeSoundEvents.DUCK_DEATH;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(PromenadeSoundEvents.DUCK_STEP, 0.15f, 1.0f);
    }

    @Nullable
    public DuckEntity createChild(class_3218 serverWorld, class_1296 entity) {
        DuckEntity child = (DuckEntity)PromenadeEntityTypes.DUCK.method_5883(this.method_37908(), class_3730.field_16466);
        if (child != null && entity instanceof DuckEntity) {
            DuckEntity mama = (DuckEntity)entity;
            child.setVariant(this.field_5974.method_43057() < 0.5f ? mama.getVariant() : this.getVariant());
        }
        return child;
    }

    public class_6880<DuckVariant> getVariant() {
        return (class_6880)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(class_6880<DuckVariant> registryEntry) {
        this.field_6011.method_12778(VARIANT, registryEntry);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)class_10704.method_67175((class_5455)this.method_56673(), DuckVariants.DEFAULT));
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        class_10704.method_67177((class_11372)view, this.getVariant());
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        class_10704.method_67178((class_11368)view, PromenadeRegistryKeys.DUCK_VARIANT).ifPresent(this::setVariant);
    }

    @Nullable
    public <T> T method_58694(class_9331<? extends T> type) {
        return (T)(type == PromenadeComponentTypes.DUCK_VARIANT ? DuckEntity.method_66651(type, this.getVariant()) : super.method_58694(type));
    }

    protected void method_66649(class_9473 from) {
        this.method_66650(from, PromenadeComponentTypes.DUCK_VARIANT);
        super.method_66649(from);
    }

    protected <T> boolean method_66654(class_9331<T> type, T value) {
        if (type == PromenadeComponentTypes.DUCK_VARIANT) {
            this.setVariant((class_6880<DuckVariant>)((class_6880)DuckEntity.method_66651(PromenadeComponentTypes.DUCK_VARIANT, value)));
            return true;
        }
        return super.method_66654(type, value);
    }
}

