/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.collection;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import team.creative.creativecore.client.gui.control.collection.GuiClientStackSelector;
import team.creative.creativecore.client.gui.control.parent.GuiClientScrollY;
import team.creative.creativecore.client.gui.extension.GuiExtensionCreator;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.control.collection.GuiStackSelectorExtension;
import team.creative.creativecore.common.gui.control.inventory.GuiInventoryGridPreview;
import team.creative.creativecore.common.gui.control.inventory.GuiSlotViewer;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.util.type.map.HashMapList;

public class GuiClientStackSelectorExtension<T extends GuiStackSelectorExtension>
extends GuiClientScrollY<T>
implements GuiStackSelectorExtension.GuiStackSelectorExtensionDist {
    private GuiExtensionCreator<GuiClientStackSelector<?>, GuiStackSelectorExtension> creator;
    private String search = "";
    protected int cachedWidth;

    public GuiClientStackSelectorExtension(T control) {
        super(control);
        ((GuiParent)control).registerEventChanged(x -> {
            if (x.control.is("searchBar")) {
                this.search = ((GuiTextfield)x.control).getText();
                this.reloadControls();
            }
        });
        ((GuiParent)control).registerEventClick(event -> {
            if (event.control instanceof GuiSlotViewer && event.control.isParent((IGuiParent)control)) {
                ((GuiClientStackSelector)this.creator.parent).setSelected(((GuiSlotViewer)event.control).getStack(), true);
                this.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
                this.creator.close();
            }
        });
    }

    public void init(GuiExtensionCreator<GuiClientStackSelector<?>, GuiStackSelectorExtension> creator) {
        this.creator = creator;
        this.reloadControls();
    }

    public GuiExtensionCreator<GuiClientStackSelector<?>, GuiStackSelectorExtension> creator() {
        return this.creator;
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        super.mouseClicked(x, y, button);
        this.creator.markKeptFocus();
        return true;
    }

    @Override
    public void flowX(int width, int preferred) {
        this.cachedWidth = width;
        super.flowX(width, preferred);
    }

    @Override
    public void reflowInternal() {
        this.flowX(this.cachedWidth, this.preferredWidth(this.cachedWidth));
        this.flowY(this.cachedWidth, this.cachedHeight, this.preferredHeight(this.cachedWidth, this.cachedHeight));
    }

    public void reloadControls() {
        HashMapList<String, class_1799> stacks;
        if (this.creator == null) {
            return;
        }
        GuiClientStackSelector comboBox = (GuiClientStackSelector)this.creator.parent;
        HashMapList<String, class_1799> hashMapList = stacks = this.search == null || this.search.isEmpty() ? comboBox.getStacks() : new HashMapList<String, class_1799>();
        if (this.search != null && !this.search.isEmpty()) {
            for (Map.Entry<String, ArrayList<class_1799>> entry : comboBox.getStacks().entrySet()) {
                for (class_1799 stack : entry.getValue()) {
                    if (!GuiStackSelector.contains(this.search, stack)) continue;
                    stacks.add(entry.getKey(), stack);
                }
            }
        }
        GuiTextfield textfield = (GuiTextfield)((GuiStackSelectorExtension)this.control).get("searchBar");
        ((GuiStackSelectorExtension)this.control).clear();
        if (comboBox.hasSearchbar()) {
            if (textfield == null) {
                textfield = new GuiTextfield((IGuiParent)((Object)this.control), "searchBar", this.search == null ? "" : this.search);
            }
            ((GuiStackSelectorExtension)this.control).add(textfield.setExpandableX());
            textfield.dist().focus();
        }
        for (Map.Entry entry : stacks.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            ((GuiStackSelectorExtension)this.control).add((GuiControl)new GuiLabel((IGuiParent)((Object)this.control), "title").setTitle((class_2561)class_2561.method_43471((String)((String)entry.getKey()))));
            class_1277 container = new class_1277(entry.getValue().size());
            int i = 0;
            for (class_1799 stack : entry.getValue()) {
                container.method_5447(i, stack);
                ++i;
            }
            ((GuiStackSelectorExtension)this.control).add((GuiControl)new GuiInventoryGridPreview((IGuiParent)((Object)this.control), (String)entry.getKey(), (class_1263)container));
        }
        if (((GuiStackSelectorExtension)this.control).hasGui()) {
            this.reflowInternal();
        }
    }

    @Override
    public void looseFocus() {
        this.creator.markLostFocus();
    }
}

