/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.tree;

import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import team.creative.creativecore.client.gui.GuiClientParent;
import team.creative.creativecore.common.gui.control.tree.GuiTreeItem;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiClientTreeItem<T extends GuiTreeItem>
extends GuiClientParent<T> {
    private ItemClickState state = null;

    public GuiClientTreeItem(T control) {
        super(control);
    }

    @Override
    public void mouseMoved(double x, double y) {
        super.mouseMoved(x, y);
        if (this.state == ItemClickState.CLICKED && !((GuiTreeItem)this.control).tree.isDragged() && !this.rect.inside(x, y)) {
            ((GuiTreeItem)this.control).tree.startDrag((GuiTreeItem)this.control);
            this.state = ItemClickState.DRAGGED;
        }
    }

    @Override
    public void mouseReleased(double x, double y, int button) {
        super.mouseReleased(x, y, button);
        if (this.state == ItemClickState.CLICKED) {
            ((GuiTreeItem)this.control).tree.select((GuiTreeItem)this.control);
            this.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
            this.state = null;
        } else if (this.state == ItemClickState.DRAGGED) {
            this.state = null;
            if (((GuiTreeItem)this.control).tree.endDrag()) {
                this.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015, 0.1f, 2.0f);
            }
        }
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        if (super.mouseClicked(x, y, button)) {
            return true;
        }
        this.state = ItemClickState.CLICKED;
        return true;
    }

    @Override
    public boolean mouseDoubleClicked(double x, double y, int button) {
        ((GuiTreeItem)this.control).toggle();
        ((GuiTreeItem)this.control).tree.select((GuiTreeItem)this.control);
        this.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
        return true;
    }

    @Override
    public boolean testForDoubleClick(double x, double y, int button) {
        return button == 0;
    }

    @Override
    protected ControlFormatting defaultFormatting() {
        if (this.state == ItemClickState.DRAGGED) {
            return ControlFormatting.OUTLINE;
        }
        return super.getControlFormatting();
    }

    private static enum ItemClickState {
        CLICKED,
        DRAGGED;

    }
}

