/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.collection;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.parent.GuiColumn;
import team.creative.creativecore.common.gui.control.parent.GuiRow;
import team.creative.creativecore.common.gui.control.parent.GuiScrollY;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.creativecore.common.util.type.itr.FilterIterator;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;

public class GuiCheckList<T>
extends GuiScrollY {
    protected List<GuiCheckListRow> rows = new ArrayList<GuiCheckListRow>();
    public final boolean modifiable;
    public Predicate<T> canBeModified = x -> true;

    public GuiCheckList(IGuiParent parent, String name, boolean modifiable, TextMapBuilder<T> map, Object2BooleanMap<T> selected) {
        super(parent, name);
        this.modifiable = modifiable;
        if (map != null) {
            this.set(map, null);
        }
    }

    @Override
    public GuiCheckListDist dist() {
        return (GuiCheckListDist)super.dist();
    }

    public void set(TextMapBuilder<T> map, Object2BooleanMap<T> selected) {
        this.rows.clear();
        this.clear();
        for (Map.Entry<T, List<class_2561>> entry : map.entrySet()) {
            this.createControl(entry.getKey(), entry.getValue(), selected.getBoolean(entry.getKey()));
        }
        if (this.dist() != null) {
            this.dist().reflowInternal();
        }
    }

    protected void createControl(T key, List<class_2561> components, boolean selected) {
        GuiCheckListRow row = new GuiCheckListRow(this, key, components, selected);
        super.add((GuiControl)row);
        this.rows.add(row);
    }

    protected void removeControl(int index) {
        this.remove(this.rows.get(index));
        this.rows.remove(index);
    }

    protected GuiControl addCustomControl(GuiControl control) {
        return super.add(control);
    }

    protected GuiCheckList<T> addCustom(GuiControl control) {
        super.add(control);
        return this;
    }

    @Override
    @Deprecated
    public GuiParent add(GuiControl control) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public GuiParent addHover(GuiControl control) {
        throw new UnsupportedOperationException();
    }

    public void removeItem(int index) {
        this.removeControl(index);
        if (this.dist() != null) {
            this.dist().reflowInternal();
        }
        this.raiseEvent(new GuiControlChangedEvent<GuiCheckList>(this));
    }

    @Override
    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    public T getValue(int index) {
        return this.rows.get((int)index).value;
    }

    public Iterable<T> selectedItems() {
        return new FunctionIterator<Object>(new FilterIterator(this.rows, x -> x.checkBox.get()).iterator(), x -> x.value);
    }

    public Iterable<T> allItems() {
        return new FunctionIterator<Object>(this.rows, x -> x.value);
    }

    public boolean checked(int index) {
        return this.rows.get((int)index).checkBox.get();
    }

    public int indexOf(T value) {
        for (int i = 0; i < this.rows.size(); ++i) {
            if (this.rows.get((int)i).value != value) continue;
            return i;
        }
        return -1;
    }

    public static interface GuiCheckListDist
    extends GuiScrollY.GuiScrollYDist {
        public void reflowInternal();
    }

    public class GuiCheckListRow
    extends GuiRow {
        public final T value;
        public final GuiButton removeButton;
        public final GuiCheckBox checkBox;

        public GuiCheckListRow(IGuiParent parent, T value, List<class_2561> title, boolean selected) {
            super(parent);
            this.value = value;
            GuiColumn content = (GuiColumn)new GuiColumn(this).setExpandableX();
            content.setAlign(Align.LEFT);
            this.checkBox = new GuiCheckBox(this, "box", selected).setTitle((List)title);
            content.add((GuiControl)this.checkBox);
            this.addColumn(content);
            if (GuiCheckList.this.modifiable && GuiCheckList.this.canBeModified.test(value)) {
                GuiColumn remove = new GuiColumn((IGuiParent)this, 20);
                remove.setAlign(Align.CENTER);
                this.removeButton = new GuiButton(this, "x", x -> GuiCheckList.this.removeItem(GuiCheckList.this.indexOf(value)));
                this.removeButton.setDim(6, 8);
                this.removeButton.setAlign(Align.CENTER);
                this.removeButton.setTitle((class_2561)class_2561.method_43470((String)"x"));
                remove.add((GuiControl)this.removeButton);
                this.addColumn(remove);
            } else {
                this.removeButton = null;
            }
        }
    }
}

