/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.parent;

import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiControlDistHandler;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.parent.GuiRow;
import team.creative.creativecore.common.gui.control.parent.GuiScrollXY;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;

public class GuiTableScrollable
extends GuiParent {
    public final GuiRow topRow = new GuiRow(this);
    public final GuiParent bottom = new GuiParent(this);
    public final GuiParent firstCol = new GuiParent((IGuiParent)this, GuiFlow.STACK_Y);
    public final GuiScrollXY scrollableTable = new GuiScrollXY(this, "", GuiFlow.STACK_Y);

    public GuiTableScrollable(IGuiParent parent) {
        this(parent, "");
    }

    public GuiTableScrollable(IGuiParent parent, String name) {
        super(parent, name);
        this.setFlow(GuiFlow.STACK_Y);
        super.add((GuiControl)this.topRow);
        super.add((GuiControl)this.bottom);
        this.bottom.add((GuiControl)this.firstCol);
        this.bottom.add((GuiControl)this.scrollableTable);
        this.setSpacing(4);
    }

    @Override
    public GuiTableScrollableDist dist() {
        return (GuiTableScrollableDist)super.dist();
    }

    @Override
    @Deprecated
    public GuiParent add(GuiControl control) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public GuiParent addHover(GuiControl control) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GuiTableScrollable setExpandable() {
        return (GuiTableScrollable)super.setExpandable();
    }

    public GuiRow getTopRow() {
        return this.topRow;
    }

    public GuiTableScrollable addRow(GuiRow row) {
        if (row.colCount() == 0) {
            return this;
        }
        this.firstCol.add((GuiControl)row.removeCol(0));
        this.scrollableTable.add((GuiControl)row);
        return this;
    }

    @Override
    public boolean isExpandableX() {
        if (this.dist() != null) {
            return this.dist().isExpandableX();
        }
        return false;
    }

    @Override
    public boolean isExpandableY() {
        if (this.dist() != null) {
            return this.dist().isExpandableY();
        }
        return false;
    }

    public void removeContentCol(int index) {
        this.topRow.removeCol(index + 1);
        for (GuiControl control : this.scrollableTable) {
            ((GuiRow)control).removeCol(index);
        }
    }

    public Iterable<GuiRow> contentRows() {
        return new FunctionIterator<GuiRow>(this.scrollableTable, x -> (GuiRow)x);
    }

    @Override
    public GuiControlDistHandler createDist(GuiControl control) {
        if (this.dist() != null) {
            if (control == this.scrollableTable) {
                return this.dist().createScrollBox(this.scrollableTable);
            }
            if (control == this.topRow) {
                return this.dist().createTopRow(this.topRow);
            }
            if (control == this.firstCol) {
                return this.dist().createFirstCol(this.firstCol);
            }
        }
        return super.createDist(control);
    }

    public static interface GuiTableScrollableDist
    extends GuiParent.GuiParentDistHandler {
        public GuiScrollXY.GuiScrollXYDist createScrollBox(GuiScrollXY var1);

        public GuiParent.GuiParentDistHandler createTopRow(GuiRow var1);

        public GuiParent.GuiParentDistHandler createFirstCol(GuiParent var1);
    }
}

