/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.highlights.state;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;

public final class StateVariant {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);

    public static Codec<List<class_2680>> stateCodec(class_2248 block) {
        class_2689 stateDefinition = block.method_9595();
        return Codec.STRING.flatXmap(string -> StateVariant.getStates((class_2689<class_2248, class_2680>)stateDefinition, string), state -> DataResult.error(() -> "State variants can not be encoded back to a string."));
    }

    private static DataResult<List<class_2680>> getStates(class_2689<class_2248, class_2680> definition, String input) {
        List<class_2680> states = definition.method_11662().stream().filter(StateVariant.predicate(definition, input)).toList();
        return states.isEmpty() ? DataResult.error(() -> "No states found for " + input) : DataResult.success(states);
    }

    private static Predicate<class_2680> predicate(class_2689<class_2248, class_2680> state, String stateString) {
        HashMap map = Maps.newHashMap();
        for (String s : COMMA_SPLITTER.split((CharSequence)stateString)) {
            Iterator iterator = EQUAL_SPLITTER.split((CharSequence)s).iterator();
            if (!iterator.hasNext()) continue;
            String key = (String)iterator.next();
            class_2769 property = state.method_11663(key);
            if (property != null && iterator.hasNext()) {
                String value = (String)iterator.next();
                Comparable comparable = property.method_11900(value).orElse(null);
                if (comparable == null) {
                    throw new RuntimeException("Unknown value: '" + value + "' for blockstate property: '" + key + "' " + String.valueOf(property.method_11898()));
                }
                map.put(property, comparable);
                continue;
            }
            if (key.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + key + "'");
        }
        return stateIn -> {
            if (stateIn != null && stateIn.method_27852((class_2248)state.method_11660())) {
                for (Map.Entry entry : map.entrySet()) {
                    if (Objects.equals(stateIn.method_11654((class_2769)entry.getKey()), entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }
}

