/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.jmb19905.niftycarts.advancement.NCCriteriaTriggers;
import net.jmb19905.niftycarts.entity.AbstractDrawnEntity;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_2050;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import org.jetbrains.annotations.NotNull;

public class PullCartCriterion
extends class_4558<TriggerInstance> {
    public void trigger(class_3222 serverPlayer, AbstractDrawnEntity entity, float dist, float fillLevel) {
        super.method_22510(serverPlayer, t -> t.matches(entity, dist, fillLevel));
    }

    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_2050> type;
        private final Optional<Float> minDist;
        private final Optional<Integer> minPassengerCount;
        private final Optional<Float> fillLevel;
        private static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2050.field_45749.optionalFieldOf("type").forGetter(TriggerInstance::type), (App)Codec.FLOAT.optionalFieldOf("distance").forGetter(TriggerInstance::minDist), (App)Codec.INT.optionalFieldOf("passengers").forGetter(TriggerInstance::minPassengerCount), (App)Codec.FLOAT.optionalFieldOf("fill").forGetter(TriggerInstance::fillLevel)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_2050> type, Optional<Float> minDist, Optional<Integer> minPassengerCount, Optional<Float> fillLevel) {
            this.player = player;
            this.type = type;
            this.minDist = minDist;
            this.minPassengerCount = minPassengerCount;
            this.fillLevel = fillLevel;
        }

        public static class_175<TriggerInstance> pullCart(class_2050 type) {
            return NCCriteriaTriggers.PULL_CART.method_53699((class_184)new TriggerInstance(Optional.empty(), Optional.of(type), Optional.empty(), Optional.empty(), Optional.empty()));
        }

        public static class_175<TriggerInstance> pullCartFill(class_2050 type, float fillLevel) {
            return NCCriteriaTriggers.PULL_CART.method_53699((class_184)new TriggerInstance(Optional.empty(), Optional.of(type), Optional.empty(), Optional.empty(), Optional.of(Float.valueOf(fillLevel))));
        }

        public static class_175<TriggerInstance> pullCartDist(class_2050 type, float minDist) {
            return NCCriteriaTriggers.PULL_CART.method_53699((class_184)new TriggerInstance(Optional.empty(), Optional.of(type), Optional.of(Float.valueOf(minDist)), Optional.empty(), Optional.empty()));
        }

        public static class_175<TriggerInstance> pullCart(class_2050 type, float minDist, int minPassengerCount) {
            return NCCriteriaTriggers.PULL_CART.method_53699((class_184)new TriggerInstance(Optional.empty(), Optional.of(type), Optional.of(Float.valueOf(minDist)), Optional.of(minPassengerCount), Optional.empty()));
        }

        public boolean matches(AbstractDrawnEntity entity, float distance, float fillLevel) {
            return !(!this.type.isEmpty() && !this.type.get().method_8925(entity.method_5864()) || !this.minDist.isEmpty() && !(distance >= this.minDist.get().floatValue()) || !this.minPassengerCount.isEmpty() && entity.method_5685().size() < this.minPassengerCount.get() || !this.fillLevel.isEmpty() && !(fillLevel >= this.fillLevel.get().floatValue()));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;type;minDist;minPassengerCount;fillLevel", "player", "type", "minDist", "minPassengerCount", "fillLevel"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;type;minDist;minPassengerCount;fillLevel", "player", "type", "minDist", "minPassengerCount", "fillLevel"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;type;minDist;minPassengerCount;fillLevel", "player", "type", "minDist", "minPassengerCount", "fillLevel"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_2050> type() {
            return this.type;
        }

        public Optional<Float> minDist() {
            return this.minDist;
        }

        public Optional<Integer> minPassengerCount() {
            return this.minPassengerCount;
        }

        public Optional<Float> fillLevel() {
            return this.fillLevel;
        }
    }
}

