/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.client.datagen.lang;

import com.google.common.collect.ImmutableMap;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.jmb19905.niftycarts.NiftyCarts;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_4719;
import net.minecraft.class_7225;

@Environment(value=EnvType.CLIENT)
public class NiftyCartsDeDeLanguageProvider
extends FabricLanguageProvider {
    private static final Map<class_4719, String> NAMES = ImmutableMap.builderWithExpectedSize((int)11).put((Object)class_4719.field_21679, (Object)"Akazienholz").put((Object)class_4719.field_21681, (Object)"Schwarzeichenholz").put((Object)class_4719.field_40350, (Object)"Bambus").put((Object)class_4719.field_42837, (Object)"Kirschholz").put((Object)class_4719.field_21676, (Object)"Eichenholz").put((Object)class_4719.field_21677, (Object)"Fichtenholz").put((Object)class_4719.field_21678, (Object)"Birkenholz").put((Object)class_4719.field_21680, (Object)"Tropenholz").put((Object)class_4719.field_37657, (Object)"Mangrovenholz").put((Object)class_4719.field_22183, (Object)"Karmesin").put((Object)class_4719.field_22184, (Object)"Wirr").put((Object)class_4719.field_54795, (Object)"Blasseichen").build();
    private static final Map<class_1299<?>, String> ENTITY_NAMES = ImmutableMap.of(NiftyCarts.SUPPLY_CART_ENTITY, (Object)"Transportkarren", NiftyCarts.ANIMAL_CART_ENTITY, (Object)"Tierkarren", NiftyCarts.HAND_CART_ENTITY, (Object)"Handkarren", NiftyCarts.PLOW_ENTITY, (Object)"Pflug", NiftyCarts.SEED_DRILL_ENTITY, (Object)"S\u00e4maschine", NiftyCarts.REAPER_ENTITY, (Object)"M\u00e4hmaschine", NiftyCarts.WAGON_ENTITY, (Object)"Wagen");

    public NiftyCartsDeDeLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, "de_de", registryLookup);
    }

    public void generateTranslations(class_7225.class_7874 provider, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        translationBuilder.add(NiftyCarts.WHEEL, "Rad");
        class_4719.method_24026().forEach(woodType -> {
            String woodTypeName = NAMES.get(woodType);
            translationBuilder.add((class_1792)NiftyCarts.SUPPLY_CART.get(woodType), woodTypeName + "transportkarren");
            translationBuilder.add((class_1792)NiftyCarts.ANIMAL_CART.get(woodType), woodTypeName + "tierkarren");
            translationBuilder.add((class_1792)NiftyCarts.HAND_CART.get(woodType), woodTypeName + "handkarren");
            translationBuilder.add((class_1792)NiftyCarts.PLOW.get(woodType), woodTypeName + "pflug");
            translationBuilder.add((class_1792)NiftyCarts.SEED_DRILL.get(woodType), woodTypeName + "s\u00e4maschine");
            translationBuilder.add((class_1792)NiftyCarts.REAPER.get(woodType), woodTypeName + "m\u00e4hmaschine");
            translationBuilder.add((class_1792)NiftyCarts.WAGON.get(woodType), woodTypeName + "wagen");
        });
        for (class_1299<?> type : ENTITY_NAMES.keySet()) {
            translationBuilder.add(type, ENTITY_NAMES.get(type));
            translationBuilder.add("stat." + NiftyCarts.CART_PULL_CM.get(type).method_42094(), "Strecke " + ENTITY_NAMES.get(type) + " gezogen");
        }
        translationBuilder.add("stat." + NiftyCarts.RIDE_CART_CM.method_42094(), "Strecke auf Karren gefahren");
        translationBuilder.add("stat." + NiftyCarts.STEER_ANIMAL_CART_CM.method_42094(), "Strecke Tierkarren gesteuert");
        translationBuilder.add("stat." + NiftyCarts.STEER_REAPER_CM.method_42094(), "Strecke M\u00e4hmaschine gesteuert");
        try {
            Path path = (Path)this.dataOutput.getModContainer().findPath("assets/niftycarts/lang/en_us.existing.json").orElseThrow();
            translationBuilder.add(path);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find existing lang file", e);
        }
    }
}

