/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.client.datagen.lang;

import com.google.common.collect.ImmutableMap;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.jmb19905.niftycarts.NiftyCarts;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_4719;
import net.minecraft.class_7225;

@Environment(value=EnvType.CLIENT)
public class NiftyCartsEnUsLanguageProvider
extends FabricLanguageProvider {
    private static final Map<class_1299<?>, String> ENTITY_NAMES = ImmutableMap.of(NiftyCarts.SUPPLY_CART_ENTITY, (Object)"Supply Cart", NiftyCarts.ANIMAL_CART_ENTITY, (Object)"Animal Cart", NiftyCarts.HAND_CART_ENTITY, (Object)"Hand Cart", NiftyCarts.PLOW_ENTITY, (Object)"Plow", NiftyCarts.SEED_DRILL_ENTITY, (Object)"Seed Drill", NiftyCarts.REAPER_ENTITY, (Object)"Reaper", NiftyCarts.WAGON_ENTITY, (Object)"Wagon");

    public NiftyCartsEnUsLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, "en_us", registryLookup);
    }

    public void generateTranslations(class_7225.class_7874 provider, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        translationBuilder.add(NiftyCarts.WHEEL, "Wheel");
        class_4719.method_24026().forEach(woodType -> {
            translationBuilder.add((class_1792)NiftyCarts.SUPPLY_CART.get(woodType), NiftyCartsEnUsLanguageProvider.capitalizeWordStart(woodType.comp_1299()) + "Supply Cart");
            translationBuilder.add((class_1792)NiftyCarts.ANIMAL_CART.get(woodType), NiftyCartsEnUsLanguageProvider.capitalizeWordStart(woodType.comp_1299()) + "Animal Cart");
            translationBuilder.add((class_1792)NiftyCarts.HAND_CART.get(woodType), NiftyCartsEnUsLanguageProvider.capitalizeWordStart(woodType.comp_1299()) + "Hand Cart");
            translationBuilder.add((class_1792)NiftyCarts.PLOW.get(woodType), NiftyCartsEnUsLanguageProvider.capitalizeWordStart(woodType.comp_1299()) + "Plow");
            translationBuilder.add((class_1792)NiftyCarts.SEED_DRILL.get(woodType), NiftyCartsEnUsLanguageProvider.capitalizeWordStart(woodType.comp_1299()) + "Seed Drill");
            translationBuilder.add((class_1792)NiftyCarts.REAPER.get(woodType), NiftyCartsEnUsLanguageProvider.capitalizeWordStart(woodType.comp_1299()) + "Reaper");
            translationBuilder.add((class_1792)NiftyCarts.WAGON.get(woodType), NiftyCartsEnUsLanguageProvider.capitalizeWordStart(woodType.comp_1299()) + "Wagon");
        });
        translationBuilder.add("stat." + NiftyCarts.RIDE_CART_CM.method_42094(), "Distance by Cart");
        translationBuilder.add("stat." + NiftyCarts.STEER_ANIMAL_CART_CM.method_42094(), "Distance steering Animal Cart");
        translationBuilder.add("stat." + NiftyCarts.STEER_REAPER_CM.method_42094(), "Distance steering Reaper");
        for (class_1299<?> type : ENTITY_NAMES.keySet()) {
            translationBuilder.add("stat." + NiftyCarts.CART_PULL_CM.get(type).method_42094(), "Distance pulling " + ENTITY_NAMES.get(type));
            translationBuilder.add(type, ENTITY_NAMES.get(type));
        }
        try {
            Path path = (Path)this.dataOutput.getModContainer().findPath("assets/niftycarts/lang/en_us.existing.json").orElseThrow();
            translationBuilder.add(path);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find existing lang file", e);
        }
    }

    private static String capitalizeWordStart(String s) {
        StringBuilder builder = new StringBuilder();
        for (String sub : s.split("_")) {
            builder.append(sub.substring(0, 1).toUpperCase());
            builder.append(sub.substring(1));
            builder.append(" ");
        }
        return builder.toString();
    }
}

