/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.entity;

import java.util.function.Consumer;
import net.minecraft.class_10584;
import net.minecraft.class_1297;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CartInterpolationHandler
extends class_10584 {
    private final class_1297 entity;
    private int interpolationSteps;
    private final CartInterpolationData interpolationData = new CartInterpolationData(0, class_243.field_1353, 0.0f, 0.0f, class_243.field_1353);
    @Nullable
    private class_243 previousTickPosition;
    @Nullable
    private class_241 previousTickRot;
    @Nullable
    private class_243 previousTickVelocity;
    @Nullable
    private final Consumer<class_10584> onInterpolationStart;

    public CartInterpolationHandler(class_1297 entity) {
        this(entity, 3);
    }

    public CartInterpolationHandler(class_1297 entity, int interpolationSteps) {
        this(entity, interpolationSteps, null);
    }

    public CartInterpolationHandler(class_1297 entity, @Nullable Consumer<class_10584> onInterpolationStart) {
        this(entity, 3, onInterpolationStart);
    }

    public CartInterpolationHandler(class_1297 entity, int interpolationSteps, @Nullable Consumer<class_10584> onInterpolationStart) {
        super(entity, interpolationSteps, onInterpolationStart);
        this.interpolationSteps = interpolationSteps;
        this.entity = entity;
        this.onInterpolationStart = onInterpolationStart;
    }

    @NotNull
    public class_243 method_66265() {
        return this.interpolationData.steps > 0 ? this.interpolationData.position : this.entity.method_19538();
    }

    public float method_66268() {
        return this.interpolationData.steps > 0 ? this.interpolationData.yRot : this.entity.method_36454();
    }

    public float method_66269() {
        return this.interpolationData.steps > 0 ? this.interpolationData.xRot : this.entity.method_36455();
    }

    public class_243 velocity() {
        return this.interpolationData.steps > 0 ? this.interpolationData.deltaMovement : this.entity.method_18798();
    }

    public void interpolateTo(class_243 pos, float yRot, float xRot, class_243 velocity) {
        if (this.interpolationSteps == 0) {
            this.entity.method_60949(pos, yRot, xRot);
            this.entity.method_18799(velocity);
            this.method_66272();
        } else {
            this.interpolationData.steps = this.interpolationSteps;
            this.interpolationData.position = pos;
            this.interpolationData.yRot = yRot;
            this.interpolationData.xRot = xRot;
            this.interpolationData.deltaMovement = velocity;
            this.previousTickPosition = this.entity.method_19538();
            this.previousTickRot = new class_241(this.entity.method_36455(), this.entity.method_36454());
            this.previousTickVelocity = this.entity.method_18798();
            if (this.onInterpolationStart != null) {
                this.onInterpolationStart.accept(this);
            }
        }
    }

    public void method_66267(class_243 pos, float yRot, float xRot) {
        this.interpolateTo(pos, yRot, xRot, class_243.field_1353);
    }

    public boolean method_66270() {
        return this.interpolationData.steps > 0;
    }

    public void method_66266(int interpolationLength) {
        this.interpolationSteps = interpolationLength;
    }

    public void method_66271() {
        if (!this.method_66270()) {
            this.method_66272();
        } else {
            class_243 vec3;
            double delta = 1.0 / (double)this.interpolationData.steps;
            if (this.previousTickPosition != null) {
                vec3 = this.entity.method_19538().method_1020(this.previousTickPosition);
                if (this.entity.method_37908().method_8587(this.entity, this.entity.method_33332().method_997(this.interpolationData.position.method_1019(vec3)))) {
                    this.interpolationData.addPositionDelta(vec3);
                }
            }
            if (this.previousTickRot != null) {
                float f = this.entity.method_36454() - this.previousTickRot.field_1342;
                float g = this.entity.method_36455() - this.previousTickRot.field_1343;
                this.interpolationData.addRotation(f, g);
            }
            if (this.previousTickVelocity != null) {
                vec3 = this.entity.method_18798().method_1020(this.previousTickVelocity);
                this.interpolationData.addVelocityDelta(vec3);
            }
            double x = class_3532.method_16436((double)delta, (double)this.entity.method_23317(), (double)this.interpolationData.position.field_1352);
            double y = class_3532.method_16436((double)delta, (double)this.entity.method_23318(), (double)this.interpolationData.position.field_1351);
            double z = class_3532.method_16436((double)delta, (double)this.entity.method_23321(), (double)this.interpolationData.position.field_1350);
            class_243 interpolatedPos = new class_243(x, y, z);
            float yRot = (float)class_3532.method_52468((double)delta, (double)this.entity.method_36454(), (double)this.interpolationData.yRot);
            float xRot = (float)class_3532.method_16436((double)delta, (double)this.entity.method_36455(), (double)this.interpolationData.xRot);
            double dx = class_3532.method_16436((double)delta, (double)this.entity.method_18798().field_1352, (double)this.interpolationData.deltaMovement.field_1352);
            double dy = class_3532.method_16436((double)delta, (double)this.entity.method_18798().field_1352, (double)this.interpolationData.deltaMovement.field_1352);
            double dz = class_3532.method_16436((double)delta, (double)this.entity.method_18798().field_1352, (double)this.interpolationData.deltaMovement.field_1352);
            class_243 interpolatedVelocity = new class_243(dx, dy, dz);
            this.entity.method_33574(interpolatedPos);
            this.entity.method_5710(yRot, xRot);
            this.entity.method_18799(interpolatedVelocity);
            this.interpolationData.decrease();
            this.previousTickPosition = interpolatedPos;
            this.previousTickRot = new class_241(this.entity.method_36455(), this.entity.method_36454());
            this.previousTickVelocity = interpolatedVelocity;
        }
    }

    public void method_66272() {
        this.interpolationData.steps = 0;
        this.previousTickPosition = null;
        this.previousTickRot = null;
    }

    static class CartInterpolationData {
        protected int steps;
        class_243 position;
        float yRot;
        float xRot;
        class_243 deltaMovement;

        CartInterpolationData(int steps, class_243 position, float yRot, float xRot, class_243 deltaMovement) {
            this.steps = steps;
            this.position = position;
            this.yRot = yRot;
            this.xRot = xRot;
            this.deltaMovement = deltaMovement;
        }

        public void decrease() {
            --this.steps;
        }

        public void addPositionDelta(class_243 delta) {
            this.position = this.position.method_1019(delta);
        }

        public void addVelocityDelta(class_243 accel) {
            this.deltaMovement = this.deltaMovement.method_1019(accel);
        }

        public void addRotation(float yRot, float xRot) {
            this.yRot += yRot;
            this.xRot += xRot;
        }
    }
}

