/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.entity;

import java.util.List;
import net.jmb19905.niftycarts.NiftyCarts;
import net.jmb19905.niftycarts.NiftyCartsConfig;
import net.jmb19905.niftycarts.entity.AbstractDrawnInventoryEntity;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_4048;
import net.minecraft.class_5815;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WagonEntity
extends AbstractDrawnInventoryEntity {
    private static final class_2940<Integer> UNFURL = class_2945.method_12791(WagonEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> ROOF_COLOR = class_2945.method_12791(WagonEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_1799> EQUIPPED_CARPET = class_2945.method_12791(WagonEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Integer> CHEST_COUNT = class_2945.method_12791(WagonEntity.class, (class_2941)class_2943.field_13327);

    public WagonEntity(class_1299<? extends class_1297> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn, 108);
    }

    @Override
    public void onDestroyedAndDoDrops(class_1282 source) {
        class_3218 serverLevel;
        super.onDestroyedAndDoDrops(source);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218 && (serverLevel = (class_3218)class_19372).method_64395().method_8355(class_1928.field_19393)) {
            this.method_5775(serverLevel, new class_1799((class_1935)class_1802.field_8106, this.getChestCount()));
            this.method_5775(serverLevel, (class_1799)this.field_6011.method_12789(EQUIPPED_CARPET));
        }
    }

    public int getChestCount() {
        return (Integer)this.field_6011.method_12789(CHEST_COUNT);
    }

    public int getMaxChestCount() {
        return 3;
    }

    public int getCurrentRowCount() {
        return this.getChestCount() * 4;
    }

    @Override
    protected double getSpacing() {
        return 2.5;
    }

    @Override
    public boolean shouldPitch() {
        return false;
    }

    public int getUnfurled() {
        return (Integer)this.field_6011.method_12789(UNFURL);
    }

    public boolean hasRoof() {
        return (Integer)this.field_6011.method_12789(ROOF_COLOR) != -1;
    }

    @Nullable
    public class_1767 getRoofColor() {
        if (!this.hasRoof()) {
            return null;
        }
        return class_1767.method_7791((int)((Integer)this.field_6011.method_12789(ROOF_COLOR)));
    }

    public class_2960 getRoofTexture() {
        class_1767 color = this.getRoofColor();
        String name = "white";
        if (color != null) {
            name = color.method_7792();
        }
        return class_2960.method_60655((String)"niftycarts", (String)("textures/entity/wagon_roof_" + name + ".png"));
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(UNFURL, (Object)0);
        builder.method_56912(ROOF_COLOR, (Object)-1);
        builder.method_56912(CHEST_COUNT, (Object)0);
        builder.method_56912(EQUIPPED_CARPET, (Object)class_1799.field_8037);
    }

    @Override
    public class_1792 getCartItem() {
        return NiftyCarts.WAGON.get(this.getWoodType());
    }

    @Override
    public float getDisconnectedAngle() {
        return 20.0f;
    }

    @Override
    @NotNull
    public class_1269 method_5664(class_1657 player, class_243 vec3, class_1268 interactionHand) {
        if (this.isLocked()) {
            return class_1269.field_5814;
        }
        class_1799 itemStack = player.method_5998(interactionHand);
        class_1269 bannerResult = this.useBanner(player, interactionHand);
        if (bannerResult.method_23665()) {
            return bannerResult;
        }
        if (vec3.field_1351 > 2.2 && !player.method_21823()) {
            return this.interactCarpet(itemStack, player);
        }
        if (itemStack.method_31574(class_1802.field_8106) && this.canAddChest()) {
            return this.interactChest(itemStack, player);
        }
        if (player.method_21823() && !this.method_5685().isEmpty() && !this.method_37908().field_9236) {
            for (class_1297 entity : this.method_5685()) {
                if (entity instanceof class_1657) continue;
                entity.method_5848();
            }
            return class_1269.field_52422;
        }
        return super.method_5688(player, interactionHand);
    }

    private class_1269 interactCarpet(class_1799 itemStack, class_1657 player) {
        if (itemStack.method_31573(class_3489.field_15542)) {
            class_1792 class_17922 = itemStack.method_7909();
            if (!(class_17922 instanceof class_1747)) {
                return class_1269.field_5811;
            }
            class_1747 item = (class_1747)class_17922;
            class_2248 class_22482 = item.method_7711();
            if (!(class_22482 instanceof class_5815)) {
                return class_1269.field_5811;
            }
            class_5815 block = (class_5815)class_22482;
            if (itemStack.method_7947() >= 5 || player.method_56992()) {
                this.field_6011.method_12778(ROOF_COLOR, (Object)block.method_33635().method_7789());
                this.method_43077(class_3417.field_15226);
                if (!player.method_56992()) {
                    itemStack.method_7934(5);
                    if (!player.method_31548().method_7394((class_1799)this.field_6011.method_12789(EQUIPPED_CARPET))) {
                        player.method_7328((class_1799)this.field_6011.method_12789(EQUIPPED_CARPET), false);
                    }
                }
                this.field_6011.method_12778(EQUIPPED_CARPET, (Object)new class_1799((class_1935)item, 5));
            }
        } else if (this.hasRoof()) {
            this.field_6011.method_12778(UNFURL, (Object)((this.getUnfurled() + 1) % 3));
            this.method_43077(class_3417.field_15181);
        }
        return class_1269.field_21466;
    }

    private class_1269 interactChest(class_1799 itemStack, class_1657 player) {
        this.field_6011.method_12778(CHEST_COUNT, (Object)(this.getChestCount() + 1));
        if (!player.method_56992()) {
            itemStack.method_7934(1);
        }
        return class_1269.field_21466;
    }

    private boolean canAddChest() {
        int chests = this.getChestCount();
        int passengers = this.method_5685().size();
        return switch (chests) {
            case 0 -> true;
            case 1 -> {
                if (passengers <= 2) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (passengers == 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public void handleRotation(class_243 target) {
        this.method_36456(WagonEntity.getYaw(target));
    }

    @Override
    public NiftyCartsConfig.CartConfig getConfig() {
        return NiftyCartsConfig.get().wagon;
    }

    @Override
    protected class_1269 onInteractNotOpen(class_1657 player, class_1268 hand) {
        if (this.getPulling() != player) {
            if (!this.method_5818((class_1297)player)) {
                return class_1269.field_5811;
            }
            if (!this.method_37908().field_9236) {
                return player.method_5804((class_1297)this) ? class_1269.field_21466 : class_1269.field_5811;
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected boolean method_5818(class_1297 entity) {
        return switch (this.getChestCount()) {
            case 0, 1 -> {
                if (this.method_5685().size() < 4) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (this.method_5685().size() < 2) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public float getPassengersRidingOffsetY(class_4048 entityDimensions, float f) {
        return (entityDimensions.comp_2186() - 2.0f - 0.0625f) * f;
    }

    @NotNull
    protected class_243 method_52533(class_1297 entity, class_4048 entityDimensions, float factor) {
        int idx = this.method_5685().indexOf(entity);
        double f = idx == 0 || idx == 2 ? 0.1 : -1.2;
        double s = idx == 0 || idx == 1 ? 0.7 : -0.7;
        double d = f = this.getChestCount() == 2 ? -1.2 : f;
        s = this.getChestCount() == 2 ? (idx == 0 ? -0.7 : 0.7) : s;
        class_243 forward = this.method_5720().method_1021(f);
        class_243 sideways = new class_243(forward.field_1350, 0.0, -forward.field_1352).method_1029().method_1021(s);
        return new class_243(forward.field_1352 + sideways.field_1352, (double)this.getPassengersRidingOffsetY(entityDimensions, factor) + forward.field_1351, forward.field_1350 + sideways.field_1350);
    }

    public void method_5865(class_1297 passenger, class_1297.class_4738 moveFunction) {
        int dir;
        super.method_5865(passenger, moveFunction);
        int idx = this.method_5685().indexOf(passenger);
        int n = dir = idx == 0 || idx == 3 ? 1 : -1;
        if (this.method_5626(passenger)) {
            passenger.method_5636(this.method_36454() + (float)((passenger instanceof class_1321 ? 180 : 90) * dir));
            float f2 = class_3532.method_15393((float)(passenger.method_36454() - this.method_36454() - (float)((passenger instanceof class_1321 ? 180 : 90) * dir)));
            float clamped = class_3532.method_15363((float)f2, (float)-105.0f, (float)105.0f);
            passenger.field_5982 += clamped - f2;
            passenger.method_36456(passenger.method_36454() + (clamped - f2));
            passenger.method_5847(passenger.method_36454());
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.isLocked()) {
            return;
        }
        List list = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1009((double)0.2f, (double)-0.01f, (double)0.2f), class_1301.method_5911((class_1297)this));
        if (!list.isEmpty()) {
            boolean bl = !this.method_37908().field_9236 && !(this.method_5642() instanceof class_1657);
            for (class_1297 entity : list) {
                if (entity.method_5626((class_1297)this) || !bl || !this.method_5818(entity) || entity.method_5765() || !(entity.method_17681() < this.method_17681() / 2.0f) || !((double)(entity.method_17681() * entity.method_17682()) < 1.5) || !(entity instanceof class_1309) || entity instanceof class_1480 || entity instanceof class_1657) continue;
                if (entity instanceof class_1321) {
                    class_1321 tamable = (class_1321)entity;
                    tamable.method_6179(true);
                }
                entity.method_5804((class_1297)this);
            }
        }
    }

    @Override
    protected class_1703 createMenuLootUnpacked(int i, class_1661 inventory, class_1657 player) {
        class_3917<class_1707> type;
        switch (this.getChestCount()) {
            case 1: {
                class_3917<class_1707> class_39172 = NiftyCarts.CHEST_9x4_MENU_TYPE;
                break;
            }
            case 2: {
                class_3917<class_1707> class_39172 = NiftyCarts.CHEST_9x8_MENU_TYPE;
                break;
            }
            case 3: {
                class_3917<class_1707> class_39172 = NiftyCarts.CHEST_9x12_MENU_TYPE;
                break;
            }
            default: {
                class_3917<class_1707> class_39172 = type = null;
            }
        }
        if (type == null) {
            return null;
        }
        return new class_1707(type, i, inventory, (class_1263)this, this.getCurrentRowCount());
    }

    @Override
    protected void method_5652(class_11372 output) {
        super.method_5652(output);
        output.method_71465("Unfurl", ((Integer)this.field_6011.method_12789(UNFURL)).intValue());
        output.method_71465("RoofColor", ((Integer)this.field_6011.method_12789(ROOF_COLOR)).intValue());
        output.method_71465("ChestCount", ((Integer)this.field_6011.method_12789(CHEST_COUNT)).intValue());
        if (!((class_1799)this.field_6011.method_12789(EQUIPPED_CARPET)).method_7960()) {
            class_1799 itemStack = (class_1799)this.field_6011.method_12789(EQUIPPED_CARPET);
            output.method_71468("Carpet", class_1799.field_24671, (Object)itemStack);
        }
    }

    @Override
    protected void method_5749(class_11368 input) {
        super.method_5749(input);
        this.field_6011.method_12778(UNFURL, (Object)input.method_71439("Unfurl").orElse(0));
        this.field_6011.method_12778(ROOF_COLOR, (Object)input.method_71439("RoofColor").orElse(-1));
        this.field_6011.method_12778(CHEST_COUNT, (Object)input.method_71439("ChestCount").orElse(0));
        this.field_6011.method_12778(EQUIPPED_CARPET, (Object)input.method_71426("Carpet", class_1799.field_24671).orElse(class_1799.field_8037));
    }

    @Override
    protected void saveInventory(class_11372 output) {
        class_1262.method_5426((class_11372)output, this.method_42278());
    }

    @Override
    protected void readInventory(class_11368 input) {
        class_1262.method_5429((class_11368)input, this.method_42278());
    }
}

