/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_4135;

public final class NiftyGoalAdder<T extends class_1297> {
    private final Class<T> type;
    private final Function<T, class_1355> selector;
    private final ImmutableList<GoalEntry<T>> goals;

    private NiftyGoalAdder(Builder<T> builder) {
        this.type = builder.type;
        this.selector = builder.selector;
        this.goals = builder.goals.build();
    }

    public void onEntityJoinWorld(class_1297 entity) {
        if (!entity.method_37908().field_9236 && this.type.isInstance(entity)) {
            Set<class_4135> oldGoals = this.getGoals((class_1297)this.type.cast(entity));
            ArrayList<class_4135> newGoals = new ArrayList<class_4135>(oldGoals.size() + this.goals.size());
            for (GoalEntry goal : this.goals) {
                newGoals.add(new class_4135(goal.priority, goal.factory.apply((class_1297)this.type.cast(entity))));
            }
            newGoals.addAll(oldGoals);
            oldGoals.clear();
            oldGoals.addAll(newGoals);
        }
    }

    private Set<class_4135> getGoals(T entity) {
        return this.selector.apply(entity).method_35115();
    }

    public static <T extends class_1308> Builder<T> mobGoal(Class<T> type) {
        return NiftyGoalAdder.builder(type, m -> m.field_6201);
    }

    public static <T extends class_1308> Builder<T> mobTarget(Class<T> type) {
        return NiftyGoalAdder.builder(type, m -> m.field_6185);
    }

    public static <T extends class_1297> Builder<T> builder(Class<T> type, Function<T, class_1355> selector) {
        return new Builder<T>(type, selector);
    }

    public static final class Builder<T extends class_1297> {
        private final Class<T> type;
        private final Function<T, class_1355> selector;
        private final ImmutableList.Builder<GoalEntry<T>> goals = new ImmutableList.Builder();

        private Builder(Class<T> type, Function<T, class_1355> selector) {
            this.type = type;
            this.selector = selector;
        }

        public Builder<T> add(int priority, Function<T, class_1352> factory) {
            this.goals.add(new GoalEntry<T>(priority, factory));
            return this;
        }

        public NiftyGoalAdder<T> build() {
            return new NiftyGoalAdder(this);
        }
    }

    private record GoalEntry<T extends class_1297>(int priority, Function<T, class_1352> factory) {
    }
}

