/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import net.jmb19905.niftycarts.NiftyCarts;
import net.jmb19905.niftycarts.entity.AbstractDrawnEntity;
import net.minecraft.class_10741;
import net.minecraft.class_1297;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_26;
import net.minecraft.class_4284;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class NiftyWorld
extends class_18 {
    public static final Codec<NiftyWorld> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityWithId.CODEC.listOf().optionalFieldOf("drawnList", List.of()).forGetter(world -> world.pulling.int2ObjectEntrySet().stream().map(entry -> new EntityWithId(entry.getIntKey(), (UUID)entry.getValue())).toList())).apply((Applicative)instance, NiftyWorld::new));
    public static final class_10741<NiftyWorld> TYPE = new class_10741("niftycarts_world", NiftyWorld::new, CODEC, class_4284.field_19212);
    private static NiftyWorld clientInstance = null;
    private final Int2ObjectMap<UUID> pulling = new Int2ObjectOpenHashMap();

    public NiftyWorld() {
    }

    private NiftyWorld(List<EntityWithId> entityWithIds) {
        entityWithIds.forEach(entityWithId -> this.pulling.put(entityWithId.id, (Object)entityWithId.entityId));
    }

    public void addPulling(AbstractDrawnEntity drawn) {
        @Nullable class_1297 pulling = drawn.getPulling();
        if (pulling != null) {
            this.setPulling(pulling.method_5628(), drawn);
        }
    }

    public void setPulling(int pullId, AbstractDrawnEntity drawn) {
        this.pulling.put(pullId, (Object)drawn.method_5667());
        this.method_80();
    }

    public Optional<AbstractDrawnEntity> getDrawn(class_1297 e) {
        if (e == null) {
            return Optional.empty();
        }
        UUID drawnId = (UUID)this.pulling.get(e.method_5628());
        if (drawnId == null) {
            return Optional.empty();
        }
        class_1297 entity = e.method_37908().method_66347(drawnId);
        if (!(entity instanceof AbstractDrawnEntity)) {
            return Optional.empty();
        }
        AbstractDrawnEntity drawn = (AbstractDrawnEntity)entity;
        return Optional.of(drawn);
    }

    public boolean isPulling(class_1297 e) {
        return this.pulling.containsKey(e.method_5628());
    }

    public void tick(class_1937 level) {
        IntIterator it = this.pulling.keySet().iterator();
        while (it.hasNext()) {
            int pullId = (Integer)it.next();
            UUID cartId = (UUID)this.pulling.get(pullId);
            class_1297 e = level.method_66347(cartId);
            if (!(e instanceof AbstractDrawnEntity)) {
                it.remove();
                continue;
            }
            AbstractDrawnEntity cart = (AbstractDrawnEntity)e;
            if (cart.shouldStopPulledTick()) {
                it.remove();
                this.method_80();
                continue;
            }
            if (cart.getPulling() instanceof AbstractDrawnEntity) continue;
            cart.pulledTick();
        }
    }

    public Optional<class_1297> getCurrentlyPulling(AbstractDrawnEntity drawn) {
        OptionalInt id = this.pulling.keySet().intStream().filter(pullID -> this.pulling.get(pullID) == drawn.method_5667()).findFirst();
        if (id.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(drawn.method_37908().method_8469(id.getAsInt()));
    }

    public Int2ObjectMap<UUID> getPulling() {
        return this.pulling;
    }

    public static NiftyWorld get(class_1937 level) {
        if (level.method_8608()) {
            return NiftyWorld.getClient();
        }
        return NiftyWorld.getServer(NiftyCarts.server, (class_5321<class_1937>)level.method_27983());
    }

    public static NiftyWorld getClient() {
        if (clientInstance == null) {
            clientInstance = new NiftyWorld();
        }
        return clientInstance;
    }

    public static NiftyWorld getServer(MinecraftServer server, class_5321<class_1937> levelType) {
        class_26 dataStorage = Objects.requireNonNull(server.method_3847(levelType)).method_17983();
        return (NiftyWorld)dataStorage.method_17924(TYPE);
    }

    record EntityWithId(int id, UUID entityId) {
        public static final Codec<EntityWithId> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(EntityWithId::id), (App)class_4844.field_25122.fieldOf("UUID").forGetter(EntityWithId::entityId)).apply((Applicative)instance, EntityWithId::new));

        public static EntityWithId from(Int2ObjectMap.Entry<AbstractDrawnEntity> entry) {
            return new EntityWithId(entry.getIntKey(), ((AbstractDrawnEntity)((Object)entry.getValue())).method_5667());
        }
    }
}

