/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.blocks.keg;

import com.mojang.serialization.MapCodec;
import me.itzme1on.alcocraftplus.core.blocks.keg.KegEntity;
import me.itzme1on.alcocraftplus.core.registries.BlockEntitiesRegistry;
import me.itzme1on.alcocraftplus.core.registries.ItemsRegistry;
import me.itzme1on.alcocraftplus.core.utils.BeerTypeMapperUtil;
import me.itzme1on.alcocraftplus.core.utils.SidedResultsUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Keg
extends class_2237 {
    public static final MapCodec<Keg> CODEC = Keg.method_54094(Keg::new);
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    private static final class_265 KEG_SHAPE;
    private static final class_265 SHAPE_NORTH;
    private static final class_265 SHAPE_EAST;
    private static final class_265 SHAPE_SOUTH;
    private static final class_265 SHAPE_WEST;

    public Keg(class_4970.class_2251 properties) {
        super(properties);
    }

    private static class_265 rotateShape(class_2350 to) {
        class_265[] buffer = new class_265[]{SHAPE_NORTH, class_259.method_1073()};
        int times = (to.method_10161() - class_2350.field_11043.method_10161() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = class_259.method_1084((class_265)buffer[1], (class_265)class_259.method_1081((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = class_259.method_1073();
        }
        return buffer[0];
    }

    @NotNull
    public MapCodec<Keg> method_53969() {
        return CODEC;
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return switch ((class_2350)state.method_11654(FACING)) {
            case class_2350.field_11034 -> SHAPE_EAST;
            case class_2350.field_11035 -> SHAPE_SOUTH;
            case class_2350.field_11039 -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657(FACING, (Comparable)context.method_8042().method_10153());
    }

    @NotNull
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    @NotNull
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        class_2470 rotation = mirror.method_10345((class_2350)state.method_11654(FACING));
        return (class_2680)this.method_9564().method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new KegEntity(pos, state);
    }

    @NotNull
    public class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (level.method_8608()) {
            return SidedResultsUtil.success();
        }
        class_2586 entity = level.method_8321(pos);
        if (!(entity instanceof KegEntity)) {
            return SidedResultsUtil.pass();
        }
        KegEntity keg = (KegEntity)entity;
        if (this.canPourBeer(stack, keg)) {
            this.handlePouringBeer(player, hand, keg);
            return SidedResultsUtil.itemSidedSuccess(level);
        }
        if (this.canAddWater(stack, keg)) {
            this.handleAddingWater(level, pos, player, hand, keg);
            return SidedResultsUtil.itemSidedSuccess(level);
        }
        return this.openKegScreen(state, level, pos, player);
    }

    @NotNull
    public class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hit) {
        if (level.method_8608()) {
            return SidedResultsUtil.blockSidedSuccess(level);
        }
        return this.openKegScreen(state, level, pos, player);
    }

    @NotNull
    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 blockEntity;
        if (!level.method_8608() && (blockEntity = level.method_8321(pos)) instanceof KegEntity) {
            KegEntity kegEntity = (KegEntity)blockEntity;
            kegEntity.getItems().forEach(stack -> {
                if (!stack.method_7960()) {
                    Keg.method_9577((class_1937)level, (class_2338)pos, (class_1799)stack.method_7972());
                }
            });
            level.method_8455(pos, (class_2248)this);
        }
        return super.method_9576(level, pos, state, player);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return Keg.method_31618(blockEntityType, (class_2591)((class_2591)BlockEntitiesRegistry.KEG_ENTITY.get()), (world, pos, st, entity) -> {
            if (entity != null) {
                entity.tick(world, pos, st, (KegEntity)entity);
            }
        });
    }

    private boolean canPourBeer(class_1799 heldItem, KegEntity keg) {
        return heldItem.method_31574((class_1792)ItemsRegistry.MUG.get()) && keg.beerLevel >= 4;
    }

    private void handlePouringBeer(class_1657 player, class_1268 hand, KegEntity keg) {
        class_1799 beerStack;
        class_1799 heldItem = player.method_5998(hand);
        if (!player.method_68878()) {
            heldItem.method_7934(1);
        }
        if (!(beerStack = BeerTypeMapperUtil.getBeerStack(keg.beerType)).method_7960()) {
            class_1799 pouredBeer = beerStack.method_7972();
            player.method_7259(class_3468.field_15372.method_14956((Object)((class_1792)ItemsRegistry.MUG.get())));
            if (player.method_31548().method_7394(pouredBeer)) {
                player.method_37908().method_60511(null, player.method_23317(), player.method_23318(), player.method_23321(), (class_6880)class_3417.field_20613, class_3419.field_15248, 0.5f, 1.0f);
            } else {
                player.method_7328(pouredBeer, false);
            }
        }
        keg.beerLevel -= 4;
    }

    private boolean canAddWater(class_1799 heldItem, KegEntity keg) {
        return heldItem.method_31574(class_1802.field_8705) && keg.waterLevel <= 24 && keg.beerLevel == 0;
    }

    private void handleAddingWater(class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, KegEntity keg) {
        keg.waterLevel += 8;
        level.method_8396(null, pos, class_3417.field_14834, class_3419.field_15245, 1.0f, 1.0f);
        class_1799 heldItem = player.method_5998(hand);
        if (!player.method_68878()) {
            heldItem.method_7934(1);
            player.method_6122(hand, new class_1799((class_1935)class_1802.field_8550));
        }
        player.method_32875((class_6880)class_5712.field_28166, (class_1297)player);
    }

    private class_1269 openKegScreen(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        class_3908 screenHandlerFactory = state.method_26196(level, pos);
        if (screenHandlerFactory != null) {
            player.method_17355(screenHandlerFactory);
            level.method_8396(null, pos, class_3417.field_15219, class_3419.field_15245, 1.0f, 0.8f);
            level.method_8396(null, pos, class_3417.field_17604, class_3419.field_15245, 1.0f, 1.0f);
            return SidedResultsUtil.success();
        }
        return SidedResultsUtil.pass();
    }

    static {
        SHAPE_NORTH = KEG_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)7.0, (double)16.0, (double)7.0, (double)9.0, (double)17.0, (double)9.0), (class_265[])new class_265[]{class_2248.method_9541((double)3.0, (double)14.0, (double)1.0, (double)13.0, (double)15.0, (double)2.0), class_2248.method_9541((double)2.0, (double)4.0, (double)1.0, (double)14.0, (double)14.0, (double)2.0), class_2248.method_9541((double)3.0, (double)3.0, (double)1.0, (double)13.0, (double)4.0, (double)2.0), class_2248.method_9541((double)2.0, (double)4.0, (double)14.0, (double)14.0, (double)14.0, (double)15.0), class_2248.method_9541((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)4.0, (double)15.0), class_2248.method_9541((double)3.0, (double)14.0, (double)14.0, (double)13.0, (double)15.0, (double)15.0), class_2248.method_9541((double)14.0, (double)4.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0), class_2248.method_9541((double)3.0, (double)15.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0), class_2248.method_9541((double)13.0, (double)14.0, (double)0.0, (double)14.0, (double)15.0, (double)16.0), class_2248.method_9541((double)1.0, (double)4.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0), class_2248.method_9541((double)2.0, (double)14.0, (double)0.0, (double)3.0, (double)15.0, (double)16.0), class_2248.method_9541((double)2.0, (double)3.0, (double)0.0, (double)3.0, (double)4.0, (double)16.0), class_2248.method_9541((double)3.0, (double)2.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0), class_2248.method_9541((double)13.0, (double)3.0, (double)0.0, (double)14.0, (double)4.0, (double)16.0), class_2248.method_9541((double)7.0, (double)5.0, (double)0.0, (double)9.0, (double)7.0, (double)1.0), class_2248.method_9541((double)3.0, (double)0.0, (double)2.0, (double)5.0, (double)1.0, (double)4.0), class_2248.method_9541((double)11.0, (double)0.0, (double)2.0, (double)13.0, (double)1.0, (double)4.0), class_2248.method_9541((double)3.0, (double)1.0, (double)2.0, (double)13.0, (double)2.0, (double)4.0), class_2248.method_9541((double)3.0, (double)0.0, (double)12.0, (double)5.0, (double)1.0, (double)14.0), class_2248.method_9541((double)11.0, (double)0.0, (double)12.0, (double)13.0, (double)1.0, (double)14.0), class_2248.method_9541((double)3.0, (double)1.0, (double)12.0, (double)13.0, (double)2.0, (double)14.0)});
        SHAPE_EAST = Keg.rotateShape(class_2350.field_11034);
        SHAPE_SOUTH = Keg.rotateShape(class_2350.field_11035);
        SHAPE_WEST = Keg.rotateShape(class_2350.field_11039);
    }
}

