/*
 * Decompiled with CFR 0.152.
 */
package yelf42.cropcritters.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import yelf42.cropcritters.CropCritters;
import yelf42.cropcritters.config.CropCrittersConfig;

public class ConfigManager {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("crop-critters-config.toml");
    public static CropCrittersConfig CONFIG = CropCrittersConfig.getDefaults();

    public static void load() {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            CropCritters.LOGGER.info("Generating first time CropCritters config");
            ConfigManager.save();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || !line.contains("=")) continue;
                String[] parts = line.split("=", 2);
                String key = parts[0].trim();
                String value = parts[1].trim();
                switch (key) {
                    case "regularWeedsGrowChance": {
                        ConfigManager.CONFIG.regularWeedChance = Math.clamp((long)Integer.parseInt(value), 0, 100);
                        break;
                    }
                    case "netherWeedsGrowChance": {
                        ConfigManager.CONFIG.netherWeedChance = Math.clamp((long)Integer.parseInt(value), 0, 100);
                        break;
                    }
                    case "mazewoodSpread": {
                        ConfigManager.CONFIG.mazewoodSpread = Math.clamp((long)Integer.parseInt(value), 1, 16);
                        break;
                    }
                    case "lostSoulDropChance": {
                        ConfigManager.CONFIG.lostSoulDropChance = Math.clamp((long)Integer.parseInt(value), 0, 100);
                        break;
                    }
                    case "monoculturePenalize": {
                        ConfigManager.CONFIG.monoculturePenalize = Boolean.parseBoolean(value);
                        break;
                    }
                    case "critterSpawnChance": {
                        ConfigManager.CONFIG.critterSpawnChance = Math.clamp((long)Integer.parseInt(value), 0, 100);
                        break;
                    }
                    case "critterWorkSpeedMultiplier": {
                        ConfigManager.CONFIG.critterWorkSpeedMultiplier = Math.clamp(Float.parseFloat(value), 0.0f, 10.0f);
                        break;
                    }
                    case "deadCoralGeneration": {
                        ConfigManager.CONFIG.deadCoralGeneration = Boolean.parseBoolean(value);
                        break;
                    }
                    case "thornweedGeneration": {
                        ConfigManager.CONFIG.thornweedGeneration = Boolean.parseBoolean(value);
                        break;
                    }
                    case "waftgrassGeneration": {
                        ConfigManager.CONFIG.waftgrassGeneration = Boolean.parseBoolean(value);
                        break;
                    }
                    case "spiteweedGeneration": {
                        ConfigManager.CONFIG.spiteweedGeneration = Boolean.parseBoolean(value);
                    }
                }
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load config: " + e.getMessage());
        }
    }

    public static void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            writer.write("# CropCritters Configuration\n");
            writer.write("# Config changes only apply on restart\n");
            writer.write("# \n");
            writer.write("# Weed percentage grow chances:\n");
            writer.write("regularWeedsGrowChance = " + ConfigManager.CONFIG.regularWeedChance + "\n");
            writer.write("netherWeedsGrowChance = " + ConfigManager.CONFIG.netherWeedChance + "\n");
            writer.write("# Should monocultures have increased weed chances:\n");
            writer.write("monoculturePenalize = " + ConfigManager.CONFIG.monoculturePenalize + "\n");
            writer.write("# \n");
            writer.write("# How far should Mazewood spread (1-128):\n");
            writer.write("# (Be careful, spreads fast) \n");
            writer.write("mazewoodSpread = " + ConfigManager.CONFIG.mazewoodSpread + "\n");
            writer.write("# \n");
            writer.write("# Lost soul mob drop chance:\n");
            writer.write("lostSoulDropChance = " + ConfigManager.CONFIG.lostSoulDropChance + "\n");
            writer.write("# \n");
            writer.write("# Crop critter spawn chance on crop just matured\n");
            writer.write("# or on randomTick in SoulSandValley.\n");
            writer.write("# Chance doubled if on a 'Soul' block:\n");
            writer.write("critterSpawnChance = " + ConfigManager.CONFIG.critterSpawnChance + "\n");
            writer.write("# \n");
            writer.write("# Multiplier on critter work speed:\n");
            writer.write("# (Between 0.01 and 10.0)\n");
            writer.write("critterWorkSpeedMultiplier = " + ConfigManager.CONFIG.critterWorkSpeedMultiplier + "\n");
            writer.write("# \n");
            writer.write("# Biome generation toggles: \n");
            writer.write("deadCoralGeneration = " + ConfigManager.CONFIG.deadCoralGeneration + "\n");
            writer.write("thornweedGeneration = " + ConfigManager.CONFIG.thornweedGeneration + "\n");
            writer.write("waftgrassGeneration = " + ConfigManager.CONFIG.waftgrassGeneration + "\n");
            writer.write("spiteweedGeneration = " + ConfigManager.CONFIG.spiteweedGeneration + "\n");
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }
}

