/*
 * Decompiled with CFR 0.152.
 */
package yelf42.cropcritters.entity;

import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_10;
import net.minecraft.class_11;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2421;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import yelf42.cropcritters.config.RecognizedCropsState;
import yelf42.cropcritters.entity.AbstractCropCritterEntity;
import yelf42.cropcritters.items.ModItems;

public class CocoaCritterEntity
extends AbstractCropCritterEntity {
    private static final Predicate<class_1297> NOTICEABLE_PLAYER_FILTER = entity -> !entity.method_21751() && class_1301.field_6156.test(entity);
    private static final Predicate<class_1542> PICKABLE_DROP_FILTER = item -> !item.method_6977() && item.method_5805();
    public static final RawAnimation HOLD = RawAnimation.begin().thenPlayAndHold("holding");
    private static final Set<class_1792> DEFAULT_KNOWN_ITEMS = new HashSet<class_1792>();
    private static final int MAX_HOPPER_DISTANCE = 32;
    @Nullable
    class_2338 hopperPos;

    @Override
    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71477("hopper_pos", class_2338.field_25064, (Object)this.hopperPos);
    }

    @Override
    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        this.hopperPos = view.method_71426("hopper_pos", class_2338.field_25064).orElse(null);
    }

    public CocoaCritterEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5952(true);
    }

    @Override
    protected void method_5959() {
        AbstractCropCritterEntity.TemptGoal temptGoal = new AbstractCropCritterEntity.TemptGoal(this, 0.6, stack -> stack.method_31574(ModItems.LOST_SOUL), true);
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)temptGoal);
        this.field_6201.method_6277(6, (class_1352)new class_1338((class_1314)this, class_1657.class, 10.0f, 1.6, 1.4, entity -> NOTICEABLE_PLAYER_FILTER.test((class_1297)entity) && !this.isTrusting()));
        this.field_6201.method_6277(7, (class_1352)new DepositInHopperGoal());
        this.targetWorkGoal = new AbstractCropCritterEntity.TargetWorkGoal();
        this.field_6201.method_6277(8, (class_1352)this.targetWorkGoal);
        this.field_6201.method_6277(9, (class_1352)new PickupItemGoal());
        this.field_6201.method_6277(12, (class_1352)new class_1379((class_1314)this, 0.8));
        this.field_6201.method_6277(20, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(20, (class_1352)new class_1376((class_1308)this));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController(), new AnimationController("Hold", test -> this.method_6118(class_1304.field_6173).method_7960() ? PlayState.STOP : test.setAndContinue(HOLD))});
    }

    @Override
    protected Predicate<class_2680> getTargetBlockFilter() {
        return blockState -> {
            class_2302 cropBlock;
            class_2248 patt0$temp = blockState.method_26204();
            return patt0$temp instanceof class_2302 && (cropBlock = (class_2302)patt0$temp).method_9825(blockState) || blockState.method_26204() instanceof class_2421 && (Integer)blockState.method_61767((class_2769)class_2421.field_11306, (Comparable)Integer.valueOf(0)) >= 3;
        };
    }

    @Override
    protected int getTargetOffset() {
        return 0;
    }

    @Override
    protected boolean canWork() {
        return this.method_6118(class_1304.field_6173).method_7960();
    }

    @Override
    protected class_3545<class_1792, Integer> getLoot() {
        return new class_3545((Object)class_1802.field_8116, (Object)3);
    }

    @Override
    protected boolean isHealingItem(class_1799 itemStack) {
        return itemStack.method_31574(class_1802.field_8116);
    }

    @Override
    protected int resetTicksUntilCanWork() {
        return this.resetTicksUntilCanWork(class_3532.method_15395((class_5819)this.field_5974, (int)500, (int)600));
    }

    @Override
    public void completeTargetGoal() {
        if (!this.method_6118(class_1304.field_6173).method_7960() || this.targetPos == null || this.method_37908().method_8608()) {
            return;
        }
        class_3218 world = (class_3218)this.method_37908();
        class_2680 state = world.method_8320(this.targetPos);
        if (!this.getTargetBlockFilter().test(state)) {
            return;
        }
        class_8567.class_8568 builder = new class_8567.class_8568(world).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)this.targetPos)).method_51874(class_181.field_1229, (Object)class_1799.field_8037);
        List items = state.method_26189(builder);
        if (items.isEmpty()) {
            return;
        }
        class_1799 toDrop = (class_1799)items.get(world.field_9229.method_43048(items.size()));
        toDrop.method_7939(1);
        this.method_5673(class_1304.field_6173, toDrop);
        this.method_25939(class_1304.field_6173);
        this.recordCrop(toDrop.method_7909());
        world.method_8444((class_1297)this, 2001, this.targetPos, class_2248.method_9507((class_2680)state));
        world.method_8652(this.targetPos, class_2246.field_10124.method_9564(), 2);
    }

    private void recordCrop(class_1792 item) {
        if (this.method_37908().method_8608()) {
            return;
        }
        class_3218 world = (class_3218)this.method_37908();
        RecognizedCropsState state = RecognizedCropsState.getServerState(world.method_8503());
        state.addCrop(item);
    }

    private boolean checkCrop(class_1792 item) {
        if (this.method_37908().method_8608()) {
            return false;
        }
        if (DEFAULT_KNOWN_ITEMS.contains(item)) {
            return true;
        }
        class_3218 world = (class_3218)this.method_37908();
        RecognizedCropsState state = RecognizedCropsState.getServerState(world.method_8503());
        return state.hasCrop(item);
    }

    @Override
    protected void method_16080(class_3218 world, class_1282 damageSource) {
        class_1799 itemStack = this.method_6118(class_1304.field_6173);
        if (!itemStack.method_7960()) {
            this.method_5775(world, itemStack);
            this.method_5673(class_1304.field_6173, class_1799.field_8037);
        }
        super.method_16080(world, damageSource);
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1269 actionResult = super.method_5992(player, hand);
        if (!this.method_37908().method_8608() && !actionResult.method_23665() && this.isTrusting() && player.method_5998(hand).method_7960() && this.tryPutDown(this.method_6118(class_1304.field_6173), true)) {
            return class_1269.field_5812;
        }
        return actionResult;
    }

    private boolean tryPutDown(class_1799 stack, boolean withVelocity) {
        if (!stack.method_7960()) {
            class_1542 itemEntity = withVelocity ? new class_1542(this.method_37908(), this.method_23317() + this.method_5720().field_1352, this.method_23318() + (double)0.6f, this.method_23321() + this.method_5720().field_1350, stack) : new class_1542(this.method_37908(), this.method_23317(), this.method_23318() + (double)0.6f, this.method_23321(), stack, 0.0, 0.0, 0.0);
            itemEntity.method_6982(40);
            itemEntity.method_6981((class_1297)this);
            this.method_5783(class_3417.field_18054, 1.0f, 1.0f);
            this.method_37908().method_8649((class_1297)itemEntity);
            this.method_5673(class_1304.field_6173, class_1799.field_8037);
            return true;
        }
        return false;
    }

    public boolean method_5939(class_1799 stack) {
        class_1799 itemStack = this.method_6118(class_1304.field_6173);
        return itemStack.method_7960() && this.checkCrop(stack.method_7909());
    }

    private void dropItem(class_1799 stack) {
        class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), stack);
        this.method_37908().method_8649((class_1297)itemEntity);
    }

    protected void method_5949(class_3218 world, class_1542 itemEntity) {
        class_1799 itemStack = itemEntity.method_6983();
        if (this.method_5939(itemStack)) {
            int i = itemStack.method_7947();
            if (i > 1) {
                this.dropItem(itemStack.method_7971(i - 1));
            }
            this.method_29499(itemEntity);
            this.method_5673(class_1304.field_6173, itemStack.method_7971(1));
            this.method_25939(class_1304.field_6173);
            this.method_6103((class_1297)itemEntity, itemStack.method_7947());
            itemEntity.method_31472();
        }
    }

    protected boolean validHopperPos() {
        return this.hopperPos != null && this.method_37908().method_8320(this.hopperPos).method_27852(class_2246.field_10312) && this.hopperPos.method_19769((class_2374)this.method_19538(), 32.0);
    }

    static {
        DEFAULT_KNOWN_ITEMS.add(ModItems.STRANGE_FERTILIZER);
        DEFAULT_KNOWN_ITEMS.add(ModItems.LOST_SOUL);
        DEFAULT_KNOWN_ITEMS.add(class_1802.field_8116);
        DEFAULT_KNOWN_ITEMS.add(class_1802.field_8317);
        DEFAULT_KNOWN_ITEMS.add(class_1802.field_8861);
        DEFAULT_KNOWN_ITEMS.add(class_1802.field_8179);
        DEFAULT_KNOWN_ITEMS.add(class_1802.field_8567);
        DEFAULT_KNOWN_ITEMS.add(class_1802.field_8635);
        DEFAULT_KNOWN_ITEMS.add(class_1802.field_8497);
        DEFAULT_KNOWN_ITEMS.add(class_1802.field_46250);
        DEFAULT_KNOWN_ITEMS.add(class_1802.field_46249);
        DEFAULT_KNOWN_ITEMS.add(class_1802.field_42695);
        DEFAULT_KNOWN_ITEMS.add(class_1802.field_42711);
        DEFAULT_KNOWN_ITEMS.add(class_1802.field_43192);
        DEFAULT_KNOWN_ITEMS.add(class_1802.field_43195);
        DEFAULT_KNOWN_ITEMS.add(class_1802.field_8790);
    }

    class DepositInHopperGoal
    extends class_1352 {
        protected Long2LongOpenHashMap unreachableTargetsPosCache = new Long2LongOpenHashMap();
        protected int ticks;
        protected class_243 nextTarget;

        DepositInHopperGoal() {
        }

        public boolean method_6264() {
            if (!CocoaCritterEntity.this.isTrusting() || CocoaCritterEntity.this.method_6118(class_1304.field_6173).method_7960()) {
                return false;
            }
            if (CocoaCritterEntity.this.validHopperPos()) {
                return true;
            }
            Optional<class_2338> optional = this.getTargetBlock();
            if (optional.isPresent()) {
                CocoaCritterEntity.this.hopperPos = optional.get();
                return true;
            }
            return false;
        }

        public void method_6269() {
            this.ticks = 0;
        }

        public boolean method_6266() {
            return CocoaCritterEntity.this.validHopperPos() && !CocoaCritterEntity.this.method_6118(class_1304.field_6173).method_7960();
        }

        public void method_6268() {
            ++this.ticks;
            if (this.ticks > 300 || !CocoaCritterEntity.this.validHopperPos()) {
                CocoaCritterEntity.this.hopperPos = null;
            } else {
                class_243 vec3d = class_243.method_24955((class_2382)CocoaCritterEntity.this.hopperPos).method_1031(0.0, 1.0, 0.0);
                if (vec3d.method_1025(CocoaCritterEntity.this.method_19538()) > 1.0) {
                    this.nextTarget = vec3d;
                    this.moveToNextTarget();
                } else {
                    boolean bl;
                    if (this.nextTarget == null) {
                        this.nextTarget = vec3d;
                    }
                    boolean bl2 = bl = CocoaCritterEntity.this.method_19538().method_1022(this.nextTarget) <= 0.5;
                    if (!bl && this.ticks > 300) {
                        CocoaCritterEntity.this.hopperPos = null;
                    } else if (bl) {
                        class_1799 stack = CocoaCritterEntity.this.method_6118(class_1304.field_6173);
                        CocoaCritterEntity.this.tryPutDown(stack, false);
                    } else {
                        CocoaCritterEntity.this.method_5962().method_6239(this.nextTarget.method_10216(), this.nextTarget.method_10214(), this.nextTarget.method_10215(), (double)0.8f);
                    }
                }
            }
        }

        protected void moveToNextTarget() {
            CocoaCritterEntity.this.field_6189.method_6334(CocoaCritterEntity.this.field_6189.method_6352(this.nextTarget.method_10216(), this.nextTarget.method_10214(), this.nextTarget.method_10215(), 0), (double)1.2f);
        }

        protected boolean checkHopper(class_2338 blockPos) {
            return CocoaCritterEntity.this.method_37908().method_8320(blockPos).method_27852(class_2246.field_10312) && CocoaCritterEntity.this.method_37908().method_8320(blockPos.method_10084()).method_26171(class_10.field_50);
        }

        protected Optional<class_2338> getTargetBlock() {
            Iterable iterable = class_2338.method_25996((class_2338)CocoaCritterEntity.this.method_24515(), (int)12, (int)2, (int)12);
            Long2LongOpenHashMap long2LongOpenHashMap = new Long2LongOpenHashMap();
            for (class_2338 blockPos : iterable) {
                long l = this.unreachableTargetsPosCache.getOrDefault(blockPos.method_10063(), Long.MIN_VALUE);
                if (CocoaCritterEntity.this.method_37908().method_8510() < l) {
                    long2LongOpenHashMap.put(blockPos.method_10063(), l);
                    continue;
                }
                if (!this.checkHopper(blockPos)) continue;
                class_11 path = CocoaCritterEntity.this.field_6189.method_6348(blockPos, 0);
                if (path != null && path.method_21655()) {
                    return Optional.of(blockPos);
                }
                long2LongOpenHashMap.put(blockPos.method_10063(), CocoaCritterEntity.this.method_37908().method_8510() + 600L);
            }
            this.unreachableTargetsPosCache = long2LongOpenHashMap;
            return Optional.empty();
        }
    }

    class PickupItemGoal
    extends class_1352 {
        public PickupItemGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (!CocoaCritterEntity.this.method_6118(class_1304.field_6173).method_7960()) {
                return false;
            }
            if (CocoaCritterEntity.this.method_59922().method_43048(PickupItemGoal.method_38848((int)10)) != 0) {
                return false;
            }
            List list = CocoaCritterEntity.this.method_37908().method_8390(class_1542.class, CocoaCritterEntity.this.method_5829().method_1009(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
            return !list.isEmpty();
        }

        public void method_6268() {
            List list = CocoaCritterEntity.this.method_37908().method_8390(class_1542.class, CocoaCritterEntity.this.method_5829().method_1009(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
            class_1799 itemStack = CocoaCritterEntity.this.method_6118(class_1304.field_6173);
            if (itemStack.method_7960() && !list.isEmpty()) {
                this.moveTowardsCropItem(list);
            }
        }

        public void method_6269() {
            List list = CocoaCritterEntity.this.method_37908().method_8390(class_1542.class, CocoaCritterEntity.this.method_5829().method_1009(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
            if (!list.isEmpty()) {
                this.moveTowardsCropItem(list);
            }
        }

        private void moveTowardsCropItem(List<class_1542> list) {
            for (class_1542 itemEntity : list) {
                if (!CocoaCritterEntity.this.checkCrop(itemEntity.method_6983().method_7909())) continue;
                CocoaCritterEntity.this.method_5942().method_6335((class_1297)itemEntity, (double)1.2f);
                return;
            }
        }
    }
}

