/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer;

import de.maxhenkel.audioplayer.AudioManager;
import de.maxhenkel.audioplayer.AudioPlayer;
import de.maxhenkel.voicechat.api.Player;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.StaticAudioChannel;
import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class StaticAudioPlayer
implements de.maxhenkel.voicechat.api.audiochannel.AudioPlayer,
Runnable {
    private final Thread playbackThread = new Thread(this);
    private final AudioSupplier audio;
    private final VoicechatServerApi api;
    private final String category;
    private final class_243 pos;
    private final class_3218 level;
    private final float distance;
    private final OpusEncoder encoder;
    private static final long FRAME_SIZE_NS = 20000000L;
    public static final int SAMPLE_RATE = 48000;
    public static final int FRAME_SIZE = 960;
    private final ConcurrentHashMap<UUID, StaticAudioChannel> audioChannels;
    private boolean started;
    @Nullable
    private Runnable onStopped;

    public StaticAudioPlayer(short[] audio, VoicechatServerApi api, String category, class_243 pos, UUID playerID, class_3218 level, float distance) {
        this.audio = new AudioSupplier(this, audio);
        this.api = api;
        this.category = category;
        this.pos = pos;
        this.audioChannels = new ConcurrentHashMap();
        this.encoder = api.createEncoder();
        this.playbackThread.setDaemon(true);
        this.playbackThread.setName("StaticAudioPlayer-%s".formatted(playerID));
        this.level = level;
        this.distance = distance;
    }

    public static StaticAudioPlayer create(VoicechatServerApi api, class_3218 level, UUID sound, class_3222 p, int maxLengthSeconds, String category, class_243 pos, UUID playerID, float distance) {
        try {
            short[] audio = AudioManager.getSound(level.method_8503(), sound);
            if (AudioManager.getLengthSeconds(audio) > (float)maxLengthSeconds) {
                if (p != null) {
                    p.method_7353((class_2561)class_2561.method_43470((String)"Audio is too long to play").method_27692(class_124.field_1079), true);
                } else {
                    AudioPlayer.LOGGER.error("Audio {} was too long to play", (Object)sound);
                }
                return null;
            }
            StaticAudioPlayer instance = new StaticAudioPlayer(audio, api, category, pos, playerID, level, distance);
            instance.startPlaying();
            return instance;
        }
        catch (Exception e) {
            AudioPlayer.LOGGER.error("Failed to play audio", (Throwable)e);
            if (p != null) {
                p.method_7353((class_2561)class_2561.method_43470((String)"Failed to play audio: %s".formatted(e.getMessage())).method_27692(class_124.field_1079), true);
            }
            return null;
        }
    }

    public void startPlaying() {
        if (this.started) {
            return;
        }
        this.playbackThread.start();
        this.started = true;
    }

    public void stopPlaying() {
        this.playbackThread.interrupt();
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isPlaying() {
        return this.playbackThread.isAlive();
    }

    public boolean isStopped() {
        return this.started && !this.playbackThread.isAlive();
    }

    public void setOnStopped(Runnable onStopped) {
        this.onStopped = onStopped;
    }

    @Override
    public void run() {
        short[] frame;
        int framePosition = 0;
        ScheduledFuture<?> nearbyPlayersTask = AudioPlayer.SCHEDULED_EXECUTOR.scheduleAtFixedRate(() -> {
            List<class_3222> players = this.api.getPlayersInRange(this.api.fromServerLevel((Object)this.level), this.api.createPosition(this.pos.field_1352, this.pos.field_1351, this.pos.field_1350), (double)(this.distance + 1.0f), serverPlayer -> {
                VoicechatConnection connection = this.api.getConnectionOf(serverPlayer);
                if (connection != null) {
                    class_243 playerPos = ((class_3222)serverPlayer.getPlayer()).method_30950(0.0f);
                    return !connection.isDisabled() && this.pos.method_1022(playerPos) <= (double)this.distance;
                }
                return false;
            }).stream().map(Player::getPlayer).map(class_3222.class::cast).toList();
            for (class_3222 player : players) {
                this.audioChannels.computeIfAbsent(player.method_5667(), uuid -> {
                    StaticAudioChannel audioChannel = this.api.createStaticAudioChannel(UUID.randomUUID(), this.api.fromServerLevel((Object)this.level), this.api.getConnectionOf(this.api.fromServerPlayer((Object)player)));
                    audioChannel.setCategory(this.category);
                    return audioChannel;
                });
            }
            List<UUID> uuids = players.stream().map(class_1297::method_5667).toList();
            for (UUID uuid2 : this.audioChannels.keySet()) {
                if (uuids.contains(uuid2)) continue;
                StaticAudioChannel toRemove = this.audioChannels.remove(uuid2);
                toRemove.flush();
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
        long startTime = System.nanoTime();
        while ((frame = this.audio.get()) != null) {
            if (frame.length != 960) {
                AudioPlayer.LOGGER.error("Got invalid audio frame size {}!={}", (Object)frame.length, (Object)960);
                break;
            }
            byte[] encoded = this.encoder.encode(frame);
            for (StaticAudioChannel audioChannel : this.audioChannels.values()) {
                audioChannel.send(encoded);
            }
            long waitTimestamp = startTime + (long)(++framePosition) * 20000000L;
            long waitNanos = waitTimestamp - System.nanoTime();
            try {
                if (waitNanos <= 0L) continue;
                Thread.sleep(waitNanos / 1000000L, (int)(waitNanos % 1000000L));
            }
            catch (InterruptedException e) {
                break;
            }
        }
        this.encoder.close();
        nearbyPlayersTask.cancel(true);
        for (StaticAudioChannel audioChannel : this.audioChannels.values()) {
            audioChannel.flush();
        }
        if (this.onStopped != null) {
            this.onStopped.run();
        }
    }

    public class AudioSupplier
    implements Supplier<short[]> {
        private final short[] audioData;
        private final short[] frame;
        private int framePosition;

        public AudioSupplier(StaticAudioPlayer this$0, short[] audioData) {
            this.audioData = audioData;
            this.frame = new short[960];
        }

        @Override
        public short[] get() {
            if (this.framePosition >= this.audioData.length) {
                return null;
            }
            Arrays.fill(this.frame, (short)0);
            System.arraycopy(this.audioData, this.framePosition, this.frame, 0, Math.min(this.frame.length, this.audioData.length - this.framePosition));
            this.framePosition += this.frame.length;
            return this.frame;
        }
    }
}

