/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.maxhenkel.audioplayer.AudioManager;
import de.maxhenkel.audioplayer.AudioPlayer;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;

public class VolumeOverrideManager {
    private final File file;
    private final Gson gson;
    private Map<UUID, Float> volumes;
    @Nullable
    private static VolumeOverrideManager INSTANCE;
    private static final float LOG_BASE = 2.0f;

    public VolumeOverrideManager(File file) {
        this.file = file;
        this.gson = new GsonBuilder().create();
        this.volumes = new HashMap<UUID, Float>();
        this.load();
    }

    public void load() {
        if (!this.file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(this.file);){
            Type fileNameMapType = new TypeToken<Map<UUID, Float>>(this){}.getType();
            this.volumes = (Map)this.gson.fromJson((Reader)reader, fileNameMapType);
        }
        catch (Exception e) {
            AudioPlayer.LOGGER.error("Failed to load volume overrides", (Throwable)e);
        }
        if (this.volumes == null) {
            this.volumes = new HashMap<UUID, Float>();
        }
        this.save();
    }

    public void save() {
        this.file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(this.file);){
            this.gson.toJson(this.volumes, (Appendable)writer);
        }
        catch (Exception e) {
            AudioPlayer.LOGGER.error("Failed to save file name mappings", (Throwable)e);
        }
    }

    public float getAudioVolume(UUID audioId) {
        return this.volumes.getOrDefault(audioId, Float.valueOf(1.0f)).floatValue();
    }

    public void setAudioVolume(UUID audioId, @Nullable Float volume) {
        if (volume == null) {
            this.volumes.remove(audioId);
            this.save();
            return;
        }
        this.volumes.put(audioId, volume);
        this.save();
    }

    public static void init() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            AudioPlayer.LOGGER.info("Loading audio file volume overrides...");
            Path audioDataFolder = AudioManager.getAudioDataFolder(server);
            if (Files.exists(audioDataFolder, new LinkOption[0])) {
                try {
                    Files.createDirectories(audioDataFolder, new FileAttribute[0]);
                }
                catch (IOException e) {
                    AudioPlayer.LOGGER.error("Failed to create audio data folder", (Throwable)e);
                    return;
                }
            }
            INSTANCE = new VolumeOverrideManager(audioDataFolder.resolve("volume-overrides.json").toFile());
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            INSTANCE = null;
        });
    }

    public static Optional<VolumeOverrideManager> instance() {
        return Optional.ofNullable(INSTANCE);
    }

    public static float convertToLinearScaleFactor(float logarithmicScaleFactor) {
        if (logarithmicScaleFactor <= 0.0f) {
            return 0.0f;
        }
        return 1.0f + (float)(Math.log10(logarithmicScaleFactor) / 2.0);
    }

    public static float convertToLogarithmicScaleFactor(float linearScaleFactor) {
        linearScaleFactor = Math.max(0.0f, Math.min(linearScaleFactor, 1.0f));
        return (float)Math.pow(10.0, (linearScaleFactor - 1.0f) * 2.0f);
    }
}

