/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.annotations.Commands;
import de.maxhenkel.admiral.annotations.Name;
import de.maxhenkel.admiral.annotations.RequiresPermission;
import de.maxhenkel.audioplayer.AudioManager;
import de.maxhenkel.audioplayer.AudioPlayer;
import de.maxhenkel.audioplayer.Filebin;
import de.maxhenkel.audioplayer.webserver.UrlUtils;
import de.maxhenkel.audioplayer.webserver.WebServer;
import de.maxhenkel.audioplayer.webserver.WebServerEvents;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_5250;

@Command(value={"audioplayer"})
public class UploadCommands {
    public static final Pattern SOUND_FILE_PATTERN = Pattern.compile("^[a-z0-9_ -]+.((wav)|(mp3))$", 2);

    @RequiresPermission(value="audioplayer.upload")
    @Command
    public void audioPlayer(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Upload audio via Filebin ").method_10852((class_2561)class_2561.method_43470((String)"here").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/audioplayer upload")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to show more")))).method_27692(class_124.field_1060)).method_27693("."), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Upload audio with access to the servers file system ").method_10852((class_2561)class_2561.method_43470((String)"here").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/audioplayer serverfile")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to show more")))).method_27692(class_124.field_1060)).method_27693("."), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Upload audio from a URL ").method_10852((class_2561)class_2561.method_43470((String)"here").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/audioplayer url")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to show more")))).method_27692(class_124.field_1060)).method_27693("."), false);
    }

    @RequiresPermission(value="audioplayer.upload")
    @Commands(value={@Command(value={"upload"}), @Command(value={"filebin"})})
    public void filebin(CommandContext<class_2168> context) {
        UUID uuid = UUID.randomUUID();
        URI uploadURL = Filebin.getBin(uuid);
        class_5250 msg = class_2561.method_43470((String)"Click ").method_10852((class_2561)class_2561.method_43470((String)"this link").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(uploadURL)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to open")))).method_27692(class_124.field_1060)).method_27693(" and upload your sound as ").method_10852((class_2561)class_2561.method_43470((String)"mp3").method_27692(class_124.field_1080)).method_27693(" or ").method_10852((class_2561)class_2561.method_43470((String)"wav").method_27692(class_124.field_1080)).method_27693(".\n").method_27693("Once you have uploaded the file, click ").method_10852((class_2561)class_2561.method_43470((String)"here").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/audioplayer filebin " + String.valueOf(uuid))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to confirm upload")))).method_27692(class_124.field_1060)).method_27693(".");
        ((class_2168)context.getSource()).method_9226(() -> msg, false);
    }

    @RequiresPermission(value="audioplayer.upload")
    @Command(value={"filebin"})
    public void filebinUpload(CommandContext<class_2168> context, @Name(value="id") UUID sound) {
        new Thread(() -> {
            try {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Downloading sound, please wait..."), false);
                Filebin.downloadSound(((class_2168)context.getSource()).method_9211(), sound);
                ((class_2168)context.getSource()).method_9226(() -> UploadCommands.sendUUIDMessage(sound, class_2561.method_43470((String)"Successfully downloaded sound.")), false);
            }
            catch (Exception e) {
                AudioPlayer.LOGGER.warn("{} failed to download a sound: {}", (Object)((class_2168)context.getSource()).method_9214(), (Object)e.getMessage());
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Failed to download sound: %s".formatted(e.getMessage())));
            }
        }).start();
    }

    @RequiresPermission(value="audioplayer.upload")
    @Command(value={"url"})
    public void url(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"If you have a direct link to a ").method_10852((class_2561)class_2561.method_43470((String)".mp3").method_27692(class_124.field_1080)).method_27693(" or ").method_10852((class_2561)class_2561.method_43470((String)".wav").method_27692(class_124.field_1080)).method_27693(" file, enter the following command: ").method_10852((class_2561)class_2561.method_43470((String)"/audioplayer url <link-to-your-file>").method_27692(class_124.field_1080).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610("/audioplayer url ")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to fill in the command"))))).method_27693("."), false);
    }

    @RequiresPermission(value="audioplayer.upload")
    @Command(value={"url"})
    public void urlUpload(CommandContext<class_2168> context, @Name(value="url") String url) {
        UUID sound = UUID.randomUUID();
        new Thread(() -> {
            try {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Downloading sound, please wait..."), false);
                AudioManager.saveSound(((class_2168)context.getSource()).method_9211(), sound, url);
                ((class_2168)context.getSource()).method_9226(() -> UploadCommands.sendUUIDMessage(sound, class_2561.method_43470((String)"Successfully downloaded sound.")), false);
            }
            catch (UnknownHostException e) {
                AudioPlayer.LOGGER.warn("{} failed to download a sound: {}", (Object)((class_2168)context.getSource()).method_9214(), (Object)e.toString());
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Failed to download sound: Unknown host"));
            }
            catch (UnsupportedAudioFileException e) {
                AudioPlayer.LOGGER.warn("{} failed to download a sound: {}", (Object)((class_2168)context.getSource()).method_9214(), (Object)e.toString());
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Failed to download sound: Invalid file format"));
            }
            catch (Exception e) {
                AudioPlayer.LOGGER.warn("{} failed to download a sound: {}", (Object)((class_2168)context.getSource()).method_9214(), (Object)e.toString());
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Failed to download sound: %s".formatted(e.getMessage())));
            }
        }).start();
    }

    @RequiresPermission(value="audioplayer.upload")
    @Command(value={"web"})
    public void web(CommandContext<class_2168> context) throws CommandSyntaxException {
        WebServer webServer = WebServerEvents.getWebServer();
        if (webServer == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Web server is not running"));
            return;
        }
        UUID token = webServer.getTokenManager().generateToken(((class_2168)context.getSource()).method_9207().method_5667());
        URI uploadUrl = UrlUtils.generateUploadUrl(token);
        if (uploadUrl != null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Click ").method_10852((class_2561)class_2561.method_43470((String)"here").method_27695(new class_124[]{class_124.field_1060, class_124.field_1073}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(uploadUrl)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to open"))))).method_27693(" to upload your sound."), false);
            return;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Visit the website and use ").method_10852((class_2561)class_2561.method_43470((String)"this token").method_27692(class_124.field_1060).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10606(token.toString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to copy"))))).method_27693("."), false);
    }

    @RequiresPermission(value="audioplayer.upload")
    @Command(value={"serverfile"})
    public void serverFile(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Upload a ").method_10852((class_2561)class_2561.method_43470((String)".mp3").method_27692(class_124.field_1080)).method_27693(" or ").method_10852((class_2561)class_2561.method_43470((String)".wav").method_27692(class_124.field_1080)).method_27693(" file to ").method_10852((class_2561)class_2561.method_43470((String)AudioManager.getUploadFolder().toAbsolutePath().toString()).method_27692(class_124.field_1080)).method_27693(" on the server and run the command ").method_10852((class_2561)class_2561.method_43470((String)"/audioplayer serverfile \"yourfile.mp3\"").method_27692(class_124.field_1080).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610("/audioplayer serverfile ")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to fill in the command"))))).method_27693("."), false);
    }

    @RequiresPermission(value="audioplayer.upload")
    @Command(value={"serverfile"})
    public void serverFileUpload(CommandContext<class_2168> context, @Name(value="filename") String fileName) {
        Matcher matcher = SOUND_FILE_PATTERN.matcher(fileName);
        if (!matcher.matches()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid file name! Valid characters are ").method_10852((class_2561)class_2561.method_43470((String)"A-Z").method_27692(class_124.field_1080)).method_27693(", ").method_10852((class_2561)class_2561.method_43470((String)"0-9").method_27692(class_124.field_1080)).method_27693(", ").method_10852((class_2561)class_2561.method_43470((String)"_").method_27692(class_124.field_1080)).method_27693(" and ").method_10852((class_2561)class_2561.method_43470((String)"-").method_27692(class_124.field_1080)).method_27693(". The name must also end in ").method_10852((class_2561)class_2561.method_43470((String)".mp3").method_27692(class_124.field_1080)).method_27693(" or ").method_10852((class_2561)class_2561.method_43470((String)".wav").method_27692(class_124.field_1080)).method_27693("."));
            return;
        }
        UUID uuid = UUID.randomUUID();
        new Thread(() -> {
            Path file = AudioManager.getUploadFolder().resolve(fileName);
            try {
                AudioManager.saveSound(((class_2168)context.getSource()).method_9211(), uuid, file);
                ((class_2168)context.getSource()).method_9226(() -> UploadCommands.sendUUIDMessage(uuid, class_2561.method_43470((String)"Successfully copied sound.")), false);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Deleted temporary file ").method_10852((class_2561)class_2561.method_43470((String)fileName).method_27692(class_124.field_1080)).method_27693("."), false);
            }
            catch (NoSuchFileException e) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Could not find file ").method_10852((class_2561)class_2561.method_43470((String)fileName).method_27692(class_124.field_1080)).method_27693("."));
            }
            catch (Exception e) {
                AudioPlayer.LOGGER.warn("{} failed to copy a sound: {}", (Object)((class_2168)context.getSource()).method_9214(), (Object)e.getMessage());
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Failed to copy sound: %s".formatted(e.getMessage())));
            }
        }).start();
    }

    public static class_5250 sendUUIDMessage(UUID soundID, class_5250 component) {
        return component.method_27693(" ").method_10852((class_2561)class_2564.method_10885((class_2561)class_2561.method_43470((String)"Copy ID")).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10606(soundID.toString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Copy sound ID")))).method_27692(class_124.field_1060)).method_27693(" ").method_10852((class_2561)class_2564.method_10885((class_2561)class_2561.method_43470((String)"Put on item")).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610("/audioplayer apply %s".formatted(soundID.toString()))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Put the sound on an item")))).method_27692(class_124.field_1060));
    }
}

