/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.webserver;

import de.maxhenkel.audioplayer.AudioPlayer;
import de.maxhenkel.audioplayer.webserver.WebServer;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;

public class WebServerEvents {
    @Nullable
    private static WebServer webServer;

    public static void onServerStarted(MinecraftServer server) {
        WebServerEvents.closeServerIfRunning();
        if (!AudioPlayer.SERVER_CONFIG.runWebServer.get().booleanValue()) {
            return;
        }
        try {
            webServer = WebServer.create(server).start();
            AudioPlayer.LOGGER.info("Audio player upload web server started on port {}", (Object)webServer.getPort());
        }
        catch (Exception e) {
            AudioPlayer.LOGGER.error("Failed to start web server", (Throwable)e);
        }
    }

    public static void onServerStopped(MinecraftServer server) {
        if (webServer != null) {
            AudioPlayer.LOGGER.info("Audio player upload web server stopped");
        }
        WebServerEvents.closeServerIfRunning();
    }

    private static void closeServerIfRunning() {
        if (webServer != null) {
            webServer.close();
            webServer = null;
        }
    }

    public static boolean isRunning() {
        return webServer != null;
    }

    @Nullable
    public static WebServer getWebServer() {
        return webServer;
    }
}

