/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.client.particle;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import it.hurts.octostudios.octolib.client.particle.ParticleSystem;
import it.hurts.octostudios.octolib.client.particle.Transform;
import it.hurts.octostudios.octolib.util.OctoColor;
import it.hurts.octostudios.octolib.util.RenderUtils;
import java.util.ArrayList;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class UIParticle {
    public static final RenderPipeline ADDITIVE_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56864}).withBlend(BlendFunction.LIGHTNING).withColorWrite(true).withLocation(class_2960.method_60655((String)"octolib", (String)"additive")).build();
    private final Texture2D texture;
    private final float maxSpeed;
    private final int lifetime;
    private final Layer layer;
    private class_437 screen;
    private final Transform transform;
    private Vector2f direction = new Vector2f(0.0f, 1.0f);
    private float rollVelocity;
    private float speed;
    private int time;
    private float zOffset;
    private OctoColor[] colors = new OctoColor[]{OctoColor.WHITE};
    private RenderPipeline renderPipeline = class_10799.field_56883;
    private Matrix3x2f matrix = new Matrix3x2f();

    public UIParticle(Texture2D texture, float maxSpeed, int lifetime, float xStart, float yStart, Layer layer, float zOffset) {
        this.texture = texture;
        this.maxSpeed = maxSpeed;
        this.lifetime = lifetime;
        this.speed = maxSpeed;
        this.layer = layer;
        this.zOffset = zOffset;
        this.transform = new Transform(new Vector2f(xStart, yStart), 0.0f, new Vector2f(1.0f, 1.0f));
    }

    public void setMatrix(Matrix3x2f matrix) {
        this.matrix = new Matrix3x2f((Matrix3x2fc)matrix);
    }

    public Matrix3x2f getMatrix() {
        return new Matrix3x2f((Matrix3x2fc)this.matrix);
    }

    public void setColors(OctoColor ... colors) {
        this.colors = colors;
    }

    public void setDirection(float x, float y) {
        this.direction = new Vector2f(x, y).normalize();
    }

    public void setDirection(Vector2f direction) {
        this.direction = new Vector2f((Vector2fc)direction).normalize();
    }

    public boolean isExpired() {
        return this.time >= this.lifetime;
    }

    public boolean isScreen() {
        return this.layer == Layer.SCREEN;
    }

    public boolean isGui() {
        return this.layer == Layer.GUI;
    }

    public void tick() {
        if (this.isExpired()) {
            return;
        }
        this.transform.updateOldValues();
        this.time = class_3532.method_15340((int)(this.time + 1), (int)0, (int)this.lifetime);
        if (class_3532.method_15379((float)this.speed) > 0.01f) {
            this.transform.getPosition().add((Vector2fc)new Vector2f((Vector2fc)this.direction).mul(this.speed));
        }
        if (class_3532.method_15379((float)this.rollVelocity) > 0.01f) {
            this.transform.setRoll(this.transform.getRoll() + this.rollVelocity);
        }
    }

    public void render(class_332 guiGraphics, float partialTicks) {
        if (this.isExpired()) {
            return;
        }
        Texture2D tex = this.getTexture();
        Matrix3x2f matrix = this.getMatrix();
        this.transformPose(matrix, partialTicks);
        OctoColor color = this.getColor(partialTicks);
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().mul((Matrix3x2fc)matrix);
        RenderUtils.renderTextureFromCenter(this.getRenderPipeline(), tex.rl, guiGraphics, 0.0f, 0.0f, tex.texOffX, tex.texOffY, (int)tex.texWidth, (int)tex.texHeight, tex.width, tex.height, 1.0f, color.getARGB());
        guiGraphics.method_51448().popMatrix();
    }

    private void transformPose(Matrix3x2f pose, float partialTicks) {
        Vector2f interpPos = this.transform.getInterpolatedPosition(partialTicks);
        float interpRot = this.transform.getInterpolatedRoll(partialTicks);
        Vector2f interpSize = this.transform.getInterpolatedSize(partialTicks);
        pose.translate(interpPos.x, interpPos.y);
        pose.scale(interpSize.x, interpSize.y);
        pose.rotate((float)Math.toRadians(interpRot));
    }

    public float getTimeRatio(float partialTicks) {
        return ((float)this.time + partialTicks) / (float)this.lifetime;
    }

    public OctoColor getColor(float partialTicks) {
        return OctoColor.lerp(this.getTimeRatio(partialTicks), this.colors);
    }

    public void instantiate() {
        if (this.isScreen()) {
            if (this.screen == null) {
                return;
            }
            ParticleSystem.SCREEN_PARTICLES.putIfAbsent(this.screen, new ArrayList());
            ParticleSystem.SCREEN_PARTICLES.get(this.screen).add(this);
            return;
        }
        ParticleSystem.GUI_PARTICLES.add(this);
    }

    public Texture2D getTexture() {
        return this.texture;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public class_437 getScreen() {
        return this.screen;
    }

    public void setScreen(class_437 screen) {
        this.screen = screen;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public Vector2f getDirection() {
        return this.direction;
    }

    public float getRollVelocity() {
        return this.rollVelocity;
    }

    public void setRollVelocity(float rollVelocity) {
        this.rollVelocity = rollVelocity;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public float getZOffset() {
        return this.zOffset;
    }

    public void setZOffset(float zOffset) {
        this.zOffset = zOffset;
    }

    public OctoColor[] getColors() {
        return this.colors;
    }

    public RenderPipeline getRenderPipeline() {
        return this.renderPipeline;
    }

    public void setRenderPipeline(RenderPipeline renderPipeline) {
        this.renderPipeline = renderPipeline;
    }

    public static class Texture2D {
        private class_2960 rl;
        private float width;
        private float height;
        private float texOffX;
        private float texOffY;
        private float texWidth;
        private float texHeight;

        public Texture2D(class_2960 texture, int texOffX, int texOffY, int texWidth, int texHeight, int width, int height) {
            this.rl = texture;
            this.texOffX = texOffX;
            this.texOffY = texOffY;
            this.texWidth = texWidth;
            this.texHeight = texHeight;
            this.width = width;
            this.height = height;
        }

        public Texture2D(class_2960 texture, int width, int height) {
            this(texture, 0, 0, width, height, width, height);
        }

        public class_2960 getRl() {
            return this.rl;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }

        public float getTexOffX() {
            return this.texOffX;
        }

        public float getTexOffY() {
            return this.texOffY;
        }

        public float getTexWidth() {
            return this.texWidth;
        }

        public float getTexHeight() {
            return this.texHeight;
        }

        public void setRl(class_2960 rl) {
            this.rl = rl;
        }

        public void setWidth(float width) {
            this.width = width;
        }

        public void setHeight(float height) {
            this.height = height;
        }

        public void setTexOffX(float texOffX) {
            this.texOffX = texOffX;
        }

        public void setTexOffY(float texOffY) {
            this.texOffY = texOffY;
        }

        public void setTexWidth(float texWidth) {
            this.texWidth = texWidth;
        }

        public void setTexHeight(float texHeight) {
            this.texHeight = texHeight;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Texture2D)) {
                return false;
            }
            Texture2D other = (Texture2D)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
                return false;
            }
            if (Float.compare(this.getHeight(), other.getHeight()) != 0) {
                return false;
            }
            if (Float.compare(this.getTexOffX(), other.getTexOffX()) != 0) {
                return false;
            }
            if (Float.compare(this.getTexOffY(), other.getTexOffY()) != 0) {
                return false;
            }
            if (Float.compare(this.getTexWidth(), other.getTexWidth()) != 0) {
                return false;
            }
            if (Float.compare(this.getTexHeight(), other.getTexHeight()) != 0) {
                return false;
            }
            class_2960 this$rl = this.getRl();
            class_2960 other$rl = other.getRl();
            return !(this$rl == null ? other$rl != null : !this$rl.equals(other$rl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Texture2D;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getWidth());
            result = result * 59 + Float.floatToIntBits(this.getHeight());
            result = result * 59 + Float.floatToIntBits(this.getTexOffX());
            result = result * 59 + Float.floatToIntBits(this.getTexOffY());
            result = result * 59 + Float.floatToIntBits(this.getTexWidth());
            result = result * 59 + Float.floatToIntBits(this.getTexHeight());
            class_2960 $rl = this.getRl();
            result = result * 59 + ($rl == null ? 43 : $rl.hashCode());
            return result;
        }

        public String toString() {
            return "UIParticle.Texture2D(rl=" + String.valueOf(this.getRl()) + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", texOffX=" + this.getTexOffX() + ", texOffY=" + this.getTexOffY() + ", texWidth=" + this.getTexWidth() + ", texHeight=" + this.getTexHeight() + ")";
        }
    }

    public static enum Layer {
        GUI,
        SCREEN;

    }
}

