/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.entity.mob;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.entity.ai.goal.LeaveWaterGoal;
import com.faboslav.variantsandventures.common.entity.ai.goal.TargetAboveWaterGoal;
import com.faboslav.variantsandventures.common.entity.ai.goal.WanderAroundOnSurfaceGoal;
import com.faboslav.variantsandventures.common.init.VariantsAndVenturesSoundEvents;
import com.faboslav.variantsandventures.common.versions.VersionedEntitySpawnReason;
import com.faboslav.variantsandventures.common.versions.VersionedInteractionResult;
import com.faboslav.variantsandventures.common.versions.VersionedNbt;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import net.minecraft.class_11;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1412;
import net.minecraft.class_1439;
import net.minecraft.class_1481;
import net.minecraft.class_156;
import net.minecraft.class_1613;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5147;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5762;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class MurkEntity
extends class_1613
implements class_5147 {
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(MurkEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SHEARED = class_2945.method_12791(MurkEntity.class, (class_2941)class_2943.field_13323);
    public static final String VARIANT_NBT_KEY = "Variant";
    public static final String SHEARED_NBT_KEY = "Sheared";
    private boolean targetingUnderwater;
    private final class_1412 waterNavigation;
    private final class_1409 landNavigation;

    public MurkEntity(class_1299<? extends class_1613> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new MurkMoveControl(this, this);
        this.method_5941(class_7.field_18, 0.0f);
        this.waterNavigation = new class_1412((class_1308)this, world);
        this.landNavigation = new class_1409((class_1308)this, world);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.setVariant(Variant.getRandom(this.field_5974));
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public static boolean canSpawn(class_1299<MurkEntity> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        if (spawnReason == VersionedEntitySpawnReason.NATURAL) {
            return world.method_8316(pos.method_10074()).method_15767(class_3486.field_15517) && MurkEntity.isValidSpawnDepth((class_1936)world, pos) && random.method_43048(40) == 0;
        }
        return true;
    }

    private static boolean isValidSpawnDepth(class_1936 world, class_2338 pos) {
        return pos.method_10264() < world.method_8615() - 5;
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new WanderAroundOnSurfaceGoal((class_1314)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new LeaveWaterGoal(this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new TargetAboveWaterGoal(this, 1.0, this.method_37908().method_8615()));
        this.field_6201.method_6277(7, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, (livingEntity, serverLevel) -> this.canAttackTarget(livingEntity)));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_5762.class, true, false));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1481.class, 10, true, false, class_1481.field_6921));
        super.method_5959();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)0);
        builder.method_56912(SHEARED, (Object)false);
    }

    public void method_5652(class_11372 nbt) {
        super.method_5652(nbt);
        nbt.method_71465(VARIANT_NBT_KEY, this.getVariant().getId());
        nbt.method_71472(SHEARED_NBT_KEY, this.isSheared());
    }

    public void method_5749(class_11368 nbt) {
        super.method_5749(nbt);
        this.setVariant(Variant.VARIANTS[VersionedNbt.getInt(nbt, VARIANT_NBT_KEY, Variant.PURPLE.ordinal())]);
        this.setSheared(VersionedNbt.getBoolean(nbt, SHEARED_NBT_KEY, false));
    }

    public boolean method_5957(class_4538 world) {
        return world.method_8606((class_1297)this);
    }

    public static class_5132.class_5133 createMurkAttributes() {
        return class_1613.method_26905().method_26868(class_5134.field_23716, 16.0);
    }

    protected class_3414 method_5994() {
        return this.method_5799() ? VariantsAndVenturesSoundEvents.ENTITY_MURK_AMBIENT_WATER.get() : VariantsAndVenturesSoundEvents.ENTITY_MURK_AMBIENT.get();
    }

    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        if (soundEvent != null) {
            this.method_5783(soundEvent, this.method_5799() ? 0.25f : this.method_6107(), this.method_6017());
        }
    }

    protected class_3414 method_6011(class_1282 source) {
        return this.method_5799() ? VariantsAndVenturesSoundEvents.ENTITY_MURK_HURT_WATER.get() : VariantsAndVenturesSoundEvents.ENTITY_MURK_HURT.get();
    }

    protected class_3414 method_6002() {
        return this.method_5799() ? VariantsAndVenturesSoundEvents.ENTITY_MURK_DEATH_WATER.get() : VariantsAndVenturesSoundEvents.ENTITY_MURK_DEATH.get();
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
        this.method_5783(this.method_5799() ? VariantsAndVenturesSoundEvents.ENTITY_MURK_STEP.get() : class_3417.field_14548, 0.15f, 1.0f);
    }

    public void method_5773() {
        if (!VariantsAndVentures.getConfig().enableMurk) {
            this.method_31472();
        }
        super.method_5773();
    }

    public void method_7105(class_1309 target, float velocity) {
        class_1799 possibleBow = this.method_5998(class_1675.method_18812((class_1309)this, (class_1792)class_1802.field_8102));
        if (!possibleBow.method_31574(class_1802.field_8102)) {
            return;
        }
        class_1799 possibleProjectile = this.method_18808(possibleBow);
        if (possibleProjectile == class_1799.field_8037) {
            return;
        }
        class_1665 abstractArrow = this.method_6996(possibleProjectile, velocity, possibleBow);
        double d = target.method_23317() - this.method_23317();
        double e = target.method_23323(0.3333333333333333) - abstractArrow.method_23318();
        double f = target.method_23321() - this.method_23321();
        double g = Math.sqrt(d * d + f * f);
        class_1937 var15 = this.method_37908();
        if (var15 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)var15;
            class_1676.method_61552((class_1676)abstractArrow, (class_3218)serverLevel, (class_1799)possibleProjectile, (double)d, (double)(e + g * (double)0.2f), (double)f, (float)1.6f, (float)(14 - serverLevel.method_8407().method_5461() * 4));
        }
        this.method_5783(VariantsAndVenturesSoundEvents.ENTITY_MURK_ATTACK.get(), 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
    }

    public boolean method_5675() {
        return !this.method_5681();
    }

    public boolean method_35053() {
        return this.method_5681();
    }

    private boolean isTargetingUnderwater() {
        if (this.targetingUnderwater) {
            return true;
        }
        class_1309 livingEntity = this.method_5968();
        return livingEntity != null && livingEntity.method_5799();
    }

    public void setTargetingUnderwater(boolean targetingUnderwater) {
        this.targetingUnderwater = targetingUnderwater;
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_6034() && this.method_5799() && this.isTargetingUnderwater()) {
            this.method_5724(0.01f, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
        } else {
            super.method_6091(movementInput);
        }
    }

    public void method_5790() {
        if (!this.method_37908().method_8608()) {
            if (this.method_6034() && this.method_5799() && this.isTargetingUnderwater()) {
                this.field_6189 = this.waterNavigation;
                this.method_5796(true);
            } else {
                this.field_6189 = this.landNavigation;
                this.method_5796(false);
            }
        }
    }

    public boolean hasFinishedCurrentPath() {
        class_2338 blockPos;
        class_11 path = this.method_5942().method_6345();
        if (path != null && (blockPos = path.method_48()) != null) {
            double d = this.method_5649(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
            return d < 4.0;
        }
        return false;
    }

    public boolean isSheared() {
        return (Boolean)this.field_6011.method_12789(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.field_6011.method_12778(SHEARED, (Object)sheared);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_8868) && this.method_27072()) {
            if (!this.method_37908().method_8608()) {
                this.method_6636((class_3218)this.method_37908(), class_3419.field_15248, itemStack);
                this.method_32875((class_6880)class_5712.field_28730, (class_1297)player);
                class_1304 equipment = class_1657.method_56079((class_1268)hand);
                itemStack.method_7970(1, (class_1309)player, equipment);
            }
            return VersionedInteractionResult.success((class_1297)this);
        }
        return super.method_5992(player, hand);
    }

    public void method_6636(class_3218 level, class_3419 soundSource, class_1799 shears) {
        this.method_37908().method_43129(null, (class_1297)this, VariantsAndVenturesSoundEvents.ENTITY_MURK_SHEAR.get(), soundSource, 1.0f, 1.0f);
        this.dropShearedItems(level, shears);
        this.setSheared(true);
    }

    private void dropShearedItems(class_3218 level, class_1799 stack) {
        class_5321 shearingLootTableResourceKey = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)VariantsAndVentures.makeID(String.format(Locale.ROOT, "shearing/murk_%s", this.getVariant().getName())));
        this.method_61419(level, shearingLootTableResourceKey, stack, (serverLevel, itemStack) -> this.method_5699((class_3218)serverLevel, (class_1799)itemStack, this.method_17682()));
    }

    public boolean method_27072() {
        return !this.isSheared() && this.method_5805();
    }

    public boolean method_33590() {
        return false;
    }

    public boolean method_35191() {
        return false;
    }

    protected void method_33591() {
    }

    public boolean method_32316() {
        return false;
    }

    public boolean canAttackTarget(@Nullable class_1309 target) {
        if (target != null) {
            boolean isDay = this.method_37908().method_8530();
            return !isDay || target.method_5799();
        }
        return false;
    }

    private void setNavigation(class_1408 navigation) {
        this.field_6189 = navigation;
    }

    public void setLandNavigation() {
        this.field_6189 = this.landNavigation;
    }

    public void setWaterNavigation() {
        this.field_6189 = this.waterNavigation;
    }

    public Variant getVariant() {
        return Variant.VARIANTS[(Integer)this.field_6011.method_12789(VARIANT)];
    }

    private void setVariant(Variant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    private final class MurkMoveControl
    extends class_1335 {
        private final MurkEntity murk;

        public MurkMoveControl(MurkEntity murkEntity, MurkEntity murk) {
            super((class_1308)murk);
            this.murk = murk;
        }

        public void method_6240() {
            class_1309 livingEntity = this.murk.method_5968();
            if (this.murk.isTargetingUnderwater() && this.murk.method_5799()) {
                if (livingEntity != null && livingEntity.method_23318() > this.murk.method_23318() || this.murk.targetingUnderwater) {
                    this.murk.method_18799(this.murk.method_18798().method_1031(0.0, 0.002, 0.0));
                }
                if (this.field_6374 != class_1335.class_1336.field_6378 || this.murk.method_5942().method_6357()) {
                    this.murk.method_6125(0.0f);
                    return;
                }
                double d = this.field_6370 - this.murk.method_23317();
                double e = this.field_6369 - this.murk.method_23318();
                double f = this.field_6367 - this.murk.method_23321();
                double g = Math.sqrt(d * d + e * e + f * f);
                e /= g;
                float h = (float)(class_3532.method_15349((double)f, (double)d) * 57.2957763671875) - 90.0f;
                this.murk.method_36456(this.method_6238(this.murk.method_36454(), h, 90.0f));
                this.murk.field_6283 = this.murk.method_36454();
                float i = (float)(this.field_6372 * this.murk.method_45325(class_5134.field_23719));
                float j = class_3532.method_16439((float)0.125f, (float)this.murk.method_6029(), (float)i);
                this.murk.method_6125(j);
                this.murk.method_18799(this.murk.method_18798().method_1031((double)j * d * 0.005, (double)j * e * 0.1, (double)j * f * 0.005));
            } else {
                if (!this.murk.method_24828()) {
                    this.murk.method_18799(this.murk.method_18798().method_1031(0.0, -0.008, 0.0));
                }
                super.method_6240();
            }
        }
    }

    public static enum Variant {
        PURPLE(0, "purple"),
        RED(1, "red"),
        YELLOW(2, "yellow");

        public static final Variant[] VARIANTS;
        private final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        private static Variant getRandom(class_5819 random) {
            return (Variant)((Object)class_156.method_27173((Object[])((Variant[])Arrays.stream(VARIANTS).toArray(Variant[]::new)), (class_5819)random));
        }

        static {
            VARIANTS = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

