/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable;

import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.constant.dataticket.SerializableDataTicket;
import software.bernie.geckolib.util.RenderUtil;

public interface GeoBlockEntity
extends GeoAnimatable {
    @ApiStatus.NonExtendable
    @Nullable
    default public <D> D getAnimData(SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(0L).getAnimatableData(dataTicket);
    }

    @ApiStatus.NonExtendable
    default public <D> void setAnimData(SerializableDataTicket<D> dataTicket, D data) {
        class_2586 blockEntity = (class_2586)this;
        class_1937 level = blockEntity.method_10997();
        if (level == null) {
            GeckoLibConstants.LOGGER.error("Attempting to set animation data for BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + blockEntity.getClass().toString() + ")");
            return;
        }
        if (level.method_8608()) {
            this.getAnimatableInstanceCache().getManagerForId(0L).setAnimatableData(dataTicket, data);
        } else {
            GeckoLibServices.NETWORK.syncBlockEntityAnimData(blockEntity.method_11016(), dataTicket, data, (class_3218)level);
        }
    }

    @ApiStatus.NonExtendable
    default public void triggerAnim(@Nullable String controllerName, String animName) {
        class_2586 blockEntity = (class_2586)this;
        class_1937 level = blockEntity.method_10997();
        if (level == null) {
            GeckoLibConstants.LOGGER.error("Attempting to trigger an animation for a BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + blockEntity.getClass().toString() + ")");
            return;
        }
        if (level.method_8608()) {
            this.getAnimatableInstanceCache().getManagerForId(0L).tryTriggerAnimation(controllerName, animName);
        } else {
            GeckoLibServices.NETWORK.triggerBlockEntityAnim(blockEntity.method_11016(), (class_3218)level, controllerName, animName);
        }
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredAnim(@Nullable String controllerName, @Nullable String animName) {
        class_2586 blockEntity = (class_2586)this;
        class_1937 level = blockEntity.method_10997();
        if (level == null) {
            GeckoLibConstants.LOGGER.error("Attempting to stop a triggered animation for a BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + blockEntity.getClass().toString() + ")");
            return;
        }
        if (level.method_8608()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(0L);
            if (animatableManager == null) {
                return;
            }
            if (controllerName != null) {
                animatableManager.stopTriggeredAnimation(controllerName, animName);
            } else {
                animatableManager.stopTriggeredAnimation(animName);
            }
        } else {
            GeckoLibServices.NETWORK.stopTriggeredBlockEntityAnim(blockEntity.method_11016(), (class_3218)level, controllerName, animName);
        }
    }

    @Override
    default public double getTick(Object blockEntity) {
        return RenderUtil.getCurrentTick();
    }
}

