/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable.manager;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.state.BoneSnapshot;
import software.bernie.geckolib.constant.dataticket.DataTicket;

public class AnimatableManager<T extends GeoAnimatable> {
    private final Map<String, BoneSnapshot> boneSnapshotCollection = new Object2ObjectOpenHashMap();
    private final Map<String, AnimationController<T>> animationControllers;
    private Map<DataTicket<?>, Object> animatableInstanceData;
    private double lastUpdateTime;
    private boolean isFirstTick = true;
    private double firstTickTime = -1.0;

    public AnimatableManager(GeoAnimatable animatable) {
        ControllerRegistrar registrar = new ControllerRegistrar((List<AnimationController<? extends GeoAnimatable>>)new ObjectArrayList(1));
        animatable.registerControllers(registrar);
        this.animationControllers = registrar.build();
    }

    public void addController(AnimationController controller) {
        this.getAnimationControllers().put(controller.getName(), controller);
    }

    public void removeController(String name) {
        this.getAnimationControllers().remove(name);
    }

    public Map<String, AnimationController<T>> getAnimationControllers() {
        return this.animationControllers;
    }

    public Map<String, BoneSnapshot> getBoneSnapshotCollection() {
        return this.boneSnapshotCollection;
    }

    public void clearSnapshotCache() {
        this.getBoneSnapshotCollection().clear();
    }

    public double getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void updatedAt(double updateTime) {
        this.lastUpdateTime = updateTime;
    }

    public double getFirstTickTime() {
        return this.firstTickTime;
    }

    public void startedAt(double time) {
        this.firstTickTime = time;
    }

    public boolean isFirstTick() {
        return this.isFirstTick;
    }

    @ApiStatus.Internal
    public void finishFirstTick() {
        this.isFirstTick = false;
    }

    public <D> void setAnimatableData(DataTicket<D> dataTicket, D data) {
        if (this.animatableInstanceData == null) {
            this.animatableInstanceData = new Object2ObjectOpenHashMap();
        }
        this.animatableInstanceData.put(dataTicket, data);
    }

    public <D> D getAnimatableData(DataTicket<D> dataTicket) {
        return (D)(this.animatableInstanceData != null ? this.animatableInstanceData.get(dataTicket) : null);
    }

    public void tryTriggerAnimation(String animName) {
        for (AnimationController<T> controller : this.getAnimationControllers().values()) {
            if (!controller.tryTriggerAnimation(animName)) continue;
            return;
        }
    }

    public void tryTriggerAnimation(String controllerName, String animName) {
        AnimationController<T> controller = this.getAnimationControllers().get(controllerName);
        if (controller != null) {
            controller.tryTriggerAnimation(animName);
        }
    }

    public void stopTriggeredAnimation(@Nullable String animName) {
        for (AnimationController<T> controller : this.getAnimationControllers().values()) {
            if (animName != null && !controller.isTriggeredAnimation(animName) || !controller.stopTriggeredAnimation()) continue;
            return;
        }
    }

    public void stopTriggeredAnimation(String controllerName, @Nullable String animName) {
        AnimationController<T> controller = this.getAnimationControllers().get(controllerName);
        if (controller != null && (animName == null || controller.isTriggeredAnimation(animName))) {
            controller.stopTriggeredAnimation();
        }
    }

    public record ControllerRegistrar(List<AnimationController<? extends GeoAnimatable>> controllers) {
        public ControllerRegistrar add(AnimationController<?> ... controllers) {
            this.controllers().addAll(Arrays.asList(controllers));
            return this;
        }

        public ControllerRegistrar add(AnimationController<?> controller) {
            this.controllers().add(controller);
            return this;
        }

        public ControllerRegistrar remove(String name) {
            this.controllers().removeIf(controller -> controller.getName().equals(name));
            return this;
        }

        @ApiStatus.Internal
        private <T extends GeoAnimatable> Object2ObjectArrayMap<String, AnimationController<T>> build() {
            Object2ObjectArrayMap map = new Object2ObjectArrayMap(this.controllers().size());
            this.controllers().forEach(controller -> map.put((Object)controller.getName(), controller));
            return map;
        }
    }
}

