/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animation;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animatable.processing.AnimationState;
import software.bernie.geckolib.animation.keyframe.BoneAnimation;
import software.bernie.geckolib.animation.keyframe.event.data.CustomInstructionKeyframeData;
import software.bernie.geckolib.animation.keyframe.event.data.ParticleKeyframeData;
import software.bernie.geckolib.animation.keyframe.event.data.SoundKeyframeData;
import software.bernie.geckolib.loading.math.value.Variable;

public record Animation(String name, double length, LoopType loopType, BoneAnimation[] boneAnimations, Set<Variable> usedVariables, KeyframeMarkers keyframeMarkers) {
    public static Animation create(String name, double length, LoopType loopType, BoneAnimation[] boneAnimations, KeyframeMarkers keyframeMarkers) {
        ReferenceOpenHashSet usedVariables = new ReferenceOpenHashSet();
        for (BoneAnimation boneAnimation : boneAnimations) {
            usedVariables.addAll(boneAnimation.getUsedVariables());
        }
        return new Animation(name, length, loopType, boneAnimations, (Set<Variable>)usedVariables, keyframeMarkers);
    }

    @ApiStatus.Internal
    public static Animation generateWaitAnimation(double length) {
        return new Animation("internal.wait", length, LoopType.PLAY_ONCE, new BoneAnimation[0], (Set<Variable>)ReferenceOpenHashSet.of(), new KeyframeMarkers(new SoundKeyframeData[0], new ParticleKeyframeData[0], new CustomInstructionKeyframeData[0]));
    }

    @FunctionalInterface
    public static interface LoopType {
        public static final Map<String, LoopType> LOOP_TYPES = new ConcurrentHashMap<String, LoopType>(4);
        public static final LoopType DEFAULT = (animationState, controller, currentAnimation) -> currentAnimation.loopType().shouldPlayAgain(animationState, controller, currentAnimation);
        public static final LoopType PLAY_ONCE = LoopType.register("play_once", LoopType.register("false", (animationState, controller, currentAnimation) -> false));
        public static final LoopType HOLD_ON_LAST_FRAME = LoopType.register("hold_on_last_frame", (animationState, controller, currentAnimation) -> {
            controller.setAnimationState(AnimationController.State.PAUSED);
            return true;
        });
        public static final LoopType LOOP = LoopType.register("loop", LoopType.register("true", (animationState, controller, currentAnimation) -> true));

        public boolean shouldPlayAgain(AnimationState<?> var1, AnimationController<? extends GeoAnimatable> var2, Animation var3);

        public static LoopType fromJson(JsonElement json) {
            if (json == null || !json.isJsonPrimitive()) {
                return PLAY_ONCE;
            }
            JsonPrimitive primitive = json.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean() ? LOOP : PLAY_ONCE;
            }
            if (primitive.isString()) {
                return LoopType.fromString(primitive.getAsString());
            }
            return PLAY_ONCE;
        }

        public static LoopType fromString(String name) {
            return LOOP_TYPES.getOrDefault(name, PLAY_ONCE);
        }

        public static LoopType register(String name, LoopType loopType) {
            LOOP_TYPES.put(name, loopType);
            return loopType;
        }
    }

    public record KeyframeMarkers(SoundKeyframeData[] sounds, ParticleKeyframeData[] particles, CustomInstructionKeyframeData[] customInstructions) {
    }
}

