/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_10034;
import net.minecraft.class_10186;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5602;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_909;
import net.minecraft.class_918;
import net.minecraft.class_970;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.processing.AnimationProcessor;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.RenderUtil;

public class GeoArmorRenderer<T extends class_1792, R extends class_10034>
extends class_572
implements GeoRenderer<T, RenderData, R> {
    protected final GeoRenderLayersContainer<T, RenderData, R> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();
    protected BakedGeoModel lastModel = null;
    protected GeoBone headBone = null;
    protected GeoBone bodyBone = null;
    protected GeoBone rightArmBone = null;
    protected GeoBone leftArmBone = null;
    protected GeoBone rightLegBone = null;
    protected GeoBone leftLegBone = null;
    protected GeoBone rightBootBone = null;
    protected GeoBone leftBootBone = null;

    public GeoArmorRenderer(GeoModel<T> model) {
        super(class_310.method_1551().method_31974().method_32072(class_5602.field_27579));
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public List<GeoRenderLayer<T, RenderData, R>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoArmorRenderer<T, R> addRenderLayer(GeoRenderLayer<T, RenderData, R> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoArmorRenderer<T, R> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoArmorRenderer<T, R> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    @ApiStatus.Internal
    public long getInstanceId(T animatable, RenderData stackAndSlot) {
        long stackId = GeoItem.getId(stackAndSlot.itemStack());
        if (stackId == Long.MAX_VALUE) {
            int id = stackAndSlot.entity().method_5628() * 13;
            return (long)id * (long)id * (long)id * (long)(-(stackAndSlot.slot().ordinal() + 1));
        }
        return -stackId;
    }

    @Override
    public int getRenderColor(T animatable, RenderData stackAndSlot, float partialTick) {
        return GeckoLibServices.Client.ITEM_RENDERING.getDyedItemColor(stackAndSlot.itemStack(), -1);
    }

    @Override
    @Nullable
    public class_1921 getRenderType(R renderState, class_2960 texture) {
        return class_1921.method_25448((class_2960)texture);
    }

    @Override
    @ApiStatus.Internal
    public R captureDefaultRenderState(T animatable, RenderData renderData, R renderState, float partialTick) {
        GeoRenderer.super.captureDefaultRenderState(animatable, renderData, renderState, partialTick);
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.IS_GECKOLIB_WEARER, renderData.entity() instanceof GeoAnimatable);
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.EQUIPMENT_SLOT, renderData.slot());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.HAS_GLINT, renderData.itemStack().method_7958());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.INVISIBLE_TO_PLAYER, ((class_10034)renderState).field_53461);
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.IS_GLOWING, ((class_10034)renderState).field_53462);
        return renderState;
    }

    @Override
    public void preRender(R renderState, class_4587 poseStack, BakedGeoModel model, @Nullable class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (!isReRender) {
            this.entityRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            this.applyBaseTransformations(((GeoRenderState)renderState).getGeckolibData(DataTickets.HUMANOID_MODEL));
            this.applyBaseModel(((GeoRenderState)renderState).getGeckolibData(DataTickets.HUMANOID_MODEL));
            this.grabRelevantBones(model);
            if (!((GeoRenderState)renderState).getGeckolibData(DataTickets.IS_GECKOLIB_WEARER).booleanValue()) {
                this.applyBoneVisibilityBySlot(((GeoRenderState)renderState).getGeckolibData(DataTickets.EQUIPMENT_SLOT));
            }
        }
    }

    @Override
    public void scaleModelForRender(R renderState, float widthScale, float heightScale, class_4587 poseStack, BakedGeoModel model, boolean isReRender) {
        GeoRenderer.super.scaleModelForRender(renderState, widthScale * this.scaleWidth, heightScale * this.scaleHeight, poseStack, model, isReRender);
    }

    @ApiStatus.Internal
    public final void method_62100(class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, int renderColor) {
        GeckoLibConstants.LOGGER.debug("Something is attempting to directly call HumanoidModel#renderToBuffer. This is not supported by GeoArmorRenderer.");
    }

    @Override
    public void actuallyRender(R renderState, class_4587 poseStack, BakedGeoModel model, @Nullable class_1921 renderType, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 1.5f, 0.0f);
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        if (!isReRender) {
            this.getGeoModel().handleAnimations(this.createAnimationState((GeoRenderState)renderState));
        }
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        if (buffer != null) {
            GeoRenderer.super.actuallyRender(renderState, poseStack, model, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
        }
        poseStack.method_22909();
    }

    @Override
    public void renderRecursively(R renderState, class_4587 poseStack, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations));
        }
        GeoRenderer.super.renderRecursively(renderState, poseStack, bone, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
    }

    protected void grabRelevantBones(BakedGeoModel bakedModel) {
        if (this.lastModel == bakedModel) {
            return;
        }
        AnimationProcessor<T> animationProcessor = this.model.getAnimationProcessor();
        this.lastModel = bakedModel;
        this.headBone = animationProcessor.getBone("armorHead");
        this.bodyBone = animationProcessor.getBone("armorBody");
        this.rightArmBone = animationProcessor.getBone("armorRightArm");
        this.leftArmBone = animationProcessor.getBone("armorLeftArm");
        this.rightLegBone = animationProcessor.getBone("armorRightLeg");
        this.leftLegBone = animationProcessor.getBone("armorLeftLeg");
        this.rightBootBone = animationProcessor.getBone("armorRightBoot");
        this.leftBootBone = animationProcessor.getBone("armorLeftBoot");
    }

    protected void applyBaseModel(class_572<?> baseModel) {
        GeoArmorRenderer self = this;
        self.field_3398.field_3665 = baseModel.field_3398.field_3665;
        self.field_3394.field_3665 = baseModel.field_3394.field_3665;
        self.field_3391.field_3665 = baseModel.field_3391.field_3665;
        self.field_3401.field_3665 = baseModel.field_3401.field_3665;
        self.field_27433.field_3665 = baseModel.field_27433.field_3665;
        self.field_3392.field_3665 = baseModel.field_3392.field_3665;
        self.field_3397.field_3665 = baseModel.field_3397.field_3665;
    }

    protected void applyBoneVisibilityBySlot(class_1304 currentSlot) {
        this.setAllBonesVisible(false);
        switch (currentSlot) {
            case field_6169: {
                this.setBonesVisible(this.field_3398.field_3665, new GeoBone[]{this.headBone});
                break;
            }
            case field_6174: {
                this.setBonesVisible(this.field_3391.field_3665, new GeoBone[]{this.bodyBone, this.rightArmBone, this.leftArmBone});
                break;
            }
            case field_6172: {
                this.setBonesVisible(this.field_3392.field_3665, new GeoBone[]{this.rightLegBone, this.leftLegBone});
                break;
            }
            case field_6166: {
                this.setBonesVisible(this.field_3392.field_3665, new GeoBone[]{this.rightBootBone, this.leftBootBone});
                break;
            }
        }
    }

    public void applyBoneVisibilityByPart(class_1304 currentSlot, class_630 currentPart, class_572<?> model) {
        this.method_2805(false);
        currentPart.field_3665 = true;
        GeoBone bone = null;
        if (currentPart == model.field_3394 || currentPart == model.field_3398) {
            bone = this.headBone;
        } else if (currentPart == model.field_3391) {
            bone = this.bodyBone;
        } else if (currentPart == model.field_27433) {
            bone = this.leftArmBone;
        } else if (currentPart == model.field_3401) {
            bone = this.rightArmBone;
        } else if (currentPart == model.field_3397) {
            bone = currentSlot == class_1304.field_6166 ? this.leftBootBone : this.leftLegBone;
        } else if (currentPart == model.field_3392) {
            GeoBone geoBone = bone = currentSlot == class_1304.field_6166 ? this.rightBootBone : this.rightLegBone;
        }
        if (bone != null) {
            bone.setHidden(false);
        }
    }

    protected void applyBaseTransformations(class_572<?> baseModel) {
        if (this.headBone != null) {
            class_630 headPart = baseModel.field_3398;
            RenderUtil.matchModelPartRot(headPart, this.headBone);
            this.headBone.updatePosition(headPart.field_3657, -headPart.field_3656, headPart.field_3655);
        }
        if (this.bodyBone != null) {
            class_630 bodyPart = baseModel.field_3391;
            RenderUtil.matchModelPartRot(bodyPart, this.bodyBone);
            this.bodyBone.updatePosition(bodyPart.field_3657, -bodyPart.field_3656, bodyPart.field_3655);
        }
        if (this.rightArmBone != null) {
            class_630 rightArmPart = baseModel.field_3401;
            RenderUtil.matchModelPartRot(rightArmPart, this.rightArmBone);
            this.rightArmBone.updatePosition(rightArmPart.field_3657 + 5.0f, 2.0f - rightArmPart.field_3656, rightArmPart.field_3655);
        }
        if (this.leftArmBone != null) {
            class_630 leftArmPart = baseModel.field_27433;
            RenderUtil.matchModelPartRot(leftArmPart, this.leftArmBone);
            this.leftArmBone.updatePosition(leftArmPart.field_3657 - 5.0f, 2.0f - leftArmPart.field_3656, leftArmPart.field_3655);
        }
        if (this.rightLegBone != null) {
            class_630 rightLegPart = baseModel.field_3392;
            RenderUtil.matchModelPartRot(rightLegPart, this.rightLegBone);
            this.rightLegBone.updatePosition(rightLegPart.field_3657 + 2.0f, 12.0f - rightLegPart.field_3656, rightLegPart.field_3655);
            if (this.rightBootBone != null) {
                RenderUtil.matchModelPartRot(rightLegPart, this.rightBootBone);
                this.rightBootBone.updatePosition(rightLegPart.field_3657 + 2.0f, 12.0f - rightLegPart.field_3656, rightLegPart.field_3655);
            }
        }
        if (this.leftLegBone != null) {
            class_630 leftLegPart = baseModel.field_3397;
            RenderUtil.matchModelPartRot(leftLegPart, this.leftLegBone);
            this.leftLegBone.updatePosition(leftLegPart.field_3657 - 2.0f, 12.0f - leftLegPart.field_3656, leftLegPart.field_3655);
            if (this.leftBootBone != null) {
                RenderUtil.matchModelPartRot(leftLegPart, this.leftBootBone);
                this.leftBootBone.updatePosition(leftLegPart.field_3657 - 2.0f, 12.0f - leftLegPart.field_3656, leftLegPart.field_3655);
            }
        }
    }

    public void method_2805(boolean visible) {
        super.method_2805(visible);
        this.setAllBonesVisible(visible);
    }

    protected void setAllBonesVisible(boolean visible) {
        this.setBonesVisible(visible, new GeoBone[]{this.headBone, this.bodyBone, this.rightArmBone, this.leftArmBone, this.rightLegBone, this.leftLegBone, this.rightBootBone, this.leftBootBone});
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileArmorRenderLayers(this);
    }

    @Override
    public void fireCompileRenderStateEvent(T animatable, RenderData relatedObject, R renderState) {
        GeckoLibServices.Client.EVENTS.fireCompileArmorRenderState(this, renderState, animatable, relatedObject);
    }

    @Override
    public boolean firePreRenderEvent(R renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
        return GeckoLibServices.Client.EVENTS.fireArmorPreRender(this, renderState, poseStack, model, bufferSource);
    }

    @Override
    public void firePostRenderEvent(R renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource) {
        GeckoLibServices.Client.EVENTS.fireArmorPostRender(this, renderState, poseStack, model, bufferSource);
    }

    @ApiStatus.Internal
    public static <S extends class_10034, M extends class_572<S>, A extends class_572<S>> boolean tryRenderGeoArmorPiece(class_4587 poseStack, class_4597 bufferSource, S humanoidRenderState, class_1799 stack, class_1304 equipmentSlot, M parentModel, A baseModel, int packedLight, float netHeadYaw, float headPitch, BiConsumer<A, class_1304> partVisibilitySetter) {
        GeoRenderProvider renderProvider;
        if (!class_970.method_64081((class_1799)stack, (class_1304)equipmentSlot) || (renderProvider = GeoRenderProvider.of(stack)) == GeoRenderProvider.DEFAULT || !(humanoidRenderState instanceof GeoRenderState)) {
            return false;
        }
        GeoRenderState geoRenderState = (GeoRenderState)humanoidRenderState;
        GeoArmorRenderer<?, ?> armorRenderer = renderProvider.getGeoArmorRenderer(humanoidRenderState, stack, equipmentSlot, equipmentSlot == class_1304.field_6172 ? class_10186.class_10190.field_54126 : class_10186.class_10190.field_54125, baseModel);
        if (armorRenderer == null) {
            return false;
        }
        Reference2ObjectOpenHashMap existingRenderData = null;
        EnumMap perSlotData = geoRenderState.hasGeckolibData(DataTickets.PER_SLOT_RENDER_DATA) ? geoRenderState.getGeckolibData(DataTickets.PER_SLOT_RENDER_DATA) : null;
        geoRenderState.addGeckolibData(DataTickets.PACKED_LIGHT, packedLight);
        if (perSlotData != null && perSlotData.containsKey(equipmentSlot)) {
            Map<DataTicket<?>, Object> renderData = geoRenderState.getDataMap();
            existingRenderData = new Reference2ObjectOpenHashMap(renderData);
            renderData.clear();
            renderData.putAll((Map)perSlotData.get(equipmentSlot));
        }
        geoRenderState.addGeckolibData(DataTickets.HUMANOID_MODEL, baseModel);
        geoRenderState.addGeckolibData(DataTickets.PACKED_LIGHT, packedLight);
        parentModel.method_64254(baseModel);
        partVisibilitySetter.accept(baseModel, equipmentSlot);
        baseModel.method_64254(armorRenderer);
        class_1921 renderType = armorRenderer.getRenderType(humanoidRenderState, armorRenderer.getTextureLocation(geoRenderState));
        class_4588 buffer = renderType == null ? null : class_918.method_27952((class_4597)bufferSource, (class_1921)renderType, (boolean)geoRenderState.getGeckolibData(DataTickets.HAS_GLINT));
        armorRenderer.defaultRender(geoRenderState, poseStack, bufferSource, renderType, buffer);
        if (existingRenderData != null) {
            geoRenderState.getDataMap().clear();
            geoRenderState.getDataMap().putAll((Map<DataTicket<?>, Object>)existingRenderData);
        }
        return true;
    }

    @ApiStatus.Internal
    public static <R extends class_10034> void captureRenderStates(R baseRenderState, class_1309 entity, float partialTick) {
        EnumMap<class_1304, Pair<GeoArmorRenderer<?, ?>, class_1799>> relevantSlots = GeoArmorRenderer.getRelevantSlotsForRendering(entity);
        if (relevantSlots == null) {
            return;
        }
        EnumMap<class_1304, Reference2ObjectOpenHashMap> slotRenderData = new EnumMap<class_1304, Reference2ObjectOpenHashMap>(class_1304.class);
        Map<DataTicket<?>, Object> dataMap = ((GeoRenderState)baseRenderState).getDataMap();
        for (Map.Entry<class_1304, Pair<GeoArmorRenderer<?, ?>, class_1799>> entry : relevantSlots.entrySet()) {
            GeoArmorRenderer renderer = (GeoArmorRenderer)entry.getValue().left();
            class_1799 stack = (class_1799)entry.getValue().right();
            RenderData renderData = new RenderData(stack, entry.getKey(), entity);
            renderer.fillRenderState((GeoAnimatable)stack.method_7909(), renderData, (GeoRenderState)baseRenderState, partialTick);
            slotRenderData.put(entry.getKey(), new Reference2ObjectOpenHashMap(dataMap));
            dataMap.clear();
        }
        ((GeoRenderState)baseRenderState).addGeckolibData(DataTickets.PER_SLOT_RENDER_DATA, slotRenderData);
    }

    @Nullable
    @ApiStatus.Internal
    private static EnumMap<class_1304, Pair<GeoArmorRenderer<?, ?>, class_1799>> getRelevantSlotsForRendering(class_1309 entity) {
        EnumMap<class_1304, Pair> relevantSlots = null;
        for (class_1304 slot : new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166}) {
            GeoArmorRenderer<?, ?> geoArmorRenderer;
            GeoArmorRenderer<?, ?> renderer;
            GeoRenderProvider geoRenderProvider;
            class_1799 stack = class_909.method_65568((class_1309)entity, (class_1304)slot);
            if (stack.method_7960() || (geoRenderProvider = GeoRenderProvider.of(stack)) == GeoRenderProvider.DEFAULT) continue;
            GeoArmorRenderer<?, ?> geoArmorRenderer2 = geoRenderProvider.getGeoArmorRenderer(null, stack, slot, slot == class_1304.field_6172 ? class_10186.class_10190.field_54126 : class_10186.class_10190.field_54125, null);
            GeoArmorRenderer<?, ?> geoArmorRenderer3 = renderer = geoArmorRenderer2 instanceof GeoArmorRenderer ? (geoArmorRenderer = geoArmorRenderer2) : null;
            if (renderer == null) continue;
            if (relevantSlots == null) {
                relevantSlots = new EnumMap<class_1304, Pair>(class_1304.class);
            }
            relevantSlots.put(slot, Pair.of(renderer, (Object)stack));
        }
        return relevantSlots;
    }

    public record RenderData(class_1799 itemStack, class_1304 slot, class_1309 entity) {
    }
}

