/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.base;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.constant.dataticket.DataTicket;

public interface GeoRenderState {
    public <D> void addGeckolibData(DataTicket<D> var1, @Nullable D var2);

    public boolean hasGeckolibData(DataTicket<?> var1);

    @Nullable
    public <D> D getGeckolibData(DataTicket<D> var1);

    @Nullable
    default public <D> D getOrDefaultGeckolibData(DataTicket<D> dataTicket, @Nullable D defaultValue) {
        D data = this.getGeckolibData(dataTicket);
        return data != null || this.hasGeckolibData(dataTicket) ? data : defaultValue;
    }

    @ApiStatus.Internal
    public Map<DataTicket<?>, Object> getDataMap();

    @ApiStatus.Internal
    public record Impl(Map<DataTicket<?>, Object> data) implements GeoRenderState
    {
        public Impl() {
            this((Map<DataTicket<?>, Object>)new Reference2ObjectOpenHashMap());
        }

        @Override
        public <D> void addGeckolibData(DataTicket<D> dataTicket, @Nullable D data) {
            this.data.put(dataTicket, data);
        }

        @Override
        public boolean hasGeckolibData(DataTicket<?> dataTicket) {
            return this.data.containsKey(dataTicket);
        }

        @Override
        @Nullable
        public <D> D getGeckolibData(DataTicket<D> dataTicket) {
            Object data = this.data.get(dataTicket);
            if (data == null && !this.hasGeckolibData(dataTicket)) {
                throw new IllegalArgumentException("Attempted to retrieve data from GeoRenderState that does not exist. Check your code!");
            }
            try {
                return (D)data;
            }
            catch (ClassCastException ex) {
                GeckoLibConstants.LOGGER.error("Attempted to retrieve incorrectly typed data from GeoRenderState. Possibly a mod or DataTicket conflict? Expected: {}, found data type {}", dataTicket, (Object)data.getClass().getName(), (Object)ex);
                throw ex;
            }
        }

        @Override
        @Nullable
        public <D> D getOrDefaultGeckolibData(DataTicket<D> dataTicket, @Nullable D defaultValue) {
            Object data = this.data.get(dataTicket);
            if (data == null && !this.hasGeckolibData(dataTicket)) {
                return defaultValue;
            }
            try {
                return (D)data;
            }
            catch (ClassCastException ex) {
                GeckoLibConstants.LOGGER.error("Attempted to retrieve incorrectly typed data from GeoRenderState. Possibly a mod or DataTicket conflict? Expected: {}, found data type {}", dataTicket, (Object)data.getClass().getName(), (Object)ex);
                return defaultValue;
            }
        }

        @Override
        @ApiStatus.Internal
        public Map<DataTicket<?>, Object> getDataMap() {
            return this.data;
        }
    }
}

