/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_10017;
import net.minecraft.class_10799;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.TextureLayerGeoLayer;
import software.bernie.geckolib.util.RenderUtil;

public class AutoGlowingGeoLayer<T extends GeoAnimatable, O, R extends GeoRenderState>
extends TextureLayerGeoLayer<T, O, R> {
    private final Map<class_2960, class_2960> emissiveResourceCache = new Object2ObjectOpenHashMap();
    protected static final RenderPipeline RENDER_PIPELINE = class_10799.method_67887((RenderPipeline)EmissiveRenderType.createRenderPipeline());

    public AutoGlowingGeoLayer(GeoRenderer<T, O, R> renderer) {
        super(renderer);
    }

    @Override
    protected class_2960 getTextureResource(R renderState) {
        return this.emissiveResourceCache.computeIfAbsent(this.renderer.getTextureLocation(renderState), RenderUtil::getEmissiveResource);
    }

    protected boolean shouldRespectWorldLighting(R renderState) {
        return false;
    }

    protected boolean shouldAddZOffset(R renderState) {
        return this.getRenderer() instanceof GeoArmorRenderer;
    }

    protected int getBrightness(R renderState) {
        return 0xF00000;
    }

    @Override
    @Nullable
    protected class_1921 getRenderType(R renderState) {
        class_2960 texture = this.getTextureResource(renderState);
        boolean respectLighting = this.shouldRespectWorldLighting(renderState);
        boolean zOffset = this.shouldAddZOffset(renderState);
        if (!(renderState instanceof class_10017)) {
            return EmissiveRenderType.getRenderType(texture, false, respectLighting, zOffset);
        }
        class_10017 entityRenderState = (class_10017)renderState;
        boolean invisible = entityRenderState.field_53333;
        if (invisible && !renderState.getOrDefaultGeckolibData(DataTickets.INVISIBLE_TO_PLAYER, false).booleanValue()) {
            return class_1921.method_29379((class_2960)texture);
        }
        if (renderState.getOrDefaultGeckolibData(DataTickets.IS_GLOWING, false).booleanValue()) {
            if (invisible) {
                return class_1921.method_23287((class_2960)texture);
            }
            return EmissiveRenderType.getRenderType(texture, true, respectLighting, zOffset);
        }
        return invisible ? null : EmissiveRenderType.getRenderType(texture, false, respectLighting, zOffset);
    }

    @Override
    public void render(R renderState, class_4587 poseStack, BakedGeoModel bakedModel, @Nullable class_1921 renderType, class_4597 bufferSource, @Nullable class_4588 buffer, int packedLight, int packedOverlay, int renderColor) {
        super.render(renderState, poseStack, bakedModel, renderType, bufferSource, buffer, this.getBrightness(renderState), packedOverlay, renderColor);
    }

    public static class EmissiveRenderType {
        private static final Map<Entry, class_1921> CACHE = new ConcurrentHashMap<Entry, class_1921>();

        public static class_1921 getRenderType(class_2960 texture, boolean outline, boolean respectLighting, boolean zOffset) {
            return CACHE.computeIfAbsent(new Entry(texture, outline, respectLighting, zOffset), EmissiveRenderType::buildNewInstance);
        }

        private static RenderPipeline createRenderPipeline() {
            return RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_60128}).withLocation(GeckoLibConstants.id("pipeline/emissive")).withVertexShader("core/entity").withFragmentShader("core/entity").withShaderDefine("EMISSIVE").withShaderDefine("NO_OVERLAY").withShaderDefine("NO_CARDINAL_LIGHTING").withSampler("Sampler0").withBlend(BlendFunction.TRANSLUCENT).withDepthWrite(false).withCull(false).withVertexFormat(class_290.field_1580, VertexFormat.class_5596.field_27382).build();
        }

        private static class_1921 buildNewInstance(Entry entry) {
            class_1921.class_4688.class_4689 compositeStateBuilder = class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(entry.texture, false)).method_23607(entry.zOffset ? class_1921.field_22241 : class_4668.field_21352);
            if (entry.respectLighting) {
                return class_1921.method_24049((String)"geckolib_entity_translucent_emissive", (int)1536, (boolean)true, (boolean)true, (RenderPipeline)class_10799.field_56907, (class_1921.class_4688)compositeStateBuilder.method_23611(class_1921.field_21385).method_23617(entry.outline));
            }
            return class_1921.method_24049((String)"geckolib_emissive", (int)1536, (boolean)false, (boolean)true, (RenderPipeline)RENDER_PIPELINE, (class_1921.class_4688)compositeStateBuilder.method_23617(entry.outline));
        }

        public record Entry(class_2960 texture, boolean outline, boolean respectLighting, boolean zOffset) {
            @Override
            public int hashCode() {
                return Objects.hash(this.texture, this.outline, this.respectLighting, this.zOffset);
            }
        }
    }
}

