/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.monster;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import fuzs.eternalnether.init.ModRegistry;
import fuzs.eternalnether.init.ModSoundEvents;
import fuzs.eternalnether.init.ModTags;
import fuzs.puzzleslib.api.network.v4.codec.ExtraStreamCodecs;
import fuzs.puzzleslib.api.util.v1.CodecExtras;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.class_10179;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1559;
import net.minecraft.class_1560;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5147;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class WarpedEnderman
extends class_1560
implements class_5147 {
    private static final Map<class_3414, class_3414> SOUND_EVENTS = ImmutableMap.of((Object)class_3417.field_14696, (Object)((class_3414)ModSoundEvents.WARPED_ENDERMAN_AMBIENT.comp_349()), (Object)class_3417.field_14608, (Object)((class_3414)ModSoundEvents.WARPED_ENDERMAN_DEATH.comp_349()), (Object)class_3417.field_14797, (Object)((class_3414)ModSoundEvents.WARPED_ENDERMAN_HURT.comp_349()), (Object)class_3417.field_14713, (Object)((class_3414)ModSoundEvents.WARPED_ENDERMAN_SCREAM.comp_349()), (Object)class_3417.field_14967, (Object)((class_3414)ModSoundEvents.WARPED_ENDERMAN_STARE.comp_349()), (Object)class_3417.field_14879, (Object)((class_3414)ModSoundEvents.WARPED_ENDERMAN_TELEPORT.comp_349()));
    private static final int SHEAR_COOLDOWN = 20;
    private static final class_2940<Variant> VARIANT_ID = class_2945.method_12791(WarpedEnderman.class, (class_2941)((class_2941)ModRegistry.WARPED_ENDER_MAN_VARIANT_ENTITY_DATA_SERIALIZER.comp_349()));
    private int shearCooldownCounter;

    public WarpedEnderman(class_1299<? extends class_1560> entityType, class_1937 level) {
        super(entityType, level);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 55.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 8.5).method_26868(class_5134.field_23717, 64.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT_ID, (Object)Variant.LONG_VINE);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0, 0.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1559.class, true, false));
        this.field_6185.method_6277(4, (class_1352)new class_5398((class_1308)this, false));
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_37908() instanceof class_3218 && this.shearCooldownCounter > 0) {
            --this.shearCooldownCounter;
        }
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 spawnGroupData) {
        class_1315 spawnGroupData1 = super.method_5943(level, difficulty, spawnReason, spawnGroupData);
        this.setVariant(Variant.random(this.field_5974));
        return spawnGroupData1;
    }

    public void method_5783(class_3414 event, float volume, float pitch) {
        super.method_5783(SOUND_EVENTS.getOrDefault(event, event), volume, pitch);
    }

    protected void method_5652(class_11372 valueOutput) {
        super.method_5652(valueOutput);
        valueOutput.method_71468("Variant", Variant.CODEC, (Object)this.getVariant());
    }

    protected void method_5749(class_11368 valueInput) {
        super.method_5749(valueInput);
        valueInput.method_71426("Variant", Variant.CODEC).ifPresent(this::setVariant);
    }

    public Variant getVariant() {
        return (Variant)((Object)this.field_6011.method_12789(VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(VARIANT_ID, (Object)variant);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 interactionResult) {
        class_1799 itemStack = player.method_5998(interactionResult);
        if (itemStack.method_31573(ModTags.SHEAR_TOOLS_ITEM_TAG_KEY) && this.method_27072()) {
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                this.method_6636(serverLevel, class_3419.field_15248, itemStack);
                this.method_32875((class_6880)class_5712.field_28730, (class_1297)player);
                itemStack.method_7970(1, (class_1309)player, WarpedEnderman.method_56079((class_1268)interactionResult));
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, interactionResult);
    }

    public void method_6636(class_3218 level, class_3419 soundSource, class_1799 shears) {
        level.method_43129(null, (class_1297)this, class_3417.field_14975, soundSource, 1.0f, 1.0f);
        this.method_61419(level, ModRegistry.SHEARING_WARPED_ENDER_MAN_LOOT_TABLE, shears, (serverLevel, itemStack) -> this.method_5699((class_3218)serverLevel, (class_1799)itemStack, this.method_5751()));
        this.shearCooldownCounter = 20;
        this.shearWarp(level);
    }

    private void shearWarp(class_3218 level) {
        switch (this.getVariant().ordinal()) {
            case 0: {
                this.method_29243(class_1299.field_6091, class_10179.method_63607((class_1308)this, (boolean)false, (boolean)false), enderMan -> level.method_65096((class_2394)class_2398.field_11236, this.method_23317(), this.method_23323(0.5), this.method_23321(), 1, 0.0, 0.0, 0.0, 0.0));
                break;
            }
            case 1: {
                this.setVariant(Variant.FRESH);
                break;
            }
            case 2: {
                this.setVariant(Variant.SHORT_VINE);
            }
        }
    }

    public boolean method_27072() {
        return this.method_5805() && this.shearCooldownCounter == 0;
    }

    public static enum Variant {
        FRESH,
        SHORT_VINE,
        LONG_VINE;

        public static final Codec<Variant> CODEC;
        public static final class_9139<ByteBuf, Variant> STREAM_CODEC;
        private static final Variant[] VALUES;

        public static Variant random(class_5819 random) {
            return VALUES[random.method_43048(VALUES.length)];
        }

        static {
            CODEC = CodecExtras.fromEnum(Variant.class);
            STREAM_CODEC = ExtraStreamCodecs.fromEnum(Variant.class);
            VALUES = Variant.values();
        }
    }
}

