/*
 * Decompiled with CFR 0.152.
 */
package me.drex.vanish.util;

import com.mojang.authlib.GameProfile;
import eu.pb4.playerdata.api.PlayerDataApi;
import eu.pb4.playerdata.api.storage.JsonDataStorage;
import eu.pb4.playerdata.api.storage.PlayerDataStorage;
import java.util.Collections;
import java.util.UUID;
import me.drex.vanish.api.VanishAPI;
import me.drex.vanish.api.VanishEvents;
import me.drex.vanish.config.ConfigManager;
import me.drex.vanish.util.VanishData;
import me.drex.vanish.util.VanishedEntity;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_7828;
import net.minecraft.server.MinecraftServer;

public class VanishManager {
    public static final PlayerDataStorage<VanishData> VANISH_DATA_STORAGE = new JsonDataStorage("vanish", VanishData.class);

    public static void init() {
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            if (ConfigManager.vanish().actionBar) {
                for (class_3222 player : server.method_3760().method_14571()) {
                    if (!VanishManager.isVanished((class_1297)player)) continue;
                    player.method_43502((class_2561)class_2561.method_43471((String)"text.vanish.general.vanished"), true);
                }
            }
        });
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((message, sender, params) -> {
            if (VanishManager.isVanished((class_1297)sender) && ConfigManager.vanish().disableChat) {
                sender.method_64398((class_2561)class_2561.method_43471((String)"text.vanish.chat.disabled").method_27692(class_124.field_1061));
                return false;
            }
            return true;
        });
        ServerMessageEvents.ALLOW_COMMAND_MESSAGE.register((message, source, params) -> {
            class_3222 sender = source.method_44023();
            if (sender != null) {
                if (VanishManager.isVanished((class_1297)sender) && ConfigManager.vanish().disableChat) {
                    sender.method_64398((class_2561)class_2561.method_43471((String)"text.vanish.chat.disabled").method_27692(class_124.field_1061));
                    return false;
                }
                return true;
            }
            return true;
        });
        PlayerDataApi.register(VANISH_DATA_STORAGE);
    }

    public static boolean isVanished(class_1297 entity) {
        if (entity instanceof VanishedEntity) {
            VanishedEntity vanishedEntity = (VanishedEntity)entity;
            return vanishedEntity.vanish$isVanished();
        }
        return false;
    }

    public static boolean isVanished(MinecraftServer server, UUID uuid) {
        VanishData data = (VanishData)PlayerDataApi.getCustomDataFor((MinecraftServer)server, (UUID)uuid, VANISH_DATA_STORAGE);
        return data != null && data.vanished;
    }

    public static boolean canViewVanished(class_2172 observer) {
        return Permissions.check((class_2172)observer, (String)"vanish.feature.view", (int)2);
    }

    public static boolean canSeePlayer(class_3222 actor, class_2168 observer) {
        if (VanishManager.isVanished((class_1297)actor)) {
            if (observer.method_9228() != null && actor.equals((Object)observer.method_9228())) {
                return true;
            }
            return VanishManager.canViewVanished((class_2172)observer);
        }
        return true;
    }

    public static boolean canSeePlayer(MinecraftServer server, UUID actor, class_2168 observer) {
        if (VanishManager.isVanished(server, actor)) {
            if (observer.method_9228() != null && actor.equals(observer.method_9228().method_5667())) {
                return true;
            }
            return VanishManager.canViewVanished((class_2172)observer);
        }
        return true;
    }

    public static boolean setVanished(GameProfile profile, MinecraftServer server, boolean vanish) {
        VanishData data;
        boolean isOnline;
        UUID uuid = profile.getId();
        if (VanishManager.isVanished(server, uuid) == vanish) {
            return false;
        }
        class_3222 player = server.method_3760().method_14602(uuid);
        boolean bl = isOnline = player != null;
        if (vanish && isOnline) {
            VanishManager.vanish(player);
        }
        if ((data = (VanishData)PlayerDataApi.getCustomDataFor((MinecraftServer)server, (UUID)uuid, VANISH_DATA_STORAGE)) == null) {
            data = new VanishData();
        }
        data.vanished = vanish;
        PlayerDataApi.setCustomDataFor((MinecraftServer)server, (UUID)uuid, VANISH_DATA_STORAGE, (Object)data);
        if (isOnline) {
            ((VanishedEntity)player).vanish$setDirty();
        }
        if (!vanish && isOnline) {
            VanishManager.unVanish(player);
        }
        if (isOnline) {
            server.method_3856();
            ((VanishEvents.VanishEvent)VanishEvents.VANISH_EVENT.invoker()).onVanish(player, vanish);
        }
        return true;
    }

    private static void unVanish(class_3222 actor) {
        class_3324 list = actor.method_51469().method_8503().method_3760();
        VanishManager.broadcastToOthers(actor, class_2703.method_43886(Collections.singletonList(actor)));
        if (ConfigManager.vanish().sendJoinDisconnectMessage) {
            list.method_43514(((VanishEvents.UnVanishMessageEvent)VanishEvents.UN_VANISH_MESSAGE_EVENT.invoker()).getUnVanishMessage(actor), false);
        }
    }

    private static void vanish(class_3222 actor) {
        class_3324 list = actor.method_51469().method_8503().method_3760();
        VanishManager.broadcastToOthers(actor, new class_7828(Collections.singletonList(actor.method_5667())));
        if (ConfigManager.vanish().sendJoinDisconnectMessage) {
            list.method_43514(((VanishEvents.VanishMessageEvent)VanishEvents.VANISH_MESSAGE_EVENT.invoker()).getVanishMessage(actor), false);
        }
    }

    private static void broadcastToOthers(class_3222 actor, class_2596<?> packet) {
        for (class_3222 observer : actor.method_51469().method_8503().method_3760().method_14571()) {
            if (VanishAPI.canViewVanished((class_2172)observer.method_64396()) || observer.equals((Object)actor)) continue;
            observer.field_13987.method_14364(packet);
        }
    }
}

