/*
 * Decompiled with CFR 0.152.
 */
package net.digitalpear.gipples_galore.common.datagens;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.digitalpear.gipples_galore.GipplesGalore;
import net.digitalpear.gipples_galore.common.blocks.GippleStackBlock;
import net.digitalpear.gipples_galore.common.blocks.jelly.JellyBlock;
import net.digitalpear.gipples_galore.init.GGBlocks;
import net.digitalpear.gipples_galore.init.GGItems;
import net.digitalpear.gipples_galore.init.data.sets.StoneSet;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_10795;
import net.minecraft.class_10804;
import net.minecraft.class_10806;
import net.minecraft.class_10821;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_807;
import net.minecraft.class_813;
import net.minecraft.class_815;

public class GGModelProvider
extends FabricModelProvider {
    public static final class_4942 JELLY_HALF_SIDE = new class_4942(Optional.of(GipplesGalore.id("block/jelly_half_side")), Optional.of("_half_side"), new class_4945[]{class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_27791});
    public static final class_4942 JELLY_HALF_UPPER = new class_4942(Optional.of(GipplesGalore.id("block/jelly_half_upper")), Optional.of("_half_upper"), new class_4945[]{class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_27791});
    public static final class_4942 JELLY_HALF_LOWER = new class_4942(Optional.of(GipplesGalore.id("block/jelly_half_lower")), Optional.of("_half_lower"), new class_4945[]{class_4945.field_23015, class_4945.field_23014, class_4945.field_23018, class_4945.field_27791});

    public GGModelProvider(FabricDataOutput output) {
        super(output);
    }

    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        this.registerGipplePad(blockStateModelGenerator);
        this.registerGelatinLayers(blockStateModelGenerator, GGBlocks.GELATIN_LAYER);
        this.registerAllJellies(blockStateModelGenerator);
        GGModelProvider.registerStoneSet(blockStateModelGenerator, GGBlocks.GELATITE_SET);
        GGModelProvider.registerStoneSet(blockStateModelGenerator, GGBlocks.GELATITE_BRICK_SET);
        GGModelProvider.registerStoneSet(blockStateModelGenerator, GGBlocks.AMOEBALITH_SET);
        GGModelProvider.registerStoneSet(blockStateModelGenerator, GGBlocks.AMOEBALITH_BRICK_SET);
        blockStateModelGenerator.method_25550(GGBlocks.HIBERNATING_GIPPLE, class_4944.method_25894((class_2248)GGBlocks.HIBERNATING_GIPPLE));
        blockStateModelGenerator.method_25622(GGBlocks.GELATIN_BLOCK, class_4946.method_25918(block -> new class_4944().method_25868(class_4945.field_23010, class_4944.method_25860((class_2248)GGBlocks.HIBERNATING_GIPPLE).method_48331("_top")), (class_4942)class_4943.field_22972));
        blockStateModelGenerator.method_25545(GGBlocks.GELATINOUS_GROWTH, GGBlocks.POTTED_GELATINOUS_GROWTH, class_4910.class_4913.field_22840);
        blockStateModelGenerator.method_25600(GGBlocks.GELATINOUS_GROWTH);
        this.registerGippleStack(blockStateModelGenerator, GGBlocks.GIPPLE_STACK);
    }

    public void generateItemModels(class_4915 itemModelGenerator) {
        GGItems.EGG_COLORS.forEach((item, integerIntegerPair) -> itemModelGenerator.method_65442(item, class_4943.field_22938));
        itemModelGenerator.method_65442(GGItems.GELATIN, class_4943.field_22938);
        itemModelGenerator.method_65442(GGItems.GAPPLE, class_4943.field_22938);
        itemModelGenerator.method_65442(GGItems.GIPPLE_BUCKET, class_4943.field_22938);
        itemModelGenerator.method_65442(GGItems.MUSIC_DISC_GIPPLECORE, class_4943.field_22938);
        itemModelGenerator.method_65442(GGItems.GIPPLE_BANNER_PATTERN, class_4943.field_22938);
    }

    private class_4942 getStackModel(class_2248 block, Integer height) {
        return new class_4942(Optional.of(class_4944.method_25866((class_2248)block, (String)("_" + height))), Optional.empty(), new class_4945[]{class_4945.field_23010});
    }

    public void registerGippleStack(class_4910 blockStateModelGenerator, class_2248 block) {
        class_4922 multipart = class_4922.method_25758((class_2248)block);
        for (int i = 1; i < 5; ++i) {
            class_807 model = class_4910.method_67835((class_2960)this.getStackModel(block, i).method_25847(block, "_layer_" + i, class_4944.method_25864((class_2248)block), blockStateModelGenerator.field_22831));
            for (class_2350 direction : class_2350.class_2353.field_11062.method_29716().toList()) {
                multipart.method_25761((class_815)new class_10806(class_10806.class_4920.field_22851, this.isAtHeightOrHigher(direction, i)), model.method_67929(modelVariant -> modelVariant.method_67939(class_10804.field_56937.withValue((Object)this.rotationOf(direction)))));
                if (i != 1 || direction != class_2350.field_11043) continue;
                blockStateModelGenerator.method_65399(block.method_8389(), class_4944.method_25866((class_2248)block, (String)("_layer_" + i)));
            }
        }
        blockStateModelGenerator.field_22830.accept(multipart);
    }

    private List<class_815> isAtHeightOrHigher(class_2350 direction, int value) {
        ArrayList<class_815> builders = new ArrayList<class_815>();
        for (int i = 4; i >= value; --i) {
            builders.add(new class_10795().method_67847((class_2769)GippleStackBlock.HEIGHT, (Comparable)Integer.valueOf(i)).method_67847((class_2769)GippleStackBlock.DIRECTIONS.get(value - 1), (Comparable)direction).method_67845());
        }
        return builders;
    }

    private void registerAllJellies(class_4910 blockStateModelGenerator) {
        for (class_2248 jelly : GGBlocks.JELLY.keySet()) {
            this.registerJelly(blockStateModelGenerator, jelly);
        }
    }

    private class_10821 rotationOf(class_2350 d) {
        return switch (d) {
            case class_2350.field_11034 -> class_10821.field_57030;
            case class_2350.field_11035 -> class_10821.field_57031;
            case class_2350.field_11039 -> class_10821.field_57032;
            default -> class_10821.field_57029;
        };
    }

    public void registerJelly(class_4910 blockStateModelGenerator, class_2248 block) {
        class_4944 horizontalMap = new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_side")).method_25868(class_4945.field_27791, class_4944.method_25866((class_2248)block, (String)"_inside")).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)block, (String)"_top")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)block, (String)"_bottom"));
        class_4944 verticalMap = new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_side")).method_25868(class_4945.field_27791, class_4944.method_25866((class_2248)block, (String)"_inside_vertical")).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)block, (String)"_top")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)block, (String)"_bottom"));
        class_807 half_side = class_4910.method_67835((class_2960)JELLY_HALF_SIDE.method_25846(block, horizontalMap, blockStateModelGenerator.field_22831));
        class_807 half_upper = class_4910.method_67835((class_2960)JELLY_HALF_UPPER.method_25846(block, verticalMap, blockStateModelGenerator.field_22831));
        class_807 half_lower = class_4910.method_67835((class_2960)JELLY_HALF_LOWER.method_25846(block, verticalMap, blockStateModelGenerator.field_22831));
        class_807 full = class_4910.method_67835((class_2960)class_4943.field_22977.method_25846(block, horizontalMap, blockStateModelGenerator.field_22831));
        class_4926.class_4928 stateMap = class_4926.method_67865((class_2769)class_2741.field_12525, (class_2769)JellyBlock.HALVED);
        for (class_2350 direction : class_2350.values()) {
            stateMap.method_25798((Comparable)direction, (Comparable)Boolean.FALSE, (Object)full);
            if (direction == class_2350.field_11033) {
                stateMap.method_25798((Comparable)direction, (Comparable)Boolean.TRUE, (Object)half_upper);
                continue;
            }
            if (direction == class_2350.field_11036) {
                stateMap.method_25798((Comparable)direction, (Comparable)Boolean.TRUE, (Object)half_lower);
                continue;
            }
            stateMap.method_25798((Comparable)direction, (Comparable)Boolean.TRUE, (Object)half_side.method_67929(class_10804.field_56937.withValue((Object)this.rotationOf(direction))));
        }
        blockStateModelGenerator.field_22830.accept(class_4925.method_67852((class_2248)block).method_67859((class_4926)stateMap));
    }

    private void registerGelatinLayers(class_4910 blockStateModelGenerator, class_2248 layerBlock) {
        class_807 weightedVariant = class_4910.method_67835((class_2960)class_4943.field_22972.method_25852(class_4941.method_25843((class_2248)layerBlock, (String)"_height16"), class_4944.method_25875((class_2960)GipplesGalore.id("block/gelatin")), blockStateModelGenerator.field_22831));
        blockStateModelGenerator.field_22830.accept(class_4925.method_67852((class_2248)layerBlock).method_67859(class_4926.method_67864((class_2769)class_2741.field_12536).method_25795(integer -> {
            class_807 var2 = integer < 8 ? class_4910.method_67835((class_2960)class_4941.method_25843((class_2248)layerBlock, (String)("_height" + integer * 2))) : weightedVariant;
            return var2;
        })));
        blockStateModelGenerator.method_25623(layerBlock, class_4941.method_25843((class_2248)layerBlock, (String)"_height2"));
    }

    private void registerGipplePad(class_4910 blockStateModelGenerator) {
        blockStateModelGenerator.method_25600(GGBlocks.GIPPLEPAD);
        class_813 modelVariant = class_4910.method_67806((class_2960)class_4941.method_25842((class_2248)class_2246.field_10588));
        blockStateModelGenerator.field_22830.accept(class_4925.method_67853((class_2248)GGBlocks.GIPPLEPAD, (class_807)class_4910.method_67839((class_813)modelVariant)));
    }

    public static void registerStoneSet(class_4910 blockStateModelGenerator, StoneSet stoneSet) {
        blockStateModelGenerator.method_25650(stoneSet.getBase()).method_33522(stoneSet.getBlockFamily());
    }
}

