/*
 * Decompiled with CFR 0.152.
 */
package net.digitalpear.gipples_galore.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.digitalpear.gipples_galore.GipplesGalore;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class EntitySpawnHelper {
    private static final Queue<SpawnRequest> QUEUE = new ConcurrentLinkedQueue<SpawnRequest>();

    public static void init() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            try {
                EntitySpawnHelper.processQueue();
            }
            catch (Exception e) {
                GipplesGalore.LOGGER.warn("Error while processing spawn queue: {}", (Object)e.toString());
            }
        });
    }

    public static void safeSpawnEntity(class_3218 world, class_1297 entity) {
        if (world == null || entity == null) {
            return;
        }
        try {
            QUEUE.add(new SpawnRequest(world, entity));
        }
        catch (Exception e) {
            GipplesGalore.LOGGER.warn("Failed to enqueue entity spawn: {}", (Object)e.toString());
        }
    }

    private static void processQueue() {
        SpawnRequest req;
        while ((req = QUEUE.poll()) != null) {
            try {
                class_3218 world = req.world;
                class_1297 entity = req.entity;
                if (world == null || entity == null || world.method_8608()) continue;
                class_2338 pos = entity.method_24515();
                boolean chunkLoaded = false;
                try {
                    chunkLoaded = world.method_22340(pos);
                }
                catch (NoSuchMethodError | UnsupportedOperationException throwable) {
                    // empty catch block
                }
                if (!chunkLoaded) continue;
                try {
                    world.method_8649(entity);
                }
                catch (Exception e) {
                    GipplesGalore.LOGGER.warn("Exception while spawning queued entity: {}", (Object)e.toString());
                }
            }
            catch (Exception e) {
                GipplesGalore.LOGGER.warn("Unexpected error handling spawn request: {}", (Object)e.toString());
            }
        }
    }

    private static class SpawnRequest {
        final class_3218 world;
        final class_1297 entity;

        SpawnRequest(class_3218 world, class_1297 entity) {
            this.world = world;
            this.entity = entity;
        }
    }
}

