/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterSettingsBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.ButtonStates;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterButton;
import com.tiviacz.travelersbackpack.network.ServerboundFilterSettingsPacket;
import com.tiviacz.travelersbackpack.network.ServerboundFilterTagsPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class FilterUpgradeWidgetBase<W extends FilterUpgradeWidgetBase<W, U>, U extends FilterUpgradeBase<U, ?>>
extends UpgradeWidgetBase<U> {
    private final WidgetElement tagIconElement;
    private final List<FilterButton<W>> buttons = new ArrayList<FilterButton<W>>();
    private int selectedTagIndex = 0;
    private List<String> addableTags;
    private List<String> tags;

    public FilterUpgradeWidgetBase(BackpackScreen screen, U upgrade, Point pos, Point tabUv, String upgradeIconTooltip) {
        super(screen, upgrade, pos, tabUv, upgradeIconTooltip);
        this.tagIconElement = new WidgetElement(new Point(pos.x() + 6 + 36, pos.y() + 22), new Point(18, 18));
        this.tags = ((FilterSettingsBase)((FilterUpgradeBase)upgrade).getFilterSettings()).getFilterTags();
        this.addableTags = new ArrayList<String>();
        ((FilterUpgradeBase)upgrade).addChangeListener(this::updateAddableTags);
    }

    public void addFilterButton(FilterButton<W> button) {
        if (((FilterUpgradeBase)this.upgrade).isTagSelector() && button.getButtonState() == ButtonStates.IGNORE_MODE) {
            button.setHidden(true);
        }
        if (!this.buttons.contains(button)) {
            this.buttons.add(button);
        }
    }

    public void hideButton(ButtonStates.ButtonState state, boolean hidden) {
        if (this.hasButton(state)) {
            this.getFilterButton(state).setHidden(hidden);
        }
    }

    public boolean hasButton(ButtonStates.ButtonState buttonState) {
        return this.buttons.stream().anyMatch(button -> button.getButtonState() == buttonState);
    }

    public FilterButton<W> getFilterButton(ButtonStates.ButtonState buttonState) {
        return this.buttons.stream().filter(button -> button.getButtonState() == buttonState).findFirst().orElseThrow(() -> new IllegalArgumentException("No filter button found for state: " + String.valueOf(buttonState)));
    }

    @Override
    public void renderBg(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (((FilterUpgradeBase)this.getUpgrade()).isTagSelector() && this.isTabOpened()) {
            guiGraphics.method_25290(class_10799.field_56883, BackpackScreen.TABS, this.pos.x(), this.pos.y(), 66.0f, 149.0f, 87, 103, 256, 256);
            guiGraphics.method_51427(((BackpackScreen)this.screen).getWrapper().getUpgrades().getStackInSlot(this.dataHolderSlot), this.pos.x() + 4, this.pos.y() + 4);
            int j = 0;
            int posX = this.pos.x() + 7;
            int posY = this.pos.y() + 44;
            int maxX = this.pos.x() + 7 + 73;
            int maxY = this.pos.y() + 44 + 52;
            for (String tag : this.getTags()) {
                if (++j >= 5) {
                    return;
                }
                guiGraphics.method_25290(class_10799.field_56883, BackpackScreen.TABS, this.pos.x() + 7, this.calculateTagBoxY(this.getTags().indexOf(tag)), 153.0f, 149.0f, 73, 13, 256, 256);
                guiGraphics.method_44379(posX, posY, maxX, maxY);
                guiGraphics.method_51433(((BackpackScreen)this.screen).method_64506(), this.getTrimmedText(tag), this.pos.x() + 9, this.calculateTagBoxY(this.getTags().indexOf(tag)) + 3, -1, false);
                guiGraphics.method_44380();
            }
        } else {
            super.renderBg(guiGraphics, x, y, mouseX, mouseY);
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.method_25290(class_10799.field_56883, BackpackScreen.ICONS, this.tagIconElement.pos().x(), this.tagIconElement.pos().y(), 0.0f, 186.0f, this.tagIconElement.size().x(), this.tagIconElement.size().y(), 256, 256);
        if (this.isTabOpened()) {
            if (((FilterUpgradeBase)this.upgrade).isTagSelector()) {
                if (!((FilterUpgradeBase)this.upgrade).getFirstFilterStack().method_7960()) {
                    guiGraphics.method_25290(class_10799.field_56883, BackpackScreen.ICONS, this.tagIconElement.pos().x(), this.tagIconElement.pos().y(), 186.0f, 36.0f, this.tagIconElement.size().x(), this.tagIconElement.size().y(), 256, 256);
                } else {
                    guiGraphics.method_25290(class_10799.field_56883, BackpackScreen.ICONS, this.tagIconElement.pos().x(), this.tagIconElement.pos().y(), 186.0f, 0.0f, this.tagIconElement.size().x(), this.tagIconElement.size().y(), 256, 256);
                }
            }
            this.buttons.forEach(button -> button.renderButton(guiGraphics, mouseX, mouseY));
        }
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isTabOpened() && ((FilterUpgradeBase)this.getUpgrade()).isTagSelector() && this.isMouseOverTags(mouseX, mouseY)) {
            guiGraphics.method_64038(((BackpackScreen)this.screen).method_64506(), this.getTooltip(), Optional.empty(), mouseX, mouseY);
        }
    }

    public void updateAddableTags() {
        this.selectedTagIndex = 0;
        this.addableTags = ((FilterSettingsBase)((FilterUpgradeBase)this.upgrade).getFilterSettings()).getAddableTags();
    }

    public boolean isAdding() {
        return !((FilterUpgradeBase)this.upgrade).getFirstFilterStack().method_7960();
    }

    public int getSelectedTagIndex() {
        return this.selectedTagIndex;
    }

    public void setNextSelectedTagIndex(double mouse) {
        if (mouse < 0.0 && this.selectedTagIndex + 1 < this.getTags().size()) {
            ++this.selectedTagIndex;
        } else if (mouse > 0.0 && this.selectedTagIndex - 1 >= 0) {
            --this.selectedTagIndex;
        }
    }

    public List<String> getTags() {
        if (this.isAdding()) {
            return this.addableTags;
        }
        return this.tags;
    }

    public boolean addTag() {
        ArrayList<String> itemTags = new ArrayList<String>(this.addableTags);
        if (itemTags.isEmpty()) {
            return false;
        }
        int selected = this.getSelectedTagIndex();
        String tag = (String)itemTags.get(selected);
        itemTags.remove(tag);
        this.selectedTagIndex = Math.min(selected, itemTags.size() - 1);
        this.addableTags = itemTags;
        this.tags.add(tag);
        return true;
    }

    public boolean removeTag() {
        ArrayList<String> storedTags = new ArrayList<String>(this.tags);
        if (storedTags.isEmpty()) {
            return false;
        }
        int selected = this.getSelectedTagIndex();
        storedTags.remove(selected);
        this.selectedTagIndex = Math.max(0, Math.min(selected, storedTags.size() - 1));
        this.tags = storedTags;
        return true;
    }

    public List<class_2561> getTooltip() {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        boolean isAdding = this.isAdding();
        ArrayList<String> displayedTags = isAdding ? new ArrayList<String>(this.addableTags) : new ArrayList<String>(this.tags);
        displayedTags.forEach(t -> tooltip.add((class_2561)class_2561.method_43470((String)t).method_27692(class_124.field_1080)));
        if (tooltip.isEmpty()) {
            return List.of(class_2561.method_43471((String)"screen.travelersbackpack.filter_tag_empty").method_27692(class_124.field_1063));
        }
        class_124 cursorColor = isAdding ? class_124.field_1060 : class_124.field_1061;
        String selectedTagString = (String)displayedTags.get(this.getSelectedTagIndex());
        class_5250 selectedTag = class_2561.method_43470((String)("> " + selectedTagString)).method_27692(cursorColor);
        tooltip.set(this.getSelectedTagIndex(), (class_2561)selectedTag);
        tooltip.add((class_2561)class_2561.method_43471((String)(isAdding ? "screen.travelersbackpack.filter_tag_add" : "screen.travelersbackpack.filter_tag_remove")).method_27692(class_124.field_1078));
        return tooltip;
    }

    public int calculateTagBoxY(int index) {
        return this.pos.y() + 44 + 13 * index;
    }

    public String getTrimmedText(String tag) {
        class_327 font = ((BackpackScreen)this.screen).method_64506();
        int maxWidth = 70;
        Object displayText = tag;
        if (font.method_1727(tag) > maxWidth) {
            int i;
            String ellipsis = "...";
            int ellipsisWidth = font.method_1727(ellipsis);
            int availableWidth = maxWidth - ellipsisWidth;
            for (i = tag.length(); i > 0 && font.method_1727(tag.substring(0, i)) > availableWidth; --i) {
            }
            displayText = tag.substring(0, i) + ellipsis;
        }
        return displayText;
    }

    public boolean isMouseOverTags(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, new Point(9, this.calculateTagBoxY(0) - this.pos.y()), new Point(73, 52));
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isTabOpened() && ((FilterUpgradeBase)this.upgrade).isTagSelector() && this.isMouseOverTags(mouseX, mouseY)) {
            this.setNextSelectedTagIndex(scrollY);
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.isTabOpened() && this.isBackpackOwner()) {
            for (FilterButton<W> button : this.buttons) {
                if (!button.mouseClicked(pMouseX, pMouseY, pButton)) continue;
                if (this.hasButton(ButtonStates.OBJECT_TYPE) && this.getFilterButton(ButtonStates.OBJECT_TYPE).getCurrentState() == 2) {
                    if (this.hasButton(ButtonStates.ALLOW) && this.getFilterButton(ButtonStates.ALLOW).getCurrentState() == 2) {
                        this.getFilterButton(ButtonStates.ALLOW).nextState();
                    }
                    this.hideButton(ButtonStates.IGNORE_MODE, true);
                } else {
                    this.hideButton(ButtonStates.IGNORE_MODE, false);
                }
                PacketDistributor.sendToServer(new ServerboundFilterSettingsPacket(this.dataHolderSlot, List.of(Integer.valueOf(this.buttons.get(0).getCurrentState()), Integer.valueOf(this.buttons.get(1).getCurrentState()), Integer.valueOf(this.buttons.get(2).getCurrentState()))));
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
            if (this.isMouseOverTags(pMouseX, pMouseY) && ((FilterUpgradeBase)this.getUpgrade()).isTagSelector()) {
                if (this.isAdding() ? !this.addTag() : !this.removeTag()) {
                    return false;
                }
                PacketDistributor.sendToServer(new ServerboundFilterTagsPacket(this.dataHolderSlot, this.tags));
                ((FilterSettingsBase)((FilterUpgradeBase)this.getUpgrade()).getFilterSettings()).updateFilterTags(this.tags);
                return true;
            }
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }
}

