/*
 * Decompiled with CFR 0.152.
 */
package de.mschae23.grindenchantments;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.mschae23.config.api.ConfigIo;
import de.mschae23.config.api.ModConfig;
import de.mschae23.config.api.exception.ConfigException;
import de.mschae23.grindenchantments.GrindEnchantmentsClient;
import de.mschae23.grindenchantments.config.ClientConfig;
import de.mschae23.grindenchantments.config.ServerConfig;
import de.mschae23.grindenchantments.config.legacy.v1.GrindEnchantmentsConfigV1;
import de.mschae23.grindenchantments.config.legacy.v2.GrindEnchantmentsConfigV2;
import de.mschae23.grindenchantments.config.legacy.v3.GrindEnchantmentsConfigV3;
import de.mschae23.grindenchantments.config.sync.ServerConfigS2CPayload;
import de.mschae23.grindenchantments.cost.CostFunction;
import de.mschae23.grindenchantments.cost.CostFunctionType;
import de.mschae23.grindenchantments.event.ApplyLevelCostEvent;
import de.mschae23.grindenchantments.event.GrindstoneEvents;
import de.mschae23.grindenchantments.impl.DisenchantOperation;
import de.mschae23.grindenchantments.impl.MoveOperation;
import de.mschae23.grindenchantments.impl.ResetRepairCostOperation;
import de.mschae23.grindenchantments.registry.GrindEnchantmentsRegistries;
import io.github.fourmisain.taxfreelevels.TaxFreeLevels;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class GrindEnchantmentsMod
implements ModInitializer {
    public static final String MODID = "grindenchantments";
    public static final Logger LOGGER = LogManager.getLogger((String)"Grind Enchantments");
    @Nullable
    static ServerConfig SERVER_CONFIG = null;
    static ServerConfig LOCAL_SERVER_CONFIG = ServerConfig.DEFAULT;

    public void onInitialize() {
        GrindEnchantmentsRegistries.init();
        CostFunctionType.init();
        GrindEnchantmentsMod.convertLegacyConfig();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            SERVER_CONFIG = GrindEnchantmentsMod.initializeServerConfig((class_7225.class_7874)server.method_30611());
            SERVER_CONFIG.validateRegistryEntries((class_7225.class_7874)server.method_30611());
            LOCAL_SERVER_CONFIG = SERVER_CONFIG;
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            SERVER_CONFIG = null;
        });
        PayloadTypeRegistry.configurationS2C().register(ServerConfigS2CPayload.ID, ServerConfigS2CPayload.createPacketCodec(CostFunction.createPacketCodec()));
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, ServerConfigS2CPayload.ID)) {
                ServerConfigurationNetworking.send((class_8610)handler, (class_8710)new ServerConfigS2CPayload(SERVER_CONFIG != null ? SERVER_CONFIG : LOCAL_SERVER_CONFIG));
            }
        });
        DisenchantOperation disenchant = new DisenchantOperation();
        MoveOperation move = new MoveOperation();
        ResetRepairCostOperation resetRepairCost = new ResetRepairCostOperation();
        GrindstoneEvents.registerAll(disenchant);
        GrindstoneEvents.registerAll(move);
        GrindstoneEvents.registerAll(resetRepairCost);
        ApplyLevelCostEvent.EVENT.register(ApplyLevelCostEvent.DEFAULT, (cost, player) -> {
            player.method_7316(-cost);
            return true;
        });
        if (FabricLoader.getInstance().isModLoaded("taxfreelevels")) {
            ApplyLevelCostEvent.EVENT.register(ApplyLevelCostEvent.MOD_COMPATIBILITY, (cost, player) -> {
                TaxFreeLevels.applyFlattenedXpCost((class_1657)player, (int)cost);
                return true;
            });
        }
    }

    public static ServerConfig getServerConfig() {
        return SERVER_CONFIG == null ? (GrindEnchantmentsClient.getClientConfig().sync().useLocalIfUnsynced() ? LOCAL_SERVER_CONFIG : ServerConfig.DISABLED) : SERVER_CONFIG;
    }

    public static ClientConfig getClientConfig() {
        return GrindEnchantmentsClient.getClientConfig();
    }

    public static <C extends ModConfig<C>> ModConfig.Type<C, ? extends ModConfig<C>> getConfigType(ModConfig.Type<C, ? extends ModConfig<C>>[] versions, int version) {
        for (int i = versions.length - 1; i >= 0; --i) {
            ModConfig.Type<C, ? extends ModConfig<C>> v = versions[i];
            if (version != v.version()) continue;
            return v;
        }
        return versions[versions.length - 1];
    }

    private static <C extends ModConfig<C>> C initializeGenericConfig(Path configName, C latestDefault, Codec<ModConfig<C>> codec, DynamicOps<JsonElement> ops, String kind) {
        Object latestConfig;
        block39: {
            Path filePath = FabricLoader.getInstance().getConfigDir().resolve(MODID).resolve(configName);
            latestConfig = latestDefault;
            if (Files.exists(filePath, new LinkOption[0]) && Files.isRegularFile(filePath, new LinkOption[0])) {
                try (InputStream input = Files.newInputStream(filePath, new OpenOption[0]);){
                    GrindEnchantmentsMod.log(Level.INFO, "Reading " + kind + " config.");
                    ModConfig config = ConfigIo.decodeConfig((InputStream)input, codec, ops);
                    latestConfig = config.latest();
                    if (!config.shouldUpdate() || config.version() >= latestDefault.version()) break block39;
                    try (OutputStream output = Files.newOutputStream(filePath, new OpenOption[0]);
                         OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(output));){
                        GrindEnchantmentsMod.log(Level.INFO, "Writing updated " + kind + " config.");
                        ConfigIo.encodeConfig((Writer)writer, codec, (ModConfig)config.latest(), ops);
                    }
                    catch (IOException e) {
                        GrindEnchantmentsMod.log(Level.ERROR, "IO exception while trying to write updated " + kind + " config: " + e.getLocalizedMessage());
                    }
                    catch (ConfigException e) {
                        GrindEnchantmentsMod.log(Level.ERROR, e.getLocalizedMessage());
                    }
                }
                catch (IOException e) {
                    GrindEnchantmentsMod.log(Level.ERROR, "IO exception while trying to read " + kind + " config: " + e.getLocalizedMessage());
                }
                catch (ConfigException e) {
                    GrindEnchantmentsMod.log(Level.ERROR, e.getLocalizedMessage());
                }
            } else {
                try {
                    Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                    try (OutputStream output = Files.newOutputStream(filePath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                         OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(output));){
                        GrindEnchantmentsMod.log(Level.INFO, "Writing default " + kind + " config.");
                        ConfigIo.encodeConfig((Writer)writer, codec, latestDefault, ops);
                    }
                }
                catch (IOException e) {
                    GrindEnchantmentsMod.log(Level.ERROR, "IO exception while trying to write " + kind + " config: " + e.getLocalizedMessage());
                }
                catch (ConfigException e) {
                    GrindEnchantmentsMod.log(Level.ERROR, e.getLocalizedMessage());
                }
            }
        }
        return latestConfig;
    }

    public static ClientConfig initializeClientConfig() {
        return GrindEnchantmentsMod.initializeGenericConfig(Path.of("client.json", new String[0]), ClientConfig.DEFAULT, ClientConfig.CODEC, (DynamicOps<JsonElement>)JsonOps.INSTANCE, "client");
    }

    public static ServerConfig initializeServerConfig(class_7225.class_7874 wrapperLookup) {
        return GrindEnchantmentsMod.initializeGenericConfig(Path.of("server.json", new String[0]), ServerConfig.DEFAULT, ServerConfig.CODEC, (DynamicOps<JsonElement>)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)wrapperLookup), "server");
    }

    private static void convertLegacyConfig() {
        class_7225.class_7874 wrapperLookup;
        Optional<GrindEnchantmentsConfigV3> legacyConfigOpt;
        Path newConfigDirPath = FabricLoader.getInstance().getConfigDir().resolve(MODID);
        if (!Files.isDirectory(newConfigDirPath, new LinkOption[0]) && (legacyConfigOpt = GrindEnchantmentsMod.readLegacyConfig(wrapperLookup = class_7225.class_7874.method_46761(Stream.of(GrindEnchantmentsRegistries.COST_FUNCTION)))).isPresent()) {
            GrindEnchantmentsConfigV3 legacyConfig = legacyConfigOpt.get();
            ServerConfig serverConfig = legacyConfig.toServerConfig();
            ClientConfig clientConfig = legacyConfig.toClientConfig();
            try {
                OutputStreamWriter writer;
                OutputStream outputStream;
                Path serverConfigPath = newConfigDirPath.resolve("server.json");
                Path clientConfigPath = newConfigDirPath.resolve("client.json");
                Files.createDirectories(newConfigDirPath, new FileAttribute[0]);
                boolean success = true;
                try {
                    outputStream = Files.newOutputStream(serverConfigPath, new OpenOption[0]);
                    try {
                        writer = new OutputStreamWriter(new BufferedOutputStream(outputStream));
                        try {
                            GrindEnchantmentsMod.log(Level.INFO, "Writing converted server config.");
                            ConfigIo.encodeConfig((Writer)writer, ServerConfig.CODEC, (ModConfig)serverConfig, (DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)wrapperLookup));
                        }
                        finally {
                            writer.close();
                        }
                    }
                    finally {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                }
                catch (ConfigException e) {
                    GrindEnchantmentsMod.log(Level.ERROR, e.getLocalizedMessage());
                    success = false;
                }
                try {
                    outputStream = Files.newOutputStream(clientConfigPath, new OpenOption[0]);
                    try {
                        writer = new OutputStreamWriter(new BufferedOutputStream(outputStream));
                        try {
                            GrindEnchantmentsMod.log(Level.INFO, "Writing converted client config.");
                            ConfigIo.encodeConfig((Writer)writer, ClientConfig.CODEC, (ModConfig)clientConfig, (DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)wrapperLookup));
                        }
                        finally {
                            writer.close();
                        }
                    }
                    finally {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                }
                catch (ConfigException e) {
                    GrindEnchantmentsMod.log(Level.ERROR, e.getLocalizedMessage());
                    success = false;
                }
                if (success) {
                    Path configDir = FabricLoader.getInstance().getConfigDir();
                    Files.move(configDir.resolve("grindenchantments.json"), configDir.resolve("grindenchantments.json.old"), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                GrindEnchantmentsMod.log(Level.ERROR, "IO exception while trying to convert legacy config: " + e.getLocalizedMessage());
            }
        }
    }

    private static Optional<GrindEnchantmentsConfigV3> readLegacyConfig(class_7225.class_7874 wrapperLookup) {
        GrindEnchantmentsConfigV3 legacyLatestConfigDefault = GrindEnchantmentsConfigV3.DEFAULT;
        int legacyLatestConfigVersion = legacyLatestConfigDefault.version();
        ModConfig.Type[] legacyConfigCodecs = new ModConfig.Type[]{GrindEnchantmentsConfigV1.TYPE, GrindEnchantmentsConfigV2.TYPE, GrindEnchantmentsConfigV3.TYPE};
        Codec legacyConfigCodec = ModConfig.createCodec((int)legacyLatestConfigVersion, version -> GrindEnchantmentsMod.getConfigType(legacyConfigCodecs, version));
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve(Paths.get("grindenchantments.json", new String[0]));
        GrindEnchantmentsConfigV3 config = null;
        if (Files.exists(configPath, new LinkOption[0]) && Files.isRegularFile(configPath, new LinkOption[0])) {
            try (InputStream input = Files.newInputStream(configPath, new OpenOption[0]);){
                GrindEnchantmentsMod.log(Level.INFO, "Reading legacy config.");
                ModConfig readConfig = ConfigIo.decodeConfig((InputStream)input, (Codec)legacyConfigCodec, (DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)wrapperLookup));
                config = (GrindEnchantmentsConfigV3)readConfig.latest();
            }
            catch (IOException e) {
                GrindEnchantmentsMod.log(Level.ERROR, "IO exception while trying to read config: " + e.getLocalizedMessage());
            }
            catch (ConfigException e) {
                GrindEnchantmentsMod.log(Level.ERROR, e.getLocalizedMessage());
            }
        }
        return Optional.ofNullable(config);
    }

    public static void log(Level level, Object message) {
        LOGGER.log(level, "[Grind Enchantments] {}", message);
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MODID, (String)path);
    }
}

