/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.grave;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import eu.pb4.graves.config.BaseGson;
import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.config.data.WrappedText;
import eu.pb4.graves.grave.GraveManager;
import eu.pb4.graves.grave.GraveType;
import eu.pb4.graves.grave.PositionedItemStack;
import eu.pb4.graves.mixin.PlayerEntityAccessor;
import eu.pb4.graves.other.GraveUtils;
import eu.pb4.graves.other.ImplementedInventory;
import eu.pb4.graves.other.LegacyNbtHelper;
import eu.pb4.graves.other.Location;
import eu.pb4.graves.other.VanillaInventoryMask;
import eu.pb4.graves.other.VisualGraveData;
import eu.pb4.graves.registry.GraveBlockEntity;
import eu.pb4.graves.registry.GravesRegistry;
import eu.pb4.graves.ui.GraveGui;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Grave {
    public static final class_2561 DEFAULT_DEATH_CAUSE = class_2561.method_43470((String)"Unknown cause");
    public static final GameProfile DEFAULT_GAME_PROFILE = new GameProfile(UUID.fromString("9586e5ab-157a-4658-ad80-b07552a9ca63"), "Herobrine");
    public static final Grave SOMETHING_BROKE_AGAIN = new Grave();
    @Nullable
    private GameProfile gameProfile;
    private int xp;
    private long creationTime;
    private long gameCreationTime;
    private int itemCount;
    private class_2561 deathCause;
    private final Set<UUID> allowedUUIDs;
    private final class_2371<PositionedItemStack> items;
    private Location location;
    private GraveType type;
    private boolean isRemoved;
    private long id = -1L;
    private class_1306 mainArm = class_1306.field_6183;
    private byte skinModelParts = (byte)-1;
    private boolean requirePayment;
    private boolean utilProtectionChangeMessage;
    private boolean isProtectionEnabled;
    private VisualGraveData visualData;
    private int minecraftDay;
    private final Map<class_2960, List<PositionedItemStack>> taggedStacks = new HashMap<class_2960, List<PositionedItemStack>>();
    private boolean delayPlayerModel = false;

    public Grave() {
        this.requirePayment = !ConfigManager.getConfig().interactions.cost.isFree();
        this.gameProfile = DEFAULT_GAME_PROFILE;
        this.creationTime = Long.MAX_VALUE;
        this.xp = 0;
        this.itemCount = 0;
        this.deathCause = DEFAULT_DEATH_CAUSE;
        this.allowedUUIDs = new HashSet<UUID>();
        this.items = class_2371.method_10211();
        this.type = GraveType.VIRTUAL;
        this.location = new Location(class_3218.field_25179.method_29177(), class_2338.field_10980);
        this.utilProtectionChangeMessage = true;
        this.isProtectionEnabled = true;
        this.visualData = VisualGraveData.DEFAULT;
        this.minecraftDay = -1;
    }

    public Grave(long id, @Nullable GameProfile profile, byte visibleLayers, class_1306 arm, class_2338 position, class_2960 world, GraveType type, long creationTime, long gameCreationTime, int xp, class_2561 deathCause, Collection<UUID> allowedUUIDs, Collection<PositionedItemStack> itemStacks, boolean isProtectionEnabled, int minecraftDay) {
        this.requirePayment = !ConfigManager.getConfig().interactions.cost.isFree();
        this.gameProfile = profile;
        this.creationTime = creationTime;
        this.gameCreationTime = gameCreationTime;
        this.type = type;
        this.xp = xp;
        this.deathCause = deathCause;
        this.allowedUUIDs = new HashSet<UUID>(allowedUUIDs);
        this.location = new Location(world, position);
        this.items = class_2371.method_10212((Object)PositionedItemStack.EMPTY, (Object[])itemStacks.toArray(new PositionedItemStack[0]));
        this.utilProtectionChangeMessage = !this.isProtected();
        this.isProtectionEnabled = isProtectionEnabled;
        this.id = id;
        this.minecraftDay = minecraftDay;
        this.skinModelParts = visibleLayers;
        this.mainArm = arm;
        for (PositionedItemStack item : this.items) {
            this.addTaggedItem(item);
        }
        this.updateDisplay();
    }

    public boolean delayPlayerModel() {
        return this.delayPlayerModel;
    }

    private void addTaggedItem(PositionedItemStack item) {
        for (class_2960 tag : item.tags()) {
            this.taggedStacks.computeIfAbsent(tag, Grave::createList).add(item);
        }
    }

    private void removeTaggedItem(PositionedItemStack item) {
        for (class_2960 tag : item.tags()) {
            List<PositionedItemStack> stacks = this.taggedStacks.get(tag);
            if (stacks == null) continue;
            stacks.remove(item);
            if (!stacks.isEmpty()) continue;
            this.taggedStacks.remove(tag);
        }
    }

    private static List<PositionedItemStack> createList(class_2960 identifier) {
        return new ArrayList<PositionedItemStack>();
    }

    public static Grave createBlock(class_3222 player, class_2960 world, class_2338 position, int xp, class_2561 deathCause, Collection<UUID> allowedUUIDs, Collection<PositionedItemStack> itemStacks, int minecraftDay) {
        return new Grave(GraveManager.INSTANCE.requestId(), player.method_7334(), (Byte)player.method_5841().method_12789(PlayerEntityAccessor.getPLAYER_MODEL_PARTS()), player.method_6068(), position, world, GraveType.BLOCK, System.currentTimeMillis() / 1000L, GraveManager.INSTANCE.getCurrentGameTime(), xp, deathCause, allowedUUIDs, itemStacks, true, minecraftDay);
    }

    public class_2487 writeNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        if (this.gameProfile != null) {
            nbt.method_10566("GameProfile", (class_2520)LegacyNbtHelper.writeGameProfile(new class_2487(), this.gameProfile));
        }
        nbt.method_10544("Id", this.id);
        nbt.method_10569("XP", this.xp);
        nbt.method_10544("CreationTime", this.creationTime);
        nbt.method_10569("ItemCount", this.itemCount);
        nbt.method_10569("MinecraftDay", this.minecraftDay);
        nbt.method_10582("DeathCause", BaseGson.text(lookup).toJsonString(this.deathCause));
        nbt.method_10582("Type", this.type.name());
        nbt.method_10556("IsProtectionEnabled", this.isProtectionEnabled);
        nbt.method_10556("RequirePayment", this.requirePayment);
        this.location.writeData(nbt);
        class_2499 allowedUUIDs = new class_2499();
        for (UUID uuid : this.allowedUUIDs) {
            allowedUUIDs.add((Object)((class_2520)class_4844.field_46588.encodeStart((DynamicOps)class_2509.field_11560, (Object)uuid).getOrThrow()));
        }
        nbt.method_10566("AllowedUUIDs", (class_2520)allowedUUIDs);
        class_2499 items = new class_2499();
        for (PositionedItemStack item : this.items) {
            items.add((Object)item.toNbt(lookup));
        }
        nbt.method_10566("Items", (class_2520)items);
        nbt.method_10567("SkinModelParts", this.skinModelParts);
        nbt.method_10567("MainArm", (byte)this.mainArm.method_7362());
        return nbt;
    }

    public void readNbt(class_2487 nbt, class_7225.class_7874 lookup, DataFixer dataFixer, int dataVersion, int currentDataVersion) {
        try {
            this.id = nbt.method_10545("Id") ? nbt.method_68080("Id", -1L) : GraveManager.INSTANCE.requestId();
            this.gameProfile = LegacyNbtHelper.toGameProfile(nbt.method_68568("GameProfile"));
            this.xp = nbt.method_68083("XP", 0);
            this.creationTime = nbt.method_68080("CreationTime", 0L);
            this.itemCount = nbt.method_68083("ItemCount", 0);
            this.minecraftDay = nbt.method_68083("MinecraftDay", 0);
            this.deathCause = BaseGson.text(lookup).fromJson(nbt.method_68564("DeathCause", ""));
            this.location = Location.readData(nbt);
            this.allowedUUIDs.clear();
            this.requirePayment = nbt.method_68566("RequirePayment", false);
            this.type = nbt.method_10545("Type") ? GraveType.byName(nbt.method_68564("Type", "")) : GraveType.BLOCK;
            this.gameCreationTime = nbt.method_10545("TickCreationTime") ? nbt.method_68080("TickCreationTime", 0L) : GraveManager.INSTANCE.getCurrentGameTime();
            this.isProtectionEnabled = nbt.method_10545("IsProtectionEnabled") ? nbt.method_68566("IsProtectionEnabled", false) : true;
            for (class_2520 nbtUUID : nbt.method_68569("AllowedUUIDs")) {
                this.allowedUUIDs.add((UUID)((Pair)class_4844.field_40825.decode((DynamicOps)class_2509.field_11560, (Object)nbtUUID).getOrThrow()).getFirst());
            }
            for (class_2520 item : nbt.method_68569("Items")) {
                PositionedItemStack stack = PositionedItemStack.fromNbt((class_2487)item, lookup, dataFixer, dataVersion, currentDataVersion);
                this.items.add((Object)stack);
                this.addTaggedItem(stack);
            }
            if (nbt.method_10545("SkinModelParts")) {
                this.skinModelParts = nbt.method_68562("SkinModelParts", (byte)0);
            }
            if (nbt.method_10545("MainArm")) {
                this.mainArm = nbt.method_68562("MainArm", (byte)0) == class_1306.field_6182.method_7362() ? class_1306.field_6182 : class_1306.field_6183;
            }
            this.updateDisplay();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public VisualGraveData toVisualGraveData() {
        if (this.visualData == null) {
            this.updateDisplay();
        }
        return this.visualData;
    }

    public Map<String, class_2561> getPlaceholders(MinecraftServer server) {
        Config config = ConfigManager.getConfig();
        long protectionTime = GraveManager.INSTANCE.getProtectionTime() > -1 ? this.getTimeLeft(GraveManager.INSTANCE.getProtectionTime(), config.protection.useRealTime) : Long.MAX_VALUE;
        long breakTime = GraveManager.INSTANCE.getBreakingTime() > -1 ? this.getTimeLeft(GraveManager.INSTANCE.getBreakingTime(), config.protection.useRealTime) : Long.MAX_VALUE;
        HashMap<String, class_2561> values = new HashMap<String, class_2561>();
        values.put("player", (class_2561)class_2561.method_43470((String)(this.gameProfile != null && this.gameProfile.getName() != null ? this.gameProfile.getName() : "<No player!>")));
        values.put("protection_time", (class_2561)class_2561.method_43470((String)(GraveManager.INSTANCE.getProtectionTime() > -1 ? config.getFormattedTime(protectionTime) : config.texts.infinityText)));
        values.put("break_time", (class_2561)class_2561.method_43470((String)(GraveManager.INSTANCE.getBreakingTime() > -1 ? config.getFormattedTime(breakTime) : config.texts.infinityText)));
        values.put("xp", (class_2561)class_2561.method_43470((String)("" + this.xp)));
        values.put("item_count", (class_2561)class_2561.method_43470((String)("" + this.itemCount)));
        values.put("position", (class_2561)class_2561.method_43470((String)this.location.blockPos().method_23854()));
        values.put("world", GraveUtils.toWorldName(this.location.world()));
        values.put("death_cause", this.deathCause);
        values.put("minecraft_day", (class_2561)class_2561.method_43470((String)("" + this.minecraftDay)));
        values.put("creation_date", (class_2561)class_2561.method_43470((String)config.texts.fullDateFormat.format().format(new Date(this.creationTime * 1000L))));
        values.put("since_creation", (class_2561)class_2561.method_43470((String)config.getFormattedTime(System.currentTimeMillis() / 1000L - this.creationTime)));
        values.put("id", (class_2561)class_2561.method_43470((String)("" + this.id)));
        values.put("cost", config.interactions.cost.toText());
        return values;
    }

    public boolean shouldNaturallyBreak() {
        int time = GraveManager.INSTANCE.getBreakingTime();
        if (time > -1) {
            long breakTime = this.getTimeLeft(time, ConfigManager.getConfig().protection.useRealTime);
            return breakTime <= 0L;
        }
        return false;
    }

    public boolean isProtected() {
        return this.isTimeProtected() && this.isProtectionEnabled;
    }

    public boolean isTimeProtected() {
        int time = GraveManager.INSTANCE.getProtectionTime();
        if (time > -1 && GraveManager.INSTANCE.isProtectionEnabled()) {
            long protectionTime = this.getTimeLeft(time, ConfigManager.getConfig().protection.useRealTime);
            return protectionTime > 0L;
        }
        return GraveManager.INSTANCE.isProtectionEnabled();
    }

    public long getTimeLeft(int duration, boolean useRealTime) {
        return useRealTime ? this.creationTime + (long)duration - System.currentTimeMillis() / 1000L : this.gameCreationTime + (long)duration - GraveManager.INSTANCE.getCurrentGameTime();
    }

    public void disableProtection() {
        this.isProtectionEnabled = false;
    }

    public boolean canTakeFrom(GameProfile profile) {
        return !this.requirePayment && this.hasAccess(profile);
    }

    public boolean canTakeFrom(class_1657 entity) {
        return this.canTakeFrom(entity.method_7334()) || entity.method_68878() && Permissions.check((class_2172)entity.method_5671((class_3218)entity.method_37908()), (String)"graves.can_open_others", (int)3);
    }

    public boolean hasAccess(class_1657 entity) {
        return this.hasAccess(entity.method_7334()) || entity.method_68878() && Permissions.check((class_2172)entity.method_5671((class_3218)entity.method_37908()), (String)"graves.can_open_others", (int)3);
    }

    public boolean hasAccess(GameProfile profile) {
        return !this.isProtected() || this.gameProfile != null && this.gameProfile.getId().equals(profile.getId()) || this.allowedUUIDs.contains(profile.getId());
    }

    public boolean payForUnlock(class_3222 player) {
        Config cfg = ConfigManager.getConfig();
        if (!this.hasAccess(player.method_7334())) {
            if (!cfg.texts.cantPayForThisGrave.isEmpty()) {
                player.method_64398(cfg.texts.cantPayForThisGrave.text());
            }
            return false;
        }
        if (cfg.interactions.cost.checkCost(player)) {
            class_2586 class_25862;
            cfg.interactions.cost.takeCost(player);
            this.requirePayment = false;
            if (!cfg.texts.graveUnlocked.isEmpty()) {
                player.method_64398(cfg.texts.graveUnlocked.with(cfg.interactions.cost.getPlaceholders()));
            }
            if ((class_25862 = player.method_5682().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)this.location.world())).method_8321(this.location.blockPos())) instanceof GraveBlockEntity) {
                GraveBlockEntity entity = (GraveBlockEntity)class_25862;
                entity.setModelId(entity.getGraveModelId());
            }
            return true;
        }
        player.method_64398(cfg.texts.graveNotEnoughCost.with(cfg.interactions.cost.getPlaceholders()));
        return false;
    }

    public GameProfile getProfile() {
        return this.gameProfile != null ? this.gameProfile : DEFAULT_GAME_PROFILE;
    }

    public int getXp() {
        return this.xp;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public class_2561 getDeathCause() {
        return this.deathCause;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        GraveManager.INSTANCE.moveToLocation(this, location);
        this.location = location;
    }

    public boolean moveTo(MinecraftServer server, Location location) {
        class_2680 state;
        class_3218 world = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)location.world()));
        if (world != null && GraveUtils.canReplaceState(state = world.method_8320(location.blockPos()), ConfigManager.getConfig().placement.replaceAnyBlock) && world.method_8621().method_11952(location.blockPos()) && location.y() >= world.method_31607() && location.y() <= world.method_31600()) {
            class_2818 oldChunk;
            class_2586 class_25862;
            Location old = this.location;
            this.setLocation(location);
            class_3218 oldWorld = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)old.world()));
            if (oldWorld != null && (class_25862 = (oldChunk = oldWorld.method_8497(class_4076.method_18675((int)old.x()), class_4076.method_18675((int)old.z()))).method_8321(old.blockPos())) instanceof GraveBlockEntity) {
                GraveBlockEntity grave = (GraveBlockEntity)class_25862;
                grave.setGrave(null);
                grave.breakBlock(false);
            }
            world.method_8501(location.blockPos(), GravesRegistry.GRAVE_BLOCK.method_9564());
            class_2586 class_25863 = world.method_8321(location.blockPos());
            if (class_25863 instanceof GraveBlockEntity) {
                GraveBlockEntity entity = (GraveBlockEntity)class_25863;
                entity.setGrave(this, state);
            }
            return true;
        }
        return false;
    }

    public void setLocation(class_2960 identifier, class_2338 pos) {
        this.setLocation(new Location(identifier, pos));
    }

    public List<PositionedItemStack> getItems() {
        return this.items;
    }

    public void openUi(class_3222 player, boolean canModify, boolean canFetch) {
        new GraveGui(player, this, canModify, canFetch).open();
    }

    public class_1263 asInventory() {
        return ImplementedInventory.of(new class_2371<class_1799>(List.of(), null){

            @NotNull
            public class_1799 get(int index) {
                return ((PositionedItemStack)Grave.this.items.get(index)).stack();
            }

            public class_1799 set(int index, class_1799 element) {
                Validate.notNull((Object)element);
                PositionedItemStack old = (PositionedItemStack)Grave.this.items.set(index, (Object)new PositionedItemStack(element, -1, VanillaInventoryMask.INSTANCE, null, Set.of()));
                if (old != null) {
                    Grave.this.removeTaggedItem(old);
                    GraveManager.INSTANCE.method_80();
                    return old.stack();
                }
                return class_1799.field_8037;
            }

            public void add(int value, class_1799 element) {
                Validate.notNull((Object)element);
                Grave.this.items.add(value, (Object)new PositionedItemStack(element, -1, VanillaInventoryMask.INSTANCE, null, Set.of()));
                GraveManager.INSTANCE.method_80();
            }

            public class_1799 remove(int index) {
                PositionedItemStack x = (PositionedItemStack)Grave.this.items.remove(index);
                Grave.this.removeTaggedItem(x);
                GraveManager.INSTANCE.method_80();
                return x.stack();
            }

            public int size() {
                return Grave.this.items.size();
            }

            public void clear() {
                Grave.this.items.clear();
                GraveManager.INSTANCE.method_80();
            }
        }, () -> ((GraveManager)GraveManager.INSTANCE).method_80());
    }

    public void tick(MinecraftServer server) {
        this.updateSelf(server);
    }

    public void updateDisplay() {
        int i = 0;
        for (PositionedItemStack entry : this.items) {
            if (entry.isEmpty()) continue;
            ++i;
        }
        this.itemCount = i;
        this.visualData = new VisualGraveData(this.getProfile(), this.skinModelParts, this.mainArm, this.deathCause, this.creationTime, this.location, this.minecraftDay);
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public boolean isPaymentRequired() {
        return this.requirePayment;
    }

    public byte visibleSkinModelParts() {
        return this.skinModelParts;
    }

    public class_1306 mainArm() {
        return this.mainArm;
    }

    public void destroyGrave(MinecraftServer server, @Nullable class_1657 breaker) {
        class_3218 world;
        WrappedText text;
        if (this.isRemoved) {
            return;
        }
        Config config = ConfigManager.getConfig();
        class_3222 owner = this.gameProfile != null ? server.method_3760().method_14602(this.gameProfile.getId()) : null;
        GraveManager.INSTANCE.remove(this);
        this.isRemoved = true;
        boolean shouldBreak = this.shouldNaturallyBreak();
        if (owner != breaker && owner != null && !(text = !shouldBreak ? config.texts.messageGraveBroken : config.texts.messageGraveExpired).isEmpty()) {
            owner.method_64398(text.with(this.getPlaceholders(server)));
        }
        if ((world = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)this.getLocation().world()))) != null) {
            class_2586 class_25862;
            class_2818 chunk = world.method_8497(class_4076.method_18675((int)this.location.x()), class_4076.method_18675((int)this.location.z()));
            if (config.protection.dropItemsAfterExpiring || !shouldBreak) {
                class_1264.method_5451((class_1937)world, (class_2338)this.location.blockPos(), (class_1263)this.asInventory());
                GraveUtils.spawnExp(world, class_243.method_24953((class_2382)this.location.blockPos()), this.xp);
            }
            if ((class_25862 = chunk.method_8321(this.location.blockPos())) instanceof GraveBlockEntity) {
                GraveBlockEntity grave = (GraveBlockEntity)class_25862;
                grave.breakBlock();
            }
        }
    }

    public void updateSelf(MinecraftServer server) {
        GraveUtils.BlockCheckResult newPos;
        class_3218 world;
        if (this.isRemoved()) {
            return;
        }
        Config config = ConfigManager.getConfig();
        if (this.tryBreak(server, null)) {
            return;
        }
        if (config.placement.activelyMoveInsideBorder && config.placement.moveInsideBorder && (world = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)this.getLocation().world()))) != null && !world.method_8621().method_11952(this.location.blockPos()) && (newPos = GraveUtils.findGravePosition(this.gameProfile, null, world, this.location.blockPos(), config.placement.maxPlacementDistance, config.placement.replaceAnyBlock)).result().canCreate()) {
            this.moveTo(server, this.location.withPos(newPos.pos()));
        }
        if (!this.utilProtectionChangeMessage && !this.isProtected()) {
            this.utilProtectionChangeMessage = true;
            if (!config.texts.messageProtectionEnded.isEmpty()) {
                class_3222 player;
                class_3222 class_32222 = player = this.gameProfile != null ? server.method_3760().method_14602(this.gameProfile.getId()) : null;
                if (player != null) {
                    player.method_64398(config.texts.messageProtectionEnded.with(this.getPlaceholders(server)));
                }
            }
        }
    }

    public boolean tryBreak(MinecraftServer server, @Nullable class_1657 player) {
        if (this.shouldNaturallyBreak() || this.isEmpty()) {
            this.destroyGrave(server, player);
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        if (ConfigManager.getConfig().storage.canStoreOnlyXp && this.xp != 0) {
            return false;
        }
        for (PositionedItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void quickEquip(class_3222 player) {
        try {
            if (player.method_5805() && this.hasAccess((class_1657)player)) {
                if (this.requirePayment && !this.payForUnlock(player)) {
                    return;
                }
                for (PositionedItemStack item : this.items) {
                    if (item.isEmpty() || item.inventoryMask() == null) continue;
                    item.inventoryMask().moveToPlayerExactly(player, item.stack(), item.slot(), item.optionalData());
                }
                for (PositionedItemStack item : this.items) {
                    if (item.isEmpty() || item.inventoryMask() != null && item.inventoryMask().moveToPlayerClosest(player, item.stack(), item.slot(), item.optionalData())) continue;
                    VanillaInventoryMask.INSTANCE.moveToPlayerClosest(player, item.stack(), -1, null);
                }
                GraveUtils.grandExperience((class_1657)player, this.xp);
                this.xp = 0;
                this.tryBreak(player.method_5682(), (class_1657)player);
                this.updateSelf(player.method_5682());
                GraveManager.INSTANCE.method_80();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            GraveManager.INSTANCE.method_80();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grave graveInfo = (Grave)o;
        return this.id == graveInfo.id;
    }

    public int hashCode() {
        return (int)(31L * this.id);
    }

    public long getId() {
        return this.id;
    }

    void setId(long requestId) {
        this.id = requestId;
    }

    public class_1799 getTaggedItem(class_2960 identifier) {
        List<PositionedItemStack> list = this.taggedStacks.get(identifier);
        if (list != null && !list.isEmpty()) {
            return list.getFirst().stack();
        }
        return class_1799.field_8037;
    }

    public boolean isOwner(class_3222 player) {
        return this.gameProfile != null && player.method_5667().equals(this.gameProfile.getId());
    }
}

