/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.ui;

import com.mojang.authlib.GameProfile;
import eu.pb4.graves.GraveTextures;
import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.grave.Grave;
import eu.pb4.graves.grave.GraveManager;
import eu.pb4.graves.ui.GuiSlot;
import eu.pb4.graves.ui.PagedGui;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class GraveListGui
extends PagedGui {
    private final UUID targetUUID;
    private final boolean canModify;
    private int ticker = 0;
    private List<Grave> graves;
    private boolean canFetch;

    public GraveListGui(class_3222 player, GameProfile profile, boolean canModify, boolean canFetch) {
        super(player);
        this.targetUUID = profile.getId();
        this.setTitle(ConfigManager.getConfig().ui.graveTitle.with(Map.of("player", class_2561.method_43470((String)profile.getName()))));
        this.graves = new ArrayList<Grave>(GraveManager.INSTANCE.getByUuid(this.targetUUID));
        this.canModify = canModify;
        this.canFetch = canFetch;
        this.updateDisplay();
    }

    @Override
    protected int getPageAmount() {
        return this.graves.size() / 36 + 1;
    }

    @Override
    protected GuiSlot getElement(int id) {
        if (id < this.graves.size()) {
            Config config = ConfigManager.getConfig();
            Grave grave = this.graves.get(id);
            Map<String, class_2561> placeholders = grave.getPlaceholders(this.player.method_5682());
            GuiElementBuilder element = config.ui.listGraveIcon.get(grave.isProtected()).builder(placeholders).setCallback((index, type, action) -> grave.openUi(this.player, this.canModify, this.canFetch));
            return GuiSlot.of(element);
        }
        return GuiSlot.empty();
    }

    @Override
    protected GuiSlot getNavElement(int id) {
        return switch (id) {
            case 2 -> GuiSlot.previousPage(this);
            case 6 -> GuiSlot.nextPage(this);
            default -> GraveTextures.hasGuiTexture(this.player) ? GuiSlot.empty() : GuiSlot.filler();
        };
    }

    public void onTick() {
        ++this.ticker;
        if (this.ticker % 20 == 0) {
            this.graves = new ArrayList<Grave>(GraveManager.INSTANCE.getByUuid(this.targetUUID));
            this.updateDisplay();
        }
        super.onTick();
    }
}

